/*
 * @(#)OrganicTreeUI.java	1.8 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.text.DefaultTextUI;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.util.*;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.TreeUI;
import com.sun.java.swing.tree.*;

import com.sun.java.swing.plaf.basic.*;

/**
 * Organic L&F for a tree component.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.14 01/13/98
 * @author Tom Santos
 */
public class OrganicTreeUI extends BasicTreeUI {

    // Boilerplate
    public static ComponentUI createUI(JComponent x) {
	return new OrganicTreeUI();
    }

    public OrganicTreeUI()
    {
	super();
    }

    protected int getHorizontalLegBuffer()
      {
	return 3;
      } 

    public void installUI( JComponent c ) {
        super.installUI( c );
	if ( !tree.isLargeModel() ) {
	    setRowHeight( 0 );
	}
    }

    protected boolean clickedInExpandControl( VisibleTreeNode node, LargeTreeModelNode eNode,
					      int row, int rowLevel, int mouseX, int mouseY )
      {
	if ( node != null && node.isLeaf() )
	  {
	    return false;
	  }

	int                     boxWidth;

	if(getExpandedIcon() != null)
	    boxWidth = getExpandedIcon().getIconWidth() + 6;
	else
	    boxWidth = 8;
	int    boxLeftX;
	if(this.getShowsRootHandles())
	    boxLeftX = ((rowLevel * totalChildIndent) +
			getLeftChildIndent()) - boxWidth/2;
	else
	    boxLeftX = (((rowLevel - 1) * totalChildIndent) +
			getLeftChildIndent()) - boxWidth/2;
	int boxRightX = boxLeftX + boxWidth;
	
	return mouseX >= boxLeftX && mouseX <= boxRightX;
      }

    static protected final int SIZE = 3;

    /**
     * Icon that displays the expanded or collapsed state of a node.
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    public static class ExpandCollapseIcon implements Icon, Serializable {
	public void paintIcon(Component c, Graphics g, int x, int y) {
	    g.setColor( UIManager.getColor("Tree.knobColor") );
	    g.fillRect( x, y, SIZE, SIZE );
	}
	public int getIconWidth() { return SIZE; }
	public int getIconHeight() { return SIZE; }
    }
}
