/*
 * @(#)OrganicToolTipUI.java	1.5 98/02/23
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */

package com.sun.java.swing.plaf.organic;


import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.BasicToolTipUI;


/**
 * A Java L&F extension of BasicToolTipUI.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.5 02/23/98
 * @author Steve Wilson
 */
public class OrganicToolTipUI extends BasicToolTipUI 
                           implements MouseMotionListener{

    static OrganicToolTipUI sharedInstance = new OrganicToolTipUI();
			     
   	     
    static JToolTip tip;
    public static final int padSpaceBetweenStrings = 6;


    public OrganicToolTipUI() {
        super();
    }

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }


    public void installUI(JComponent c) {
	tip = (JToolTip)c;
        super.installUI(c);
    }
			     
    protected void installListeners(JComponent c) {
      SwingUtilities.invokeLater( new Runnable() {
	public void run() {
        tip.getComponent().addMouseMotionListener(OrganicToolTipUI.this);
	}
      });
    }

    protected void uninstallListener(JComponent c) {
        tip.getComponent().removeMouseMotionListener(this);
    }


    public void paint(Graphics g, JComponent c) {

        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(g.getFont());
        Dimension size = c.getSize();

        g.setColor(c.getBackground());
        g.fillRect(0, 0, size.width, size.height);
	g.setColor(OrganicLookAndFeel.getBlack());
	g.drawLine(0, size.height-2, size.width, size.height-2);

	g.setColor(c.getForeground());
	String tipText = ((JToolTip)c).getTipText();
	String keyText = getAcceleratorString();
        g.drawString(tipText, 3, 2 + metrics.getAscent());
	g.setColor(OrganicLookAndFeel.getLightAccent3());
	if (! (keyText.equals(""))) {  // only draw control key if there is one
	    g.drawString(keyText, 
		         metrics.stringWidth(tipText) + 3 + padSpaceBetweenStrings, 
		         2 + metrics.getAscent());
	}

    }

    public Dimension getPreferredSize(JComponent c) {
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(c.getFont());

	Dimension d = new Dimension(metrics.stringWidth(((JToolTip)c).getTipText()) + 6,
                             metrics.getHeight() + 4);

	String key = getAcceleratorString();
	if (! (key.equals("")))
	    d.width += metrics.stringWidth(key) + padSpaceBetweenStrings;
        return d;
    }


    /**
      * implemented for MouseMotionListener.
      * Move the tooltip to the right place when motion occurs
      */
    public void mouseMoved(MouseEvent e) {
        Component source = (Component)e.getSource();
	Point compLoc = (source).getLocationOnScreen();
	Frame f = null;
	Component parent = source;
	while (f == null) {  // find the frame which encloses the given component
	    parent = parent.getParent();
	    if (parent instanceof Frame) {
	        f = (Frame)parent;
	    } // end if
	} // end while
	Point frameLoc = f.getLocationOnScreen();
	Dimension size = tip.getSize();
	final int magicMouseFudgeFactor = 20;  // this matches the number hard coded into ToolTipManager
	int tipX = compLoc.x + e.getX();
	int tipY = compLoc.y + e.getY()+magicMouseFudgeFactor;

        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	// force tooltip onscreen
        if (tipX + size.width > screenSize.width) {
              tipX -= size.width;
        }
        if (tipY + size.height > screenSize.height) {
            tipY -= (size.height + magicMouseFudgeFactor);
        }
	// move the tooltip to the new location
	tip.getParent().setLocation(tipX, tipY);
    }

    public void mouseDragged(MouseEvent e) {} // stubbed to fill MouseMotionListener requirements
	     
    public String getAcceleratorString() {
	KeyStroke[] keys = tip.getComponent().getRegisteredKeyStrokes();
	String controlKeyStr = "";

	for (int i = 0; i < keys.length; i++) {

	  char c = (char)keys[i].getKeyCode();
	  int mod = keys[i].getModifiers();
	  if ( mod == InputEvent.CTRL_MASK ) {
	      controlKeyStr = "cntl+"+(char)keys[i].getKeyCode();
	      break;
	  } else if (mod == InputEvent.ALT_MASK) {
	      controlKeyStr = "alt+"+(char)keys[i].getKeyCode();
	      break;
	  } 
	}
	return controlKeyStr;
    }

}
