/*
 * @(#)OrganicToolBarUI.java	1.6 98/02/06
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.*;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.*;
import java.util.*;
import java.io.Serializable;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;

import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.*;

/**
 * An Organic Look and Feel implementation of ToolBarUI.  This implementation 
 * is a "combined" view/controller.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.6 02/06/98
 * @author Jeff Shapiro
 */
public class OrganicToolBarUI extends BasicToolBarUI implements ContainerListener
{
    protected static Border rolloverBorder = new CompoundBorder( new OrganicRolloverButtonBorder(),
 								 new ToolBarButtonMargin() );
    protected Hashtable borderTable = new Hashtable();

    protected ContainerListener contListener;

    private boolean rolloverBorders = false;

    private PropertyChangeListener rolloverListener;

    protected static String IS_ROLLOVER = "JToolBar.isRollover";

    public static ComponentUI createUI(JComponent c)
    {
	return new OrganicToolBarUI();
    }

    public void installUI( JComponent c )
    {
        rolloverListener = new RolloverListener();
	c.addPropertyChangeListener( rolloverListener );

        super.installUI( c );

	Object rolloverProp = c.getClientProperty( IS_ROLLOVER );
	if ( rolloverProp != null )
	{
	    setRolloverBorders( ((Boolean)rolloverProp).booleanValue() );
	}
    }

    public void uninstallUI( JComponent c )
    {
        c.removePropertyChangeListener( rolloverListener );

        super.uninstallUI( c );

	setRolloverBorders( false );
   }

    protected void installListeners(JComponent c) {
        super.installListeners(c);
        if ((contListener = createContainerListener(c)) != null) {
            c.addContainerListener(contListener);
        }
    }

    protected void uninstallListeners(JComponent c) {
        super.uninstallListeners(c);
        if (contListener != null) {
            c.removeContainerListener(contListener);
            contListener = null;
        }
    }

    protected ContainerListener createContainerListener(JComponent c) {
        return this;
    }

    public boolean isRolloverBorders()
    {
        return rolloverBorders;
    }

    public void setRolloverBorders( boolean rollover )
    {
        if ( rolloverBorders != rollover )
	{
	    rolloverBorders = rollover;
	    
	    if ( rolloverBorders )
	        installRolloverBorders( toolBar );
	    else
	        removeRolloverBorders( toolBar );
	}
    }

    protected void installRolloverBorders ( JComponent c )
    {
	// Put rollover borders on buttons
	Component[] components = c.getComponents();
	for ( int i = 0; i < components.length; ++i ) {
	  if ( components[ i ] instanceof JComponent ) {
	      ((JComponent)components[ i ]).updateUI();
	      setBorderToRollover( components[ i ] );
	  }
	}
    }

    protected void removeRolloverBorders ( JComponent c )
    {
	// Remove the rollover borders from buttons
	Component[] components = c.getComponents();
	for ( int i = 0; i < components.length; ++i ) {
	    setBorderToNormal( components[ i ] );
	}
    }

    protected void setBorderToRollover( Component c ) {
        if ( c instanceof JButton ) {
	    JButton b = (JButton)c;
	    if ( b.getUI() instanceof OrganicButtonUI ) {
	        OrganicButtonUI buttonUI = (OrganicButtonUI)b.getUI();
	        if ( b.getBorder() instanceof UIResource ) {
		    borderTable.put( b, b.getBorder() );
		    b.setBorder( rolloverBorder );
		}
	    }
	}
    }

    protected void setBorderToNormal( Component c ) {
        if ( c instanceof JButton ) {
	    JButton b = (JButton)c;
	    if ( b.getUI() instanceof OrganicButtonUI ) {
	        OrganicButtonUI buttonUI = (OrganicButtonUI)b.getUI();
	        if ( b.getBorder() == rolloverBorder ) {
		    b.setBorder( (Border)borderTable.remove( b ) );
		}
	    }
	}
    }

    // ContainerListener overrides

    public void componentAdded( ContainerEvent e )
    {
        if ( rolloverBorders )
	{
	    Component c = e.getChild();
	    setBorderToRollover( c );
	}
    }

    public void componentRemoved( ContainerEvent e )
    {
        if ( rolloverBorders )
	{
	    Component c = e.getChild();
	    setBorderToNormal( c );
	}
    }

  class RolloverListener implements PropertyChangeListener, Serializable {
    public void propertyChange(PropertyChangeEvent e) {
	String name = e.getPropertyName();
	if ( name.equals( IS_ROLLOVER ) ) {
	    if ( e.getNewValue() != null ) {
	        setRolloverBorders( ((Boolean)e.getNewValue()).booleanValue() );
	    }
	    else {
		setRolloverBorders( false );
	    }
        }
    }
  } // end class RolloverListener

}


class ToolBarButtonMargin extends AbstractBorder implements Serializable {
    public Insets getBorderInsets(Component c) {
        return new Insets(3, 3, 3, 3);        
    }
}


