/*
 * @(#)OrganicToggleButtonUI.java	1.5 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.organic;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.plaf.basic.BasicToggleButtonUI;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.*;

import java.io.Serializable;

/**
 * OrganicToggleButton implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.5 02/02/98
 * @author Tom Santos
 */
public class OrganicToggleButtonUI extends BasicToggleButtonUI {
  // Colors


    private static Color selectedColor;
    private static Color disabledTextColor;
    private static Color focusColor;
    private static Color focusHighlightColor;

    private static final int defaultTextIconGap = 4;
    private final static Insets defaultMargin = new Insets(2,14,2,14);

    private static final OrganicToggleButtonUI organicToggleButtonUI = new OrganicToggleButtonUI();

    public static ComponentUI createUI(JComponent b) {
        return organicToggleButtonUI;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
	selectedColor = UIManager.getColor("ToggleButton.selected");
	disabledTextColor = UIManager.getColor("ToggleButton.disabledText");
	focusColor = UIManager.getColor("ToggleButton.focus");
	focusHighlightColor = UIManager.getColor("ToggleButton.focusHighlight");
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton) c;
        JToggleButton.ToggleButtonModel model = (JToggleButton.ToggleButtonModel)b.getModel();

        Dimension size = b.getSize();
        FontMetrics fm = g.getFontMetrics();

	Insets i = c.getInsets();

        Rectangle viewRect = new Rectangle(size);

	viewRect.x += i.left;
	viewRect.y += i.top;
	viewRect.width -= (i.right + viewRect.x);
	viewRect.height -= (i.bottom + viewRect.y);

        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();

	Font f = c.getFont();
	g.setFont(f);

	// layout the text and icon
        String text = SwingUtilities.layoutCompoundLabel(
	    fm, b.getText(), b.getIcon(),
	    b.getVerticalAlignment(), b.getHorizontalAlignment(),
	    b.getVerticalTextPosition(), b.getHorizontalTextPosition(),
	    viewRect, iconRect, textRect, b.getText() == null ? 0 : defaultTextIconGap
	);

        // Draw background?
        if ( model.isArmed() && model.isPressed() ) {
	    if ( model.isSelected() ) {
	        g.setColor( c.getBackground() );
	    }
	    else {
	        g.setColor( selectedColor );
	    }
	    g.fillRect( 2, 2, size.width-4, size.height-4 );
	}
	else if ( model.isSelected() ) {
	    g.setColor( selectedColor );
	    g.fillRect( 2, 2, size.width-4, size.height-4 );
	}
	else {
	    g.setColor(b.getBackground());
	    if(c.isOpaque()) {
	        g.fillRect(0,0, size.width, size.height);
	    }
	}

	// Paint the Icon
	Icon icon = null;
        if(b.getIcon() != null) { 

            if(!model.isEnabled()) {
                icon = (Icon) b.getDisabledIcon();
            } else if(model.isPressed() && model.isArmed()) {
                icon = (Icon) b.getPressedIcon();
                if(icon == null) {
                    // Use selected icon
                    icon = (Icon) b.getSelectedIcon();
                } 
            } else if(model.isSelected()) {
                icon = (Icon) b.getSelectedIcon();
	    } else if(b.isRolloverEnabled() && model.isRollover()) {
                icon = (Icon) b.getRolloverIcon();
            } 
	      
	    if(icon == null) {
		icon = (Icon) b.getIcon();
	    }
	       
	    icon.paintIcon(c, g, iconRect.x, iconRect.y);
        }

	int shift_offset = 0;

	// Draw the Text
        if(text != null && !text.equals("")) {
            if(model.isEnabled()) {
                g.setColor( c.getForeground() );
            }
	    else {
	        g.setColor( disabledTextColor );
            }

	    if ( model.isSelected() || (model.isPressed() && model.isArmed()) ) {
	        --textRect.x;
		shift_offset = 1;
	    }

	    OrganicUtilities.drawString(g,text, model.getMnemonic(),
				    textRect.x,
				    textRect.y + fm.getAscent());
        }
	  
	// draw the dashed focus line.
	boolean isIcon = b.getIcon() != null;
	if (b.isFocusPainted() && b.hasFocus()) {
	    // Draw each dash of the line pixel by pixel.
	    // The performance of this is surely poor -- Be sure
	    // to rewrite when 2d graphics package is ready.
	    Rectangle focusRect = new Rectangle();

	    // If there is text
	    if ( text != null & !text.equals( "" ) ) {
	        if ( !isIcon ) {
		  focusRect.setBounds( textRect );
		}
		else {
		    focusRect.setBounds( iconRect.union( textRect ) );
		}
	    }
	    // If there is an icon and no text
	    else if ( isIcon ) {
	        focusRect.setBounds( iconRect );
	    }

	    g.setColor(focusHighlightColor);
	    g.drawRect((focusRect.x-1) - shift_offset, (focusRect.y-1) - shift_offset,
		       focusRect.width+2, focusRect.height+2 );
	    g.setColor(focusColor);
	    OrganicUtilities.drawDashedRect(g, (focusRect.x-1) - shift_offset, (focusRect.y-1) - shift_offset,
					focusRect.width+3, focusRect.height+3 );
	}
    }

    /**
     * insets and margin
     */

    public Insets getDefaultMargin(AbstractButton b) {
	return defaultMargin;
    }

  /**
   * Button border.
   * <p>
   * Warning: serialized objects of this class will not be compatible with
   * future swing releases.  The current serialization support is appropriate
   * for short term storage or RMI between Swing1.0 applications.  It will
   * not be possible to load serialized Swing1.0 objects with future releases
   * of Swing.  The JDK1.2 release of Swing will be the compatibility
   * baseline for the serialized form of Swing objects.
   */
  static class OrganicToggleButtonBorder extends OrganicButtonBorder {
      boolean isSelected = false;

      protected int getDefaultBorderWidth() { return 0; }

      protected Color getTopLeftColor() {
  	  return isSelected ? super.getPressedTopLeftColor() : super.getTopLeftColor();
      }

      protected Color getBottomRightColor() {
	  return isSelected ? super.getPressedBottomRightColor() : super.getBottomRightColor();
      }

      public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
	  isSelected = ((JToggleButton.ToggleButtonModel)(((AbstractButton)c).getModel())).isSelected();
	  super.paintBorder( c, g, x, y, w, h );
      }
  }
}
