/*
 * @(#)OrganicTheme.java	1.2 98/01/30
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.plaf.*;
import com.sun.java.swing.*;

/**
 * This interface acts as a generic way to describe the colors
 * used by Organic.  Classes which implement this interface can
 * be used to swap the colors in a Organic application.
 *
 * @version 1.2 01/30/98
 * @author Steve Wilson
 */

public abstract class OrganicTheme {

    public abstract ColorUIResource getControl1();  // these are khaki in Organic default L&F
    public abstract ColorUIResource getControl2();
    public abstract ColorUIResource getControl3();
    public abstract ColorUIResource getControl4();

    public abstract ColorUIResource getHighlight1();  // these are green in Organic default L&F
    public abstract ColorUIResource getHighlight2();
    public abstract ColorUIResource getHighlight3();
    public abstract ColorUIResource getHighlight4();

    public abstract ColorUIResource getDarkAccent1();  // these are purple in Organic default L&F
    public abstract ColorUIResource getDarkAccent2();
    public abstract ColorUIResource getDarkAccent3();
    public abstract ColorUIResource getDarkAccent4();

    public abstract ColorUIResource getLightAccent1();  // these are orange in Organic default L&F
    public abstract ColorUIResource getLightAccent2();
    public abstract ColorUIResource getLightAccent3();
    public abstract ColorUIResource getLightAccent4();

    public abstract ColorUIResource getWhite();
    public abstract ColorUIResource getBlack();

    public abstract ColorUIResource getDesktopColor();

    public abstract String getName();

    public abstract FontUIResource getControlTextFont();
    public abstract FontUIResource getUserTextFont();
    public abstract FontUIResource getMenuTextFont();
    public abstract FontUIResource getEmphasisTextFont();

    public ColorUIResource getFocusColor() { return getHighlight4(); }

    public ColorUIResource getSystemTextColor() { return getHighlight4(); }
    public ColorUIResource getControlTextColor() { return getBlack(); }  
    public ColorUIResource getInactiveSystemTextColor() { return getControl2(); }
    public ColorUIResource getUserTextColor() { return getBlack(); }
    public ColorUIResource getTextHighlightColor() { return getHighlight4(); }
    public ColorUIResource getHighlightedTextColor() { return getLightAccent1(); }

    public ColorUIResource getWindowBackground() { return getLightAccent1(); }
    public ColorUIResource getWindowTitleBackground() { return getControl2(); }  
    public ColorUIResource getWindowTitleInactiveBackground() { return getControl1(); }
    public ColorUIResource getWindowTitleForeground() { return getBlack(); }
    public ColorUIResource getWindowTitleInactiveForeground() { return getBlack(); }
    public ColorUIResource getPaletteTitleBackground() { return getHighlight3(); }
    public ColorUIResource getPaletteTitleForeground() { return getLightAccent1(); }
    public ColorUIResource getWindowFrameTop() { return getLightAccent4(); }   
    public ColorUIResource getWindowFrameBottom() { return getControl3(); }   
    public ColorUIResource getWindowFrameRight() { return getDarkAccent4(); }   
    public ColorUIResource getWindowFrameLeft() { return getHighlight4(); }   
    public ColorUIResource getWindowFrameInactive() { return getControl2(); }   

    public ColorUIResource getMenuBackground() { return getControl1(); }
    public ColorUIResource getMenuForeground() { return  getHighlight4(); }
    public ColorUIResource getMenuSelectedBackground() { return getLightAccent1(); }
    public ColorUIResource getMenuSelectedForeground() { return getBlack(); }
    public ColorUIResource getMenuItemForeground() { return  getBlack(); }
    public ColorUIResource getMenuItemSelectedForeground() { return  getSystemTextColor(); }

    public void addCustomEntriesToTable(UIDefaults table) {}
}
