/*
 * @(#)OrganicTextFieldUI.java	1.4 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.BasicTextFieldUI;

/**
 * Provides the Organic Look and Feel for a text field.  
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @author  Steve Wilson
 * @version 1.4 02/02/98
 */
public class OrganicTextFieldUI extends BasicTextFieldUI
                            implements FocusListener{

    /**
     * Creates a UI for a JTextField.
     *
     * @param c the text field
     * @return the UI
     */
    public static ComponentUI createUI(JComponent c) {
        return new OrganicTextFieldUI();
    }

    /**
     * Creates a new OrganicTextFieldUI.
     */
    public OrganicTextFieldUI() {
	super();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
	c.addFocusListener(this);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
	c.removeFocusListener(this);
    }

    public void focusGained(FocusEvent e) {
        JTextField f = (JTextField)e.getSource();
	if (f.getBackground() instanceof UIResource)
	    f.setBackground(UIManager.getColor("TextField.activeBackground"));
	if (f.getBorder() instanceof UIResource)
            f.setBorder(UIManager.getBorder("TextField.activeBorder"));
	f.repaint();
    }

    public void focusLost(FocusEvent e) {
        JTextField f = (JTextField)e.getSource();
	if (f.getBackground() instanceof UIResource)
	    f.setBackground(UIManager.getColor("TextField.background"));
	if (f.getBorder() instanceof UIResource)
            f.setBorder(UIManager.getBorder("TextField.border"));
	f.repaint();
    }
}
