/*
 * @(#)OrganicTextBorder.java	1.4 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */

package com.sun.java.swing.plaf.organic;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Component;
import java.awt.Color;
import com.sun.java.swing.border.*;

/**
 * A class which provides the border style used by OrganicTextFields
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.4 02/02/98
 * @author Steve Wilson
 */
public class OrganicTextBorder extends MatteBorder {
     private static final int topPad = 3;
     private static final int bottomPad = 3; 
     private static final int rightPad = 4;
     private static final int leftPad = 4;
     protected boolean isActive = false;

     public OrganicTextBorder(Color c)   {
        super(topPad, leftPad, bottomPad, rightPad, c);
	if (c == OrganicLookAndFeel.getLightAccent1())
	    isActive = true;
     }


    /**
      * override from MatteBorder
      */
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);

	super.paintBorder(c, g, x, y, width, height);
	if (isActive)
	    g.setColor(OrganicLookAndFeel.getControl1());
	else
	    g.setColor(OrganicLookAndFeel.getControl3());
	g.fillRect( 1, height - (bottomPad+1), 2, 2);
	g.fillRect( width-3, height - (bottomPad+1), 2, 2);
	
	g.drawLine( 4, height-bottomPad, width-5, height-bottomPad );
	//for (int xDot = 5; xDot < width-3; xDot+=2) {
	//    g.fillRect( xDot, height-bottomPad, 1,1);
	//}

        g.translate(-x, -y);
        g.setColor(oldColor);

    }


}
