/*
 * @(#)OrganicTextAreaUI.java	1.4 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import java.awt.*;
import java.awt.event.KeyEvent;
import java.awt.event.InputEvent;
import com.sun.java.swing.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.BasicTextAreaUI;

/**
 * Provides the Organic Look and Feel for a plain text editor.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @author  Steve Wilson
 * @version 1.4 02/02/98
 */
public class OrganicTextAreaUI extends BasicTextAreaUI {

    /**
     * Creates a UI for a JTextArea.
     *
     * @param ta a text area
     * @return the UI
     */
    public static ComponentUI createUI(JComponent ta) {
        return new OrganicTextAreaUI();
    }

    /**
     * Constructs a new OrganicTextAreaUI object.
     */
    public OrganicTextAreaUI() {
	super();
    }

    /**
     * Installs the background and selection color for the text editor
     *
     * @param c a component
     * @see com.sun.java.swing.plaf.ComponentUI#installUI
     */
    public void installUI(JComponent c) {
	super.installUI(c);
    }

    /**
      * gonna need this later when we get the defaults mechanism in place (sdw)
      */
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }
  
}
