/*
 * @(#)OrganicSliderUI.java	1.5 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.plaf.basic.BasicSliderUI;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Point;
import java.awt.Insets;
import java.awt.Color;
import java.io.Serializable;
import java.awt.IllegalComponentStateException;
import java.awt.Polygon;
import java.beans.*;

import com.sun.java.swing.border.AbstractBorder;

import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.plaf.*;

/**
 * A Java L&F implementation of SliderUI.  
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.5 02/02/98
 * @author Tom Santos
 */
public class OrganicSliderUI extends BasicSliderUI implements PropertyChangeListener {
  
    protected boolean filledSlider = false;
    protected static Color thumbColor;
    protected static Color highlightColor;
    protected static Color darkShadowColor;


    protected final String SLIDER_FILL = "JSlider.isFilled";

    public static ComponentUI createUI(JComponent c)    {
        return new OrganicSliderUI();
    }

    public OrganicSliderUI() {
        super( null );
    }

    public void installUI( JComponent c ) {
        super.installUI( c );

	thumbColor = UIManager.getColor("Slider.thumb");
	highlightColor = UIManager.getColor("Slider.highlight");
	darkShadowColor = UIManager.getColor("Slider.darkShadow");

	scrollListener.setScrollByBlock( false );

	c.addPropertyChangeListener( this ); // add to listen for filled slider change

	Object sliderFillProp = c.getClientProperty( SLIDER_FILL );
	if ( sliderFillProp != null ) {
	    filledSlider = ((Boolean)sliderFillProp).booleanValue();
	}
    }

    public void uninstallUI( JComponent c ) {
 	c.removePropertyChangeListener( this );
	super.uninstallUI( c );
    }

    public void propertyChange( PropertyChangeEvent e ) {  // listen for slider fill
        super.propertyChange( e );

	String name = e.getPropertyName();
	if ( name.equals( SLIDER_FILL ) ) {
	    if ( e.getNewValue() != null ) {
	        filledSlider = ((Boolean)e.getNewValue()).booleanValue();
	    }
	    else {
		filledSlider = false;
	    }
        }
    }

    public void paintThumb(Graphics g)  {

	Rectangle knobBounds = getThumbRect();
        g.translate( knobBounds.x, knobBounds.y );

	Color triangleColor;
	Color ditherColor1;
	Color ditherColor2;

	if ( slider.isEnabled() ) {
	    triangleColor = thumbColor;
	    ditherColor1 = darkShadowColor;
	    ditherColor2 = slider.getForeground();
	}
	else {
	    triangleColor = slider.getForeground();
	    ditherColor1 = slider.getForeground();
	    ditherColor2 = slider.getBackground();
	}

        boolean isVertical = slider.getOrientation() == JSlider.VERTICAL;

	// Draw triangle
        g.setColor( triangleColor );
	drawLine( g, knobBounds.width, 0, 0, 14, 0, isVertical );
	fillRect( g, knobBounds.width, 1, 1, 13, 2, isVertical );
	fillRect( g, knobBounds.width, 2, 3, 11, 2, isVertical );
	fillRect( g, knobBounds.width, 3, 5, 9, 2, isVertical );
	fillRect( g, knobBounds.width, 4, 7, 7, 2, isVertical );
	fillRect( g, knobBounds.width, 5, 9, 5, 2, isVertical );
	fillRect( g, knobBounds.width, 6, 11, 3, 2, isVertical );
	drawLine( g, knobBounds.width, 7, 13, 7, 14, isVertical );

	// Draw dither
	g.setColor( ditherColor1 );
	drawLine( g, knobBounds.width, 0, 1, 0, 1, isVertical );
	drawLine( g, knobBounds.width, 14, 1, 14, 1, isVertical );
	drawLine( g, knobBounds.width, 1, 3, 1, 4, isVertical );
	drawLine( g, knobBounds.width, 13, 3, 13, 4, isVertical );
	drawLine( g, knobBounds.width, 2, 5, 2, 6, isVertical );
	drawLine( g, knobBounds.width, 12, 5, 12, 6, isVertical );
	drawLine( g, knobBounds.width, 3, 7, 3, 8, isVertical );
	drawLine( g, knobBounds.width, 11, 7, 11, 8, isVertical );
	drawLine( g, knobBounds.width, 4, 9, 4, 9, isVertical );
	drawLine( g, knobBounds.width, 10, 9, 10, 9, isVertical );
	drawLine( g, knobBounds.width, 5, 11, 5, 11, isVertical );
	drawLine( g, knobBounds.width, 9, 11, 9, 11, isVertical );
	drawLine( g, knobBounds.width, 6, 13, 6, 13, isVertical );
	drawLine( g, knobBounds.width, 8, 13, 8, 13, isVertical );

	if ( slider.isEnabled() ) {
	  g.setColor( ditherColor2 );
	  drawLine( g, knobBounds.width, 0, 2, 0, 2, isVertical );
	  drawLine( g, knobBounds.width, 14, 2, 14, 2, isVertical );
	  drawLine( g, knobBounds.width, 4, 10, 4, 10, isVertical );
	  drawLine( g, knobBounds.width, 10, 10, 10, 10, isVertical );
	  drawLine( g, knobBounds.width, 5, 12, 5, 12, isVertical );
	  drawLine( g, knobBounds.width, 9, 12, 9, 12, isVertical );
	}

	g.translate( -knobBounds.x, -knobBounds.y );
    }

    protected void drawLine( Graphics g, int knobWidth,
			     int origX1, int origY1,
			     int origX2, int origY2,
			     boolean vertical ) {
        int x1 = origX1;
	int y1 = origY1;
	int x2 = origX2;
	int y2 = origY2;

	// Rotate the line 90 degrees counterclockwise around the center
        if ( vertical ) {
	    x1 = origY1;
	    y1 = knobWidth - origX1;
	    x2 = origY2;
	    y2 = knobWidth - origX2;
	}

	g.drawLine( x1, y1, x2, y2 );
    }

    protected void fillRect( Graphics g, int knobWidth,
			     int origX, int origY,
			     int origWidth, int origHeight,
			     boolean vertical ) {
        int x = origX;
	int y = origY;
	int width = origWidth;
	int height = origHeight;

	// Rotate the rect 90 degrees counterclockwise
	if ( vertical ) {
	    x = origY;
	    y = (knobWidth - origX) - origWidth;
	    width = origHeight;
	    height = origWidth + 1; // I have no idea why I had to add 1 here. -tjs-
	}

	g.fillRect( x, y, width, height );
    }

    public void paintTrack(Graphics g)  {
	
	Rectangle trackBounds = getScrollTrackRect();

	// Draw Background
/*	if ( slider.isOpaque() ) {
	    g.setColor(slider.getBackground());
	    g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
	}*/

	boolean drawTrackBackground = slider.isEnabled();

	Color trackColor = slider.getForeground();
	Color endcapColor;
	Color backboneColor;

	if ( slider.isEnabled() ) {
	    endcapColor = OrganicLookAndFeel.getBlack();
	    backboneColor = darkShadowColor;
	}
	else {
	    trackColor = slider.getForeground();
	    endcapColor = darkShadowColor;
	    backboneColor = slider.getForeground();
	}

	g.translate( trackBounds.x, trackBounds.y );

	if( slider.getOrientation() == JSlider.HORIZONTAL ) {
	    int trackTop = (trackBounds.height - getTrackWidth()) - getThumbOverhang();
	    int trackLeft = trackBuffer;
	    int trackRight = (trackBounds.width - 1) - trackBuffer;
	    
	    // Draw track background
	    g.setColor( trackColor );

	    if ( drawTrackBackground ) {
		g.fillRect( trackLeft, trackTop, getTrackLength(), getTrackWidth() );
	    }
	    else {
	        g.drawLine( trackLeft, trackTop + getTrackWidth() - 1,
			    trackRight - 2, trackTop + getTrackWidth() - 1 );
	    }
	    
	    // Draw backbone
	    g.setColor( backboneColor );
	    g.drawLine( trackLeft, trackTop, trackRight, trackTop );
	    
	    // Draw end-caps
	    g.setColor( endcapColor );
	    g.fillRect( trackLeft, trackTop, 2, getTrackWidth() );
	    g.fillRect( trackRight, trackTop, 2, getTrackWidth() );

	    // Draw fill
	    if ( filledSlider ) {
	        Rectangle thumbBounds = getThumbRect();
		int middleOfThumb = thumbBounds.x + (thumbBounds.width / 2);

		g.setColor( OrganicLookAndFeel.getBlack() );

	        if ( !slider.getInverted() ) {
		    int fillLength = middleOfThumb - trackLeft;
		    for ( int xPos = trackLeft; xPos < middleOfThumb; xPos += 3 ) {
		        g.fillRect( xPos, trackTop+1, 2, getTrackWidth()-1 );
		    }
		}
		else {
		    int fillLength = trackRight - middleOfThumb;
		    for ( int xPos = trackRight; xPos > middleOfThumb; xPos -= 3 ) {
		        g.fillRect( xPos, trackTop+1, 2, getTrackWidth()-1 );
		    }
		}
	    }
	}
	else {  // Vertical slider
	    int trackLeft = (trackBounds.width - getTrackWidth()) - getThumbOverhang();
	    int trackTop = trackBuffer;
	    int trackBottom = trackTop + (getTrackLength() - 1);
	    int trackRight = trackLeft + getTrackWidth() - 1;
	    
	    // Draw track background
	    g.setColor( trackColor );

	    if ( drawTrackBackground ) {
	        g.fillRect( trackLeft, trackTop, getTrackWidth(), getTrackLength() );
	    }
	    else {
	        g.drawLine( trackRight, trackTop, trackRight, trackBottom );
	    }
	    
	    // Draw backbone
	    g.setColor( backboneColor );
	    g.drawLine( trackLeft, trackTop + 2, trackLeft, trackBottom);
	    
	    // Draw end-caps
	    g.setColor( endcapColor );
	    g.fillRect( trackLeft, trackTop, getTrackWidth(), 2 );
	    g.fillRect( trackLeft, trackBottom, getTrackWidth(), 2 );

	    // Draw fill
	    if ( filledSlider ) {
	        Rectangle thumbBounds = getThumbRect();
		int middleOfThumb = thumbBounds.y + (thumbBounds.height / 2);
		g.setColor( OrganicLookAndFeel.getBlack() );

	        if ( !slider.getInverted() ) {
		    int fillLength = trackBottom - middleOfThumb;
		    for ( int yPos = trackBottom; yPos > middleOfThumb; yPos -= 3 ) {
		        g.fillRect( trackLeft+1, yPos, getTrackWidth()-1, 2 );
		    }
		}
		else {
		    int fillLength = trackBottom - middleOfThumb;
		    for ( int yPos = trackTop; yPos < middleOfThumb; yPos += 3 ) {
		        g.fillRect( trackLeft+1, yPos, getTrackWidth()-1, 2 );
		    }
		}
	    }
	}

	g.translate( -trackBounds.x, -trackBounds.y );
    }

    public void paintFocus(Graphics g)  {
        if (slider.hasFocus()) {
	    /// PENDING(klobad) copied from Button code - fix when 2D available
            // Draw each dash of the line pixel by pixel.
            // The performance of this is surely poor -- Be sure
            // to rewrite when 2d graphics package is ready.
	    Rectangle r = slider.getBounds();
	    r.x = 0;
            r.y = 0;	    
	    if(slider.getBorder() != null) {
	         r = getFullContentArea();
	    } 
            g.setColor(highlightColor);
            g.drawRect(r.x + 1, r.y + 1, r.width - 3, r.height - 3);

	    super.paintFocus( g );
        }
    }

    /**
      * Subclasses of BasicSliderUI override this method to determine their own
      * thumb size.
      */
    public void calculateThumbBounds()	{
        if ( slider.getOrientation() == JSlider.HORIZONTAL ) {
	    int thumbX = xPositionForValue( slider.getValue( )) - getThumbRect().width / 2;
	    int thumbY = (getScrollTrackRect().y + getScrollTrackRect().height) - 16;

	    setThumbBounds( thumbX, thumbY, 15, 15 );
        }
	else {
	    int thumbY = yPositionForValue(slider.getValue()) - getThumbRect().height / 2;
	    int thumbX = (getScrollTrackRect().x + getScrollTrackRect().width) - 16;

	    setThumbBounds( thumbX, thumbY, 15, 16 );
	}
    }

    /**
     * Gets the height of the tick area for horizontal sliders and the width of the
     * tick area for vertical sliders.  BasicSliderUI uses the returned value to
     * determine the bounds of the tray rectangle and the tick area rectangle.
     */
    public int getTickSize() {
        return 5;
    }

    /**
     * Returns the shorter dimension of the track.
     */
    protected int getTrackWidth() {
        return 7;
    }

    /**
     * Returns the longer dimension of the slide bar.  (The slide bar is only the
     * part that runs directly under the thumb)
     */
    protected int getTrackLength() {   
	Rectangle interiorRect = getFullContentArea();

	if ( slider.getOrientation() == JSlider.HORIZONTAL ) {
	    return getScrollTrackRect().width - (trackBuffer * 2);
	}
	return getScrollTrackRect().height - (trackBuffer * 2);
    }

    /**
     * Returns the amount that the thumb goes past the slide bar.
     */
    protected int getThumbOverhang() {
        return 5;
    }

    protected void scrollDueToClickInTrack( int dir ) {
        scrollByUnit( dir );
    }

    protected void paintMinorTickForHorizSlider( Graphics g, Rectangle tickBounds, int x ) {
	g.setColor( slider.getForeground() );
	g.fillRect( x, 0 , 2, 2 );
    }

    protected void paintMajorTickForHorizSlider( Graphics g, Rectangle tickBounds, int x ) {
	g.setColor( slider.isEnabled() ? OrganicLookAndFeel.getBlack() : darkShadowColor );
	g.fillRect( x, 0 , 2, 2 );
    }

    protected void paintMinorTickForVertSlider( Graphics g, Rectangle tickBounds, int y ) {
	g.setColor( slider.getForeground()  );
	g.fillRect( 0, y , 2, 2 );
    }

    protected void paintMajorTickForVertSlider( Graphics g, Rectangle tickBounds, int y ) {
	g.setColor( slider.isEnabled() ? OrganicLookAndFeel.getBlack() : darkShadowColor );
	g.fillRect( 0, y , 2, 2 );
    }
}
