/*
 * @(#)OrganicSeparatorUI.java	1.3 98/02/16
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.*;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.BasicSeparatorUI;


/**
 * A Java L&F implementation of SeparatorUI.  This implementation 
 * is a "combined" view/controller.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.3 02/16/98
 * @author Jeff Shapiro
 */

public class OrganicSeparatorUI extends BasicSeparatorUI
{
    public static ComponentUI createUI(JComponent x)
    {
        return new OrganicSeparatorUI();
    }

    protected void installDefaults(JComponent c) {
        LookAndFeel.installColors(c, "Separator.background", "Separator.foreground");
    }

    public void paint(Graphics g, JComponent c)
    {
        Dimension s = c.getSize();

        g.setColor( c.getBackground() );
        g.drawLine( 0, 0, s.width, 0 );

        g.setColor( c.getForeground() );
        g.drawLine( 8, 0, s.width - 8, 0 );
    }

    public Dimension getPreferredSize(JComponent c)
    { 
        return new Dimension(0, 1);
    }
}




