/*
 * @(#)OrganicScrollButton.java	1.5 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */

package com.sun.java.swing.plaf.organic;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Polygon;

import com.sun.java.swing.*;

import com.sun.java.swing.plaf.basic.BasicArrowButton;


/**
 * JButton object for Organic scrollbar arrows.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.5 02/02/98
 * @author Jeff Shapiro
 */
public class OrganicScrollButton extends BasicArrowButton
{
  private static Color buttonColor;
  private static Color buttonHighlightColor;
  private static Color buttonBackgroundColor;

  private int buttonWidth;

        public OrganicScrollButton( int direction, int width )
        {
            super( direction );

	    buttonColor = UIManager.getColor("ScrollBar.thumb");
	    buttonHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
	    buttonBackgroundColor = UIManager.getColor("ScrollBar.background");

            buttonWidth = width;
	    setRolloverEnabled( true );
        }

	public void paint( Graphics g )
        {
	    Color origColor;
	    boolean isPressed, isRollover, isEnabled;
	    int w, h, size;

            w = getSize().width;
            h = getSize().height;
	    origColor = g.getColor();
	    isPressed = getModel().isPressed();
	    isRollover = getModel().isRollover();
	    isEnabled = isEnabled();

            g.setColor( buttonBackgroundColor );
            g.fillRect( 0, 0, w, h );

            if ( isPressed || isRollover )
	    {
	        g.setColor( buttonHighlightColor );
	    }
	    else  // normal color
	    {
                g.setColor( buttonColor );
            }

	    Polygon p = new Polygon();

	    if ( getDirection() == NORTH )
	    {
	        p.addPoint( 1, h - 1 );
	        p.addPoint( 1, 4 );
	        p.addPoint( (w) / 2, 1 );
	        p.addPoint( (w + 1) / 2, 0 );
	        p.addPoint( w, 4 );
	        p.addPoint( w, h - 1 );
	    }
	    else if ( getDirection() == SOUTH )
	    {
	        p.addPoint( 1, 1 );
	        p.addPoint( 1, h - 5 );
	        p.addPoint( (w) / 2, h - 1 );
	        p.addPoint( (w + 1) / 2, h - 1 );
	        p.addPoint( w, h - 5 );
	        p.addPoint( w, 1 );
	    }
	    else if ( getDirection() == EAST )
	    {
	        p.addPoint( 1, 1 );
	        p.addPoint( w - 4, 1 );
	        p.addPoint( w - 1, (h) / 2 );
	        p.addPoint( w - 1, (h + 1) / 2 );
	        p.addPoint( w - 5, h );
	        p.addPoint( 1, h );
	    }
	    else if ( getDirection() == WEST )
	    {
	        p.addPoint( 1, (h + 1) / 2 );
	        p.addPoint( 1, (h) / 2 );
	        p.addPoint( 4, 0 );
	        p.addPoint( w - 1, 1 );
		p.addPoint( w - 1, h );
	        p.addPoint( 4, h );
	    }

	    g.fillPolygon( p );

	    g.setColor( origColor );

        }

        public Dimension getPreferredSize()
        {
	    if ( direction == NORTH || direction == SOUTH )
	    {
	        return new Dimension( buttonWidth, 16 );
	    }
	    else  // EAST or WEST
	    {
	        return new Dimension( 16, buttonWidth );
	    }
        }

        public Dimension getMinimumSize()
        {
            return getPreferredSize();
        }

        public Dimension getMaximumSize()
        {
            return new Dimension( Integer.MAX_VALUE, Integer.MAX_VALUE );
        }
    
}

