/*
 * @(#)OrganicScrollBarUI.java	1.4 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;
 
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Adjustable;
import java.awt.event.AdjustmentListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Point;
import java.awt.Insets;
import java.awt.Color;
import java.io.Serializable;
import java.awt.IllegalComponentStateException;

import com.sun.java.swing.*;
import com.sun.java.swing.event.*;

import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.BasicScrollBarUI;


/**
 * Implementation of ScrollBarUI for the Organic Look and Feel
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.4 02/02/98
 * @author Jeff Shapiro
 */
public class OrganicScrollBarUI extends BasicScrollBarUI implements MouseListener
{
    private static Color OrganictrackColor;
    private static Color OrganictrackHighlightColor;
    private static Color OrganicthumbColor;
    private static Color OrganicthumbHighlightColor;

    protected static int scrollBarWidth;
    protected boolean isRollover = false;

    public static ComponentUI createUI( JComponent c )
    {
        scrollBarWidth = ( ( Integer ) ( UIManager.get( "ScrollBar.width" ) ) ).intValue();

        return new OrganicScrollBarUI();
    }

    
    public void installUI( JComponent c )
    {
        super.installUI( c );

        c.addMouseListener( this );
    }

    public void uninstallUI( JComponent c )
    {
        super.uninstallUI( c );

        c.removeMouseListener( this );
    }

    protected void configureScrollBarColors()
    {
        OrganictrackColor          = UIManager.getColor("ScrollBar.track");
        OrganictrackHighlightColor = UIManager.getColor("ScrollBar.trackHighlight");
        OrganicthumbColor          = UIManager.getColor("ScrollBar.thumb");
        OrganicthumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
    }

    public Dimension getPreferredSize( JComponent c )
    {
        if ( scrollbar.getOrientation() == JScrollBar.VERTICAL )
	{
	    return new Dimension( scrollBarWidth, 36 );
        }
	else  // Horizontal
	{
            return new Dimension( 36, scrollBarWidth );
        }
    }

    /** Returns the view that represents the decrease view. 
      */
    protected JButton createDecreaseButton( int orientation )
    {
        return new OrganicScrollButton( orientation, scrollBarWidth );
    }

    /** Returns the view that represents the increase view. */
    protected JButton createIncreaseButton( int orientation )
    {
        return new OrganicScrollButton( orientation, scrollBarWidth );
    }

    protected void paintTrack( Graphics g, JComponent c, Rectangle trackBounds )
    {
      	g.setColor( OrganictrackColor );
        g.fillRect( trackBounds.x, trackBounds.y,
		    trackBounds.width, trackBounds.height );

        if ( isRollover )
	{
	    g.setColor( OrganictrackHighlightColor );

	    if ( scrollbar.getOrientation() == JScrollBar.VERTICAL )
	    {
	        g.fillRect( trackBounds.x + 1, trackBounds.y,
			    trackBounds.width, trackBounds.height );
	    }
	    else  // HORIZONTAL
	    {
	        g.fillRect( trackBounds.x, trackBounds.y + 1,
			    trackBounds.width, trackBounds.height );
	    }
	}
    }

    protected void paintThumb( Graphics g, JComponent c, Rectangle thumbBounds )
    {        
	if ( thumbBounds.isEmpty() || !scrollbar.isEnabled() )
	{
	    return;
	}

        if ( isRollover )
	{
	    g.setColor( OrganicthumbHighlightColor );
	}
	else
	{
	    g.setColor( OrganicthumbColor );
	}

	if ( scrollbar.getOrientation() == JScrollBar.VERTICAL )
	{
	    g.fillRect( thumbBounds.x + 1, thumbBounds.y,
			thumbBounds.width, thumbBounds.height );
	}
	else  // HORIZONTAL
	{
	    g.fillRect( thumbBounds.x, thumbBounds.y + 1,
			thumbBounds.width, thumbBounds.height );
	}
    }

    protected Dimension getMinimumThumbSize()
    {
        if ( scrollbar.getOrientation() == JScrollBar.VERTICAL )
	{
	    return new Dimension( scrollBarWidth - 1, 16 );
        }
	else  // Horizontal
	{
            return new Dimension( 16, scrollBarWidth - 1 );
        }
    }		


  /* MouseListener functions */


    public void mouseEntered( MouseEvent e ) 
    {
        isRollover = true;
	scrollbar.repaint();
    }
 
    public void mouseExited( MouseEvent e )
    {
        isRollover = false;
	scrollbar.repaint();
    }

    public void mouseClicked( MouseEvent e ) {}

    public void mousePressed( MouseEvent e ) {}

    public void mouseReleased( MouseEvent e ) {}

}






































































