/*
 * @(#)OrganicRadioButtonUI.java	1.6 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.basic.BasicRadioButtonUI;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.plaf.*;

/**
 * RadioButtonUI implementation for BasicRadioButtonUI
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.6 02/02/98
 * @author Tom Santos
 */
public class OrganicRadioButtonUI extends BasicRadioButtonUI {

    private static final OrganicRadioButtonUI organicRadioButtonUI = new OrganicRadioButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return organicRadioButtonUI;
    }
    
    // Inherited instance vars
    //
    // protected static ButtonUI radioButtonUI;
    // protected Icon icon;
    
    /************************** The View *************************/

    protected ButtonModel model;

    /**
     * paint the radio button
     */
    public synchronized void paint(Graphics g, JComponent c) {

	AbstractButton b = (AbstractButton) c;
	model = b.getModel();
	
	Dimension size = c.getSize();

	int w = size.width;
	int h = size.height;

	Font f = c.getFont();
	g.setFont(f);
	FontMetrics fm = g.getFontMetrics();

	Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();

	Icon altIcon = b.getIcon();
	Icon selectedIcon = null;
	Icon disabledIcon = null;
	
        String text = SwingUtilities.layoutCompoundLabel(
            fm, b.getText(), altIcon != null ? altIcon : icon,
            b.getVerticalAlignment(), b.getHorizontalAlignment(),
            b.getVerticalTextPosition(), b.getHorizontalTextPosition(),
            viewRect, iconRect, textRect, getDefaultTextIconGap(b)
        );
	
        g.setColor( b.getBackground() );

	if ( b.isOpaque() ) {  
	    g.fillRect(0,0, size.width, size.height); 
	}

	
	// Paint the radio button
        if(altIcon != null) { 

            if(!model.isEnabled()) {
                altIcon = b.getDisabledIcon();
            } else if(model.isPressed() && model.isArmed()) {
                altIcon = b.getPressedIcon();
                if(altIcon == null) {
                    // Use selected icon
                    altIcon = b.getSelectedIcon();
                } 
            } else if(model.isSelected()) {
                altIcon = b.getSelectedIcon();
            } 
	      
	    if(altIcon == null) {
		altIcon = b.getIcon();
	    }
	       
	    altIcon.paintIcon(c, g, iconRect.x, iconRect.y);

        } else {
	    icon.paintIcon(c, g, iconRect.x, iconRect.y);
	}


	// Draw the Text
	if(text != null) {
	    if(!model.isEnabled()) {
		g.setColor( UIManager.getColor("RadioButton.darkShadow") );
	    } else {
		g.setColor(b.getForeground());
	    }

	    OrganicUtilities.drawString(g,text,model.getMnemonic(),
				    textRect.x, textRect.y + fm.getAscent());

            if(b.hasFocus() && b.isFocusPainted() && textRect.width > 0 && textRect.height > 0 ) {
	        g.setColor( UIManager.getColor("RadioButton.highlight") );
		g.drawRect( textRect.x-1,textRect.y-1,
			    textRect.width+1,textRect.height+1);
                g.setColor(UIManager.getColor("RadioButton.focus"));
                OrganicUtilities.drawDashedRect(g,textRect.x-1,textRect.y-1,
                                                  textRect.width+2,textRect.height+2);
            }
	}
    }


}
