/*
 * @(#)OrganicProgressBarUI.java	1.8 98/02/05
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import java.awt.*;
import com.sun.java.swing.plaf.*;


/**
 * A Java L&F implementation of ProgressBarUI.  This implementation 
 * is both the view and the controller.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.8 02/05/98
 * @author Michael C. Albers
 */
public class OrganicProgressBarUI extends BasicProgressBarUI {
    int pending;
    static protected final Dimension PREFERRED_INNER_HORIZONTAL 
                                     = new Dimension(144, 11);
    static protected final Dimension PREFERRED_INNER_VERTICAL
                                     = new Dimension(11, 144);
    int cellLength, cellSpacing;
    protected Color headColor;

 
    public static ComponentUI createUI(JComponent c) {
	return new OrganicProgressBarUI();
    }
  
    public void installUI(JComponent c) {
	super.installUI(c);
	headColor = UIManager.getColor("ProgressBar.head");
    }
    
    public int getCellLength() {
	return 2;
    }
    
    public int getCellSpacing() {
	return 1;
    }
    
    public void paint(Graphics g, JComponent c) {
	Dimension totalSize = c.getSize();
	Dimension innerSize;
	int x, y;
	int span, length, max, min, current, increment;
	JProgressBar progressBar = (JProgressBar)c;
	BoundedRangeModel model = progressBar.getModel();
	Insets b = getBorderInsets(c);
	cellLength = getCellLength();
	cellSpacing = getCellSpacing();
	
	g.setColor(c.getForeground());
	if (progressBar.getOrientation() == JProgressBar.HORIZONTAL) {
	    x = b.left;
	    y = b.top;
	    innerSize = new Dimension(totalSize.width - (b.left + b.right),
				      totalSize.height - (b.top + b.bottom));
	    span = model.getMaximum() - model.getMinimum();
	    increment = cellLength + cellSpacing;
	
	    length = 0;
	    if (span != 0) {
	        double bigWidth = innerSize.width;
	        double bigValue = model.getValue();
	        double fractionComplete = bigValue / span;
	        length = (int)(bigWidth * fractionComplete);
	    }

	    max = (x + length) - cellLength;
	    
	    // Draw constant left cell
	    g.fillRect(x, y, cellLength, innerSize.height);
	    // Draw constant right cell
	    g.fillRect(totalSize.width-cellLength, y, 
		       cellLength, innerSize.height);
	    
	    // Draw the cells
	    for (current = x; current < max; current += increment) {
		g.fillRect(current, y, cellLength, innerSize.height);
	    }
	    
	    if (model.getValue() != 0) {
		// Draw the head cell
		g.setColor(headColor);
		// Ensure that "head" is always drawn at the end
		if (model.getValue() == model.getMaximum()) {
		    current = innerSize.width - cellLength;
		}
		g.fillRect(current, y, cellLength, innerSize.height);
	    }
	} else {     // Must be VERTICAL
	    x = b.left;
	    y = b.top;
	    innerSize = new Dimension(totalSize.width - (b.left + b.right),
				      totalSize.height - (b.top + b.bottom));
	    span = model.getMaximum() - model.getMinimum();
	    increment = cellLength + cellSpacing;
	
	    length = 0;
	    if (span != 0) {
	        double bigHeight = innerSize.height;
	        double bigValue = model.getValue();
	        double fractionComplete = bigValue / span;
	        length = (int)(bigHeight * fractionComplete);
	    }

	    min = ((innerSize.height - 1) + y) - length;
	    
	    // Draw the constant top cell
	    g.fillRect(x, y, innerSize.width, cellLength);
	    // Draw the constant bottom cell
	    g.fillRect(x, totalSize.height-cellLength,
		       innerSize.width, cellLength);
	    
	    for (current = (innerSize.height - 1) + (y - cellLength);
		 current > min; current -= increment)
	    {
		g.fillRect(x, current, innerSize.width, cellLength);
	    }
	    
	    if (model.getValue() != 0) {
		// Draw the head cell
		g.setColor(headColor);
		// Ensure that "head" is always drawn at the end
		if (model.getValue() == model.getMaximum()) {
		    current = y;
		}
		g.fillRect(x, current, innerSize.width, cellLength);
	    }
	}
    }
    
    public Insets getBorderInsets(JComponent c) {
	// no borders on OrganicProgressBar
	return new Insets(0, 0, 0, 0);
    }
    
}
