/*
 * @(#)OrganicPasswordFieldUI.java	1.4 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.BasicPasswordFieldUI;

/**
 * Provides the Windows look and feel for a password field.
 * The only difference from the standard text field is that
 * the view of the text is simply a string of the echo 
 * character as specified in JPasswordField, rather than the 
 * real text contained in the field.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.4 02/02/98
 * @author  Steve Wilson
 */
public class OrganicPasswordFieldUI extends BasicPasswordFieldUI 
                                implements FocusListener {

    private char cachedEchoChar;

    public static ComponentUI createUI(JComponent c) {
        return new OrganicPasswordFieldUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
	JPasswordField pw = (JPasswordField)c;
	c.addFocusListener(this);
	cachedEchoChar = pw.getEchoChar();
	pw.setEchoChar('-');
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
	c.removeFocusListener(this);
	JPasswordField pw = (JPasswordField)c;
	pw.setEchoChar(cachedEchoChar);
    }

    public void focusGained(FocusEvent e) {
        JTextField f = (JTextField)e.getSource();
	if (f.getBackground() instanceof UIResource)
	    f.setBackground(UIManager.getColor("PasswordField.activeBackground"));
	if (f.getBorder() instanceof UIResource)
	    f.setBorder(UIManager.getBorder("PasswordField.activeBorder"));
	f.repaint();
    }

    public void focusLost(FocusEvent e) {
        JTextField f = (JTextField)e.getSource();
	if (f.getBackground() instanceof UIResource)
	    f.setBackground(UIManager.getColor("PasswordField.background"));
	if (f.getBorder() instanceof UIResource)
            f.setBorder(UIManager.getBorder("PasswordField.border"));
	f.repaint();
    }

}





