/*
 * @(#)OrganicOptionPaneUI.java	1.4 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.basic.BasicOptionPaneUI;
import com.sun.java.swing.plaf.ComponentUI;
import java.awt.Color;
import java.awt.*;
import java.awt.event.*;


/**
 * Provides the Organic Look and Feel for a JOptionPane.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.4 02/02/98
 * @author Tom Santos
 */
public class OrganicOptionPaneUI extends BasicOptionPaneUI
{
    protected final static Dimension MINIMUM_SIZE = new Dimension( 300, 180 );

    public static ComponentUI createUI(JComponent x) {
	return new OrganicOptionPaneUI();
    }

    public void installUI( JComponent c ) {
        super.installUI( c );
    }

    /**
     * Fills the backround if the component is opaque.
     */
  /*  public void paint(Graphics g, JComponent c) {
	if(c.isOpaque()) {
	    g.setColor(c.getBackground());
	    g.fillRect(0, 0, c.getWidth(), c.getHeight());
	}
    }*/
  
    protected Container createBody() {
	Container          top = new Panel();

	top.setLayout( new BorderLayout() );

	GridBagConstraints cons = new GridBagConstraints();
	Container          body = new Container() {};
	Container          realBody = new Container() {};

	realBody.setLayout(new BorderLayout());
	realBody.add( createButtons(), BorderLayout.SOUTH );
	realBody.add(new Container() {
	    public Dimension getPreferredSize() {
		return new Dimension(15, 1);
	    }
	}, BorderLayout.WEST);
	realBody.add(body, BorderLayout.CENTER);

	body.setLayout(new GridBagLayout());
	cons.gridx = cons.gridy = 0;
	cons.gridwidth = GridBagConstraints.REMAINDER;
	cons.gridheight = 1;
	cons.anchor = GridBagConstraints.WEST;
	cons.insets = new Insets(0,0,3,0);

	appendDescription(body, cons, getMessage(),
			  getMaxCharactersPerLineCount(), false);
	top.add(realBody, BorderLayout.CENTER);

	addIcon( top );

	return top;
    }

    /**
     * Creates and returns a Container containin the buttons. The buttons
     * are created by calling <code>getButtons</code>.
     */
    protected Container createButtons() {
	/* And the bottom for all the buttons. */
        Container             buttons = new Panel() {
	    private final Insets insets = new Insets( 0, 10, 15, 0 );
	    public Insets getInsets() {
	        return insets;
	    }
	};

	FlowLayout layout = new FlowLayout();
	layout.setAlignment( FlowLayout.LEFT );
	buttons.setLayout( layout );
	appendButtons(buttons, getButtons(), getInitialIndex());

	return buttons;
    }

    /**
     * Creates the appropriate object to represent each of the objects in
     * <code>buttons</code> and adds it to <code>container</code>. This
     * differs from appendDescription in that it will recurse on
     * <code>buttons</code> and that if button is not a Component
     * it will create an instance of JButton, that when pressed will
     * invoke <code>createdButtonFired</code> with the appropriate
     * index.
     */
    protected void appendButtons(Container container, Object[] buttons,
				 int initialIndex) {
	if(buttons != null && buttons.length > 0) {
	    boolean            sizeButtonsToSame = getSizeButtonsToSameWidth();
	    boolean            createdAll = true;
	    int                numButtons = buttons.length;
	    JButton[]          createdButtons = null;
	    int                maxWidth = 0;

	    if(sizeButtonsToSame) {
		createdButtons = new JButton[numButtons];
 	    }

	    for(int counter = 0; counter < numButtons; counter++) {
		Object       anO = buttons[counter];
		Component    newComponent;

		if(anO instanceof Component) {
		    createdAll = false;
		    newComponent = (Component)anO;
		    container.add(newComponent);
		    hasCustomComponents = true;
		} else {
		    JButton      aButton;

		    if(anO instanceof Icon)
			aButton = new JButton((Icon)anO);
		    else
			aButton = new JButton(anO.toString());
		    container.add(aButton);

		    final int       buttonIndex = counter;

		    aButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
			    createdButtonFired(buttonIndex);
			}
		    });
		    newComponent = aButton;
		}
		if(sizeButtonsToSame && createdAll && 
		   (newComponent instanceof JButton)) {
		    createdButtons[counter] = (JButton)newComponent;
		    maxWidth = Math.max(maxWidth,
					newComponent.getMinimumSize().width);
		}
		if(counter == initialIndex) {
		    initialFocusComponent = newComponent;
		}
	    }
	    //	    ((SyncingLayoutManager)container.getLayout()).
	    //	              setSyncsAll((sizeButtonsToSame && createdAll));
	    /* Set the padding, windows seems to use 8 if <= 2 components,
	       otherwise 4 is used. It may actually just be the size of the
	       buttons is always the same, not sure. */
	    if(sizeButtonsToSame && createdAll) {
		JButton               aButton;
		int                   padSize;

		if(numButtons <= 2)
		    padSize = 8;
		else
		    padSize = 4;
		for(int counter = 0; counter < numButtons; counter++) {
		    aButton = createdButtons[counter];
		    aButton.setMargin(new Insets(2, padSize, 2, padSize));
		}
	    }
	}
    }

    /**
     * Removes all the components from the Container, adds the icon,
     * message and buttons.
     */
    protected void validateComponent() {
	Container        container = getContainer();

	hasCustomComponents = false;
	initialFocusComponent = null;
	if(container != null) {
	    emptyContainer(container);
	    container.setLayout( new BorderLayout() );
	    container.add(createBody(), BorderLayout.CENTER);
	}
    }

    /**
     * Creates and adds a JLabel representing the icon returned from
     * <code>getIcon</code> to <code>top</code>. This is messaged from
     * <code>createBody</code>
     */
    protected void addIcon(Container top) {
	/* Create the icon. */
	Icon                  sideIcon = getIcon();

	if (sideIcon != null) {
	    JLabel            iconLabel = new JLabel(sideIcon);

	    iconLabel.setVerticalAlignment(SwingConstants.CENTER);
	    Panel panel = new Panel() {
	        public void paint( Graphics g ) {
		    super.paint( g );
		    g.setColor( UIManager.getColor("OptionPane.darkShadow") );
		    Rectangle bounds = getBounds();
		    g.drawLine( bounds.x + bounds.width - 1, 0,
				bounds.x + bounds.width - 1, bounds.y + bounds.height );
		}
		public Insets getInsets() {
		    return new Insets( 0, 13, 0, 13 );
		}
	    };
	    panel.setBackground( UIManager.getColor("OptionPane.shadow") );
	    panel.setLayout( new BorderLayout() );
	    panel.add(iconLabel, BorderLayout.CENTER);
	    top.add( panel, BorderLayout.WEST );
	}
    }

    /**
     * Returns null, CDE/Motif does not impose a minimum size.
     */
    public Dimension getMinimumOptionPaneSize() {
	return MINIMUM_SIZE;
    }

    /**
     * Returns the insets to be used for the body, the body contains both
     * the image and the actual message.
     */
    protected Insets getBodyInsets() {
	return new Insets(0, 0, 12, 0);
    }

}
