/*
 * @(#)OrganicLookAndFeel.java	1.23 98/02/17
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import java.awt.Font;
import java.awt.Color;
import java.awt.SystemColor;

import com.sun.java.swing.UIDefaults;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.ImageIcon;


/**
 * This class is used to define the UI classes and colors which 
 * define the Java Look & Feel.
 * <p>
 * For the keyboard keys defined for each component in this Look and
 * Feel (L&F), see 
 * <a href="../../doc-files/Key-Metal.html">Component Keystroke Actions for the Metal L&F</a>.
 * The keystrokes for Organic are same as for Metal. The only difference is that the Organic
 * combo box does not implement the Spacebar to toggle the menu up and down.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.23 02/17/98
 * @author Steve Wilson
 */
public class OrganicLookAndFeel extends BasicLookAndFeel

{

    private static OrganicTheme currentTheme = new OrganicDefaultTheme();

    public String getName() {
        return "Organic Look and Feel";
    }


    public String getID() {
        return "Organic";
    }


    public String getDescription() {
        return "Organic - A Cross-Platform Java Look and Feel";
    }

    public boolean isNativeLookAndFeel(){
        return false;
    }
 
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public static void installColorsAndFont(JComponent c,
                                         String defaultBgName,
                                         String defaultFgName,
                                         String defaultFontName) {
        LookAndFeel.installColorsAndFont(c, defaultBgName, defaultFgName, defaultFontName);
    }

   /** 
     * Initialize the uiClassID to BasicComponentUI mapping.
     * The JComponent classes define their own uiClassID constants
     * (see AbstractComponent.getUIClassID).  This table must
     * map those constants to a BasicComponentUI class of the
     * appropriate type.
     * 
     * @see #getDefaults
     */
    protected void initClassDefaults(UIDefaults table)
    {
        
        String basicPackageName = "com.sun.java.swing.plaf.basic.";
        String organicPackageName = "com.sun.java.swing.plaf.organic.";
        Object[] uiDefaults = {
                   "ButtonUI", organicPackageName + "OrganicButtonUI",
                 "CheckBoxUI", organicPackageName + "OrganicCheckBoxUI",
             "ColorChooserUI", basicPackageName + "BasicColorChooserUI",
                  "MenuBarUI", organicPackageName + "OrganicMenuBarUI",
                     "MenuUI", organicPackageName + "OrganicMenuUI",
                 "MenuItemUI", organicPackageName + "OrganicMenuItemUI",
         "CheckBoxMenuItemUI", organicPackageName + "OrganicCheckBoxMenuItemUI",
      "RadioButtonMenuItemUI", organicPackageName + "OrganicRadioButtonMenuItemUI",
              "RadioButtonUI", organicPackageName + "OrganicRadioButtonUI",
             "ToggleButtonUI", organicPackageName + "OrganicToggleButtonUI",
                "PopupMenuUI", organicPackageName + "OrganicPopupMenuUI",
              "ProgressBarUI", organicPackageName + "OrganicProgressBarUI",
                "ScrollBarUI", organicPackageName + "OrganicScrollBarUI",
               "ScrollPaneUI", organicPackageName + "OrganicScrollPaneUI",
                "SplitPaneUI", organicPackageName + "OrganicSplitPaneUI",
                   "SliderUI", organicPackageName + "OrganicSliderUI",
                  "SpinnerUI", organicPackageName + "OrganicSpinnerUI",
                "SeparatorUI", organicPackageName + "OrganicSeparatorUI",
               "TabbedPaneUI", organicPackageName + "OrganicTabbedPaneUI",
                   "TextAreaUI", basicPackageName + "BasicTextAreaUI",  //don't need
                "TextFieldUI", organicPackageName + "OrganicTextFieldUI",
            "PasswordFieldUI", organicPackageName + "OrganicPasswordFieldUI",
                   "TextPaneUI", basicPackageName + "BasicTextPaneUI",  // don't need
               "EditorPaneUI", basicPackageName + "BasicEditorPaneUI",
                     "TreeUI", organicPackageName + "OrganicTreeUI",
                    "LabelUI", organicPackageName + "OrganicLabelUI",
                   "ListUI", basicPackageName + "BasicListUI",  // don't need
                  "ToolBarUI", organicPackageName + "OrganicToolBarUI",
                  "ToolTipUI", organicPackageName + "OrganicToolTipUI",
                 "ComboBoxUI", organicPackageName + "OrganicComboBoxUI",
                    "TableUI", organicPackageName + "OrganicTableUI",
              "TableHeaderUI", organicPackageName + "OrganicTableHeaderUI",
            "InternalFrameUI", organicPackageName + "OrganicInternalFrameUI",
           "StandardDialogUI", basicPackageName + "BasicStandardDialogUI",
              "DesktopPaneUI", organicPackageName + "OrganicDesktopPaneUI",
              "DesktopIconUI", organicPackageName + "OrganicDesktopIconUI",
            "DirectoryPaneUI", organicPackageName + "OrganicDirectoryPaneUI",
              "FileChooserUI", organicPackageName + "OrganicFileChooserUI",
               "OptionPaneUI", organicPackageName + "OrganicOptionPaneUI"
        };

        table.putDefaults(uiDefaults);
    }


    /**
     * Load the SystemColors into the defaults table.  The keys
     * for SystemColor defaults are the same as the names of
     * the public fields in SystemColor.
     */
    protected void initSystemColorDefaults(UIDefaults table)
    {
        Object[] systemColors = {
                      "desktop", getDesktopColor(),
                "activeCaption", getWindowTitleBackground(),
            "activeCaptionText", getWindowTitleForeground(),
          "activeCaptionBorder", getControl1(),
              "inactiveCaption", getWindowTitleInactiveBackground(),
          "inactiveCaptionText", getWindowTitleInactiveForeground(),
        "inactiveCaptionBorder", getInactiveSystemTextColor(),
                       "window", getWindowBackground(),
                 "windowBorder", getBlack(),
                   "windowText", getWindowBackground(),
                         "menu", getMenuBackground(),
                     "menuText", getMenuForeground(),
                         "text", getControl1(),
                     "textText", getUserTextColor(),
                "textHighlight", getTextHighlightColor(),
            "textHighlightText", getHighlightedTextColor(),
             "textInactiveText", getInactiveSystemTextColor(),
                      "control", getControl1(),
                  "controlText", getControlTextColor(),
             "controlHighlight", getLightAccent1(),
           "controlLtHighlight", getLightAccent1(), 
                "controlShadow", getControl2(),
              "controlDkShadow", getControl3(),
                    "scrollbar", getWindowBackground(),
                         "info", getHighlight4(),
                     "infoText", getWindowBackground() 
        };

        for(int i = 0; i < systemColors.length; i += 2) {
            table.put((String)systemColors[i], systemColors[i + 1]);
        }
    }

    protected void initComponentDefaults(UIDefaults table) 
    {


        FontUIResource monospacedPlain12 = new FontUIResource("Monospaced", 
                                                          Font.PLAIN, 12);


        Object listCellRendererActiveValue = new UIDefaults.ActiveValue() {
            public Object createValue(UIDefaults table) { 
                return new BasicListCellRenderer.UIResource();
            }
        };

        Object scrollPaneBorder =  BorderUIResource.getEtchedBorderUIResource();

        Object multilineTextBorder =  BasicMarginBorder.getMarginBorder();

        Object fieldTextBorder = new BorderUIResource( new OrganicTextBorder(getControl1()));

        Object activeFieldTextBorder = new BorderUIResource( new OrganicTextBorder(getWindowBackground()));

        Object toolTipBorder =new BorderUIResource(BorderFactory.createLineBorder(getWindowBackground(), 1));
                                   
        Object caretBlinkRate = new Integer(500);

        Object buttonBorder = new BorderUIResource( new CompoundBorder(
                                         new OrganicButtonBorder(),
                                         new OrganicButtonUI.OrganicButtonMargin()));
 
        Object buttonToggleBorder = new BorderUIResource( new CompoundBorder( 
                                         new OrganicToggleButtonUI.OrganicToggleButtonBorder(),
                                         new OrganicButtonUI.OrganicButtonMargin()));

        // *** ComboBox
        Object comboBoxRendererActiveValue  = new UIDefaults.ActiveValue() {
            public Object createValue(UIDefaults table) {
                return new BasicComboBoxRenderer.UIResource();
            }
        };

        Object comboBoxEditorActiveValue  = new UIDefaults.ActiveValue() {
            public Object createValue(UIDefaults table) {
                return new OrganicComboBoxEditor.UIResource();
            }
        };

        Object menuItemMarginBorder = new BorderUIResource(new OrganicMenuItemBorder() );

        Object menuMarginBorder = new BorderUIResource(new OrganicMenuItemBorder() );

        Object menuBarBorder = new BorderUIResource(new OrganicMenuBarBorder());

        Object popupMenuBorder = new BorderUIResource(new OrganicPopupMenuBorder());

        Object titledBorderBorder = new BorderUIResource(new LineBorder(table.getColor("controlHighlight")));

        Object menuItemCheckIcon = OrganicIconFactory.getMenuItemCheckIcon();

        Object menuItemArrowIcon =  OrganicIconFactory.getMenuItemArrowIcon();

        Object menuArrowIcon = OrganicIconFactory.getMenuArrowIcon();

        Object checkBoxIcon = new OrganicCheckBoxIcon();

        Object radioButtonIcon = OrganicIconFactory.getRadioButtonIcon();

        Object checkBoxMenuItemIcon = OrganicIconFactory.getCheckBoxMenuItemIcon();

        Object radioButtonMenuItemIcon =  OrganicIconFactory.getRadioButtonMenuItemIcon();

        Object toolBarBorder = new BorderUIResource( new OrganicMenuBarBorder() );

        Object treeNodeClosedIcon =  OrganicIconFactory.getTreeNodeClosedIcon();

        Object treeNodeOpenIcon =  OrganicIconFactory.getTreeNodeOpenIcon();

        Object treeNodeLeafIcon = OrganicIconFactory.getTreeNodeLeafIcon();

        Object treeComputerIcon =  OrganicIconFactory.getTreeComputerIcon();

        Object treeHardDriveIcon = OrganicIconFactory.getTreeHardDriveIcon();

        Object treeFloppyDriveIcon = OrganicIconFactory.getTreeFloppyDriveIcon();

        Object treeExpandCollapseIcon = new OrganicTreeUI.ExpandCollapseIcon();

        Object fileChooserNewFolderIcon = OrganicIconFactory.getFileChooserNewFolderIcon();

        Object fileChooserUpFolderIcon =  OrganicIconFactory.getFileChooserUpFolderIcon();

        Object fileChooserHomeFolderIcon =  OrganicIconFactory.getFileChooserHomeFolderIcon();

        Object fileChooserDetailsViewIcon = OrganicIconFactory.getFileChooserDetailsViewIcon();

        Object fileChooserListViewIcon = OrganicIconFactory.getFileChooserListViewIcon();

        Object optionPaneBorder = new BorderUIResource( new CompoundBorder( 
                                             new MatteBorder( 2, 2, 2, 2, table.getColor("controlDkShadow") ),
                                             new EmptyBorder( 1, 1, 1, 1 ) ));

        Object listBorder = new BorderUIResource( new EmptyBorder( 6, 6, 6, 6 ));


        Object internalFrameBorder = new BorderUIResource( new CompoundBorder(
                                         BorderFactory.createLineBorder(getLightAccent1(), 1),
                                         new OrganicFrameBorder( getWindowFrameLeft(),
                                                                 getWindowFrameRight(),
                                                                 getWindowFrameTop(),
                                                                 getWindowFrameBottom(),
                                                                 getWindowFrameInactive(),
                                                                 2)) );

        Object internalPaletteFrameBorder = new BorderUIResource(
                                            new MatteBorder (2, 2, 2, 2, getHighlight4() ));

        Object focusCellHighlightBorder = new BorderUIResource( new LineBorder(getHighlight4()) );

        Object[] defaults = {
            "Desktop.background", table.get("desktop"),

            "Panel.background", table.get("control"),
            "Panel.foreground", table.get("textText"),
            "Panel.font", getControlTextFont(),

            "Button.border", buttonBorder,
            "Button.background", table.get("control"),
            "Button.foreground", table.get("controlText"),
            "Button.focus", getFocusColor(),
            "Button.pressed",  table.get("controlShadow"),
            "Button.disabled", table.get("controlShadow"),  
            "Button.disabledText", table.get("textInactiveText"),          
            "Button.font", getControlTextFont(),
            "Button.highlight", table.get("controlLtHighlight"),
            "Button.shadow", table.get("controlDkShadow"),

            "ToggleButton.border", buttonToggleBorder,
            "ToggleButton.background", table.get("control"),
            "ToggleButton.foreground", table.get("controlText"),
            "ToggleButton.focus", getFocusColor(),
            "ToggleButton.focusHighlight", getLightAccent1(),
            "ToggleButton.selected",   table.get("controlShadow"),
            "ToggleButton.disabled",   table.get("controlShadow"),  
            "ToggleButton.disabledText", table.get("textInactiveText"),  
            "ToggleButton.font", getControlTextFont(),

            "InternalFrame.icon", null,
            "InternalFrame.border", internalFrameBorder,
            "InternalFrame.paletteBorder", internalPaletteFrameBorder,      

            "InternalFrameTitlePane.activeBackground", table.get("activeCaption"),          
            "InternalFrameTitlePane.inactiveBackground", table.get("inactiveCaption"),
            "InternalFrameTitlePane.activeForeground",  table.get("activeCaptionText"),
            "InternalFrameTitlePane.inactiveForeground",table.get("inactiveCaptionText"),
            "InternalFrameTitlePane.paletteBackground", getPaletteTitleBackground(),        
            "InternalFrameTitlePane.paletteForeground", getPaletteTitleForeground(),      
            "InternalFrameTitlePane.font", getEmphasisTextFont(),
            "InternalFrameTitlePane.maximizeIcon", OrganicIconFactory.createFrameMaximizeIcon(),
            "InternalFrameTitlePane.iconizeIcon",  OrganicIconFactory.createFrameIconifyIcon(),
            "InternalFrameTitlePane.closeIcon",  OrganicIconFactory.createFrameCloseIcon(),
            "InternalFrameTitlePane.altMaximizeIcon", OrganicIconFactory.createFrameMinimizeIcon(),
           
            "RadioButton.background",  table.get("control"),
            "RadioButton.foreground", table.get("controlText"),
            "RadioButton.shadow", table.get("controlShadow"),
            "RadioButton.darkShadow", table.get("controlDkShadow"),
            "RadioButton.highlight", table.get("controlHighlight"),
            "RadioButton.lightHighlight", getWhite(),
            "RadioButton.dot", getBlack(),
            "RadioButton.focus", getFocusColor(),
            "RadioButton.font", getControlTextFont(),
            "RadioButton.icon", radioButtonIcon,

            "CheckBox.icon", checkBoxIcon,

            "RadioButtonMenuItem.icon", radioButtonMenuItemIcon,
            "CheckBoxMenuItem.icon", checkBoxMenuItemIcon,

            "Menu.border", menuMarginBorder,
            "Menu.font", getMenuTextFont(),
            "Menu.foreground", getMenuForeground(),
            "Menu.pressedForeground", getMenuSelectedForeground(),
            "Menu.subMenuForeground", getMenuItemForeground(),
            "Menu.arrowIcon", menuArrowIcon,

            "MenuBar.border", menuBarBorder,
            "MenuBar.background", table.get("menu"),
            "MenuBar.foreground", table.get("menuText"),
            "MenuBar.font", getMenuTextFont(),

            "MenuItem.border", menuItemMarginBorder,
            "MenuItem.borderPainted", Boolean.FALSE,
            "MenuItem.font", getMenuTextFont(),
            "MenuItem.foreground", getMenuItemForeground(),
            "MenuItem.disabledForeground", table.get("controlDkShadow"),
            "MenuItem.background", table.get("menu"),
            "MenuItem.pressedForeground", getMenuSelectedForeground(),
            "MenuItem.pressedBackground", getMenuSelectedBackground(),
            "MenuItem.acceleratorFont", getMenuTextFont(),
            "MenuItem.acceleratorForeground", getMenuItemForeground(),
            "MenuItem.acceleratorPressedForeground", getMenuSelectedForeground(),
            "MenuItem.checkIcon", menuItemCheckIcon,
            "MenuItem.arrowIcon", menuItemArrowIcon,

            "Separator.background", getMenuBackground(),
            "Separator.foreground", getMenuSelectedBackground(),

            "PopupMenu.background", table.get("menu"),
            "PopupMenu.border", popupMenuBorder,          

            "ComboBox.renderer", comboBoxRendererActiveValue,
            "ComboBox.editor", comboBoxEditorActiveValue,
            "ComboBox.background", table.get("control"),
            "ComboBox.foreground", table.get("controlText"),
            "ComboBox.selectedBackground", table.get("controlHighlight"),
            "ComboBox.selectedForeground", table.get("controlText"),
            "ComboBox.listBackground", table.get("control"),
            "ComboBox.listForeground", table.get("controlText"),
            "ComboBox.font", getControlTextFont(),

            "Label.font", getControlTextFont(),
            "Label.background", table.get("text"),
            "Label.foreground", getSystemTextColor(),
            "Label.disabled", table.get("controlDkShadow"),

            "List.background", table.get("window"),
            "List.foreground", table.get("controlText"),
            "List.selectionBackground", table.get("control"), 
            "List.selectionForeground", table.get("controlText"),
            "List.focusCellHighlightBorder", focusCellHighlightBorder,
            "List.font", getControlTextFont(),
            "List.cellRenderer", listCellRendererActiveValue,
            "List.border", listBorder,

            "TextField.caretForeground", getBlack(),
            "TextField.caretBlinkRate", caretBlinkRate,
            "TextField.inactiveForeground", table.get("textInactiveText"),
            "TextField.selectionBackground", table.get("textHighlight"),
            "TextField.selectionForeground", table.get("textHighlightText"),
            "TextField.background", table.get("text"),
            "TextField.foreground", table.get("textText"),
            "TextField.font", getUserTextFont(),
            "TextField.border", fieldTextBorder,
            "TextField.activeBorder", activeFieldTextBorder,
            "TextField.activeBackground", table.get("textHighlightText"),
            
            "ToolBar.border", toolBarBorder,
            "ToolBar.background", table.get("menu"),
            "ToolBar.foreground", table.get("menuText"),
            "ToolBar.font", getControlTextFont(),

            "PasswordField.caretForeground", getBlack(),
            "PasswordField.caretBlinkRate", caretBlinkRate,
            "PasswordField.inactiveForeground", table.get("textInactiveText"),
            "PasswordField.selectionBackground", table.get("textHighlight"),
            "PasswordField.selectionForeground", table.get("textHighlightText"),
            "PasswordField.background",  table.get("text"),
            "PasswordField.foreground", table.get("textText"),
            "PasswordField.font", monospacedPlain12,
            "PasswordField.border", fieldTextBorder,
            "PasswordField.activeBorder", activeFieldTextBorder,
            "PasswordField.activeBackground", table.get("textHighlightText"),

            "ProgressBar.font", getControlTextFont(),
            "ProgressBar.head", getLightAccent4(),
            "ProgressBar.foreground",  getBlack(), 
            "ProgressBar.background", table.get("controlShadow"),

            "SplitPane.background", table.get("control"),
            "SplitPane.highlight", table.get("controlLtHighlight"),
            "SplitPane.shadow", table.get("controlLtHighlight"),

            "TabbedPane.font", getControlTextFont(),
            "TabbedPane.tabBackground", table.get("controlShadow"),
            "TabbedPane.tabForeground", getControlTextColor(),
            "TabbedPane.tabHighlight", table.get("controlHighlight"),
            "TabbedPane.tabShadow", table.get("controlShadow"),
            "TabbedPane.tabDarkShadow", table.get("controlDkShadow"),
            "TabbedPane.focus", getFocusColor(),
            "TabbedPane.selected", table.get("control"),
            
            "TextArea.caretForeground", getBlack(),
            "TextArea.caretBlinkRate", caretBlinkRate,
            "TextArea.inactiveForeground", table.get("textInactiveText"),
            "TextArea.selectionBackground", table.get("textHighlight"),
            "TextArea.selectionForeground", table.get("textHighlightText"),
            "TextArea.background", table.get("window"),
            "TextArea.foreground", table.get("textText"),
            "TextArea.font", getUserTextFont(),
            "TextArea.border", multilineTextBorder,
            
            "TextPane.caretForeground", getBlack(),
            "TextPane.inactiveForeground", table.get("textInactiveText"),
            "TextPane.selectionBackground",  table.get("textHighlight"),
            "TextPane.selectionForeground", table.get("textHighlightText"),
            "TextPane.background", table.get("window"),
            "TextPane.foreground", table.get("textText"),
            "TextPane.font", getUserTextFont(),
            "TextPane.border", multilineTextBorder,
            
            "EditorPane.caretForeground", getBlack(),
            "EditorPane.inactiveForeground", table.get("textInactiveText"),
            "EditorPane.selectionBackground",  table.get("textHighlight"),
            "EditorPane.selectionForeground", table.get("textHighlightText"),
            "EditorPane.background", table.get("window"),
            "EditorPane.foreground", table.get("textText"),
            "EditorPane.font", getUserTextFont(),
            "EditorPane.border", multilineTextBorder,
            
            "ScrollBar.background", table.get("scrollbar"),
            "ScrollBar.track", table.get("scrollbar"),
            "ScrollBar.trackHighlight", table.get("control"),
            "ScrollBar.thumb", table.get("controlShadow"),
            "ScrollBar.thumbHighlight", getDarkAccent4(),
            "ScrollBar.border", null,
            "ScrollBar.width", new Integer ( 9 ),

            "ScrollPane.border", null,
            "ScrollPane.font", getControlTextFont(),
            "ScrollPane.background", table.get("window"),
            "ScrollPane.foreground", table.get("textText"),
            "ScrollPane.viewportBorder", null,

            "Slider.border", null,
            "Slider.foreground", table.get("controlShadow"),
            "Slider.background", table.get("control"),
            "Slider.highlight", table.get("controlLtHighlight"),
            "Slider.darkShadow", table.get("controlDkShadow"),
            "Slider.thumb", getDarkAccent4(),
            "Slider.focus", getFocusColor(),

            "TitledBorder.font", getControlTextFont(),
            "TitledBorder.titleColor", getSystemTextColor(),
            "TitledBorder.border", titledBorderBorder,

            "ToolTip.font", getUserTextFont(),
            "ToolTip.border", toolTipBorder,
            "ToolTip.background", table.get("info"),
            "ToolTip.foreground", table.get("infoText"),

            "Tree.background", table.get("window"),
            "Tree.hash", table.get("control"),
            "Tree.textSelectionColor", table.get("textHighlightText"),
            "Tree.textNonSelectionColor", table.get("textText"),
            "Tree.borderSelectionColor", table.get("controlShadow"),
            "Tree.backgroundSelectionColor", table.get("textHighlight"),
            "Tree.backgroundNonSelectionColor", table.get("window"),
            "Tree.knobColor", getLightAccent4(),
            "Tree.openIcon", treeNodeOpenIcon,
            "Tree.closedIcon", treeNodeClosedIcon,
            "Tree.leafIcon", treeNodeLeafIcon,
            "Tree.computer", treeComputerIcon,
            "Tree.hardDrive", treeHardDriveIcon,
            "Tree.floppyDrive", treeFloppyDriveIcon,
            "Tree.expandedIcon", treeExpandCollapseIcon,
            "Tree.collapsedIcon", treeExpandCollapseIcon,

            "Table.font", getUserTextFont(),
            "Table.foreground", table.get("textText"),  // cell text color
            "Table.background", table.get("controlLtHighlight"),  // cell background color
            "Table.selectionForeground", table.get("textText"),
            "Table.selectionBackground", table.get("controlShadow"),
            "Table.gridColor", getHighlight1(),  // grid line color
            "Table.focusCellHighlightBorder", focusCellHighlightBorder,
            "Table.scrollPaneBorder", null,

            "TableHeader.font", getUserTextFont(), 
            "TableHeader.foreground", getSystemTextColor(), // header text color
            "TableHeader.background", table.get("control"), // header background


            "FileChooser.newFolder", fileChooserNewFolderIcon,
            "FileChooser.upFolder", fileChooserUpFolderIcon,
            "FileChooser.homeFolder", fileChooserHomeFolderIcon,
            "FileChooser.detailsView", fileChooserDetailsViewIcon,
            "FileChooser.listView", fileChooserListViewIcon,

            "DirectoryPane.directoryIcon", treeNodeClosedIcon,
            "DirectoryPane.fileIcon", treeNodeLeafIcon,
            "DirectoryPane.computerIcon", treeComputerIcon,
            "DirectoryPane.hardDriveIcon", treeHardDriveIcon,
            "DirectoryPane.floppyDriveIcon", treeFloppyDriveIcon,

            "OptionPane.font", getControlTextFont(),
            "OptionPane.background", table.get("control"),
            "OptionPane.foreground", table.get("textText"),
            "OptionPane.border", optionPaneBorder,          
            "OptionPane.shadow", table.get("controlShadow"),
            "OptionPane.darkShadow", table.get("controlDkShadow"),                  
            "OptionPane.errorIcon", LookAndFeel.makeIcon(getClass(), "icons/Error.gif"),
            "OptionPane.informationIcon", LookAndFeel.makeIcon(getClass(), "icons/Inform.gif"),
            "OptionPane.warningIcon", LookAndFeel.makeIcon(getClass(), "icons/Warn.gif"),
            "OptionPane.questionIcon", LookAndFeel.makeIcon(getClass(), "icons/Question.gif")
        };

        table.putDefaults(defaults);
    }
    public UIDefaults getDefaults() {
        UIDefaults table = new UIDefaults();

        initClassDefaults(table);
        initSystemColorDefaults(table);
        initComponentDefaults(table);
        currentTheme.addCustomEntriesToTable(table);
        return table;
    }
    


    public static void setCurrentTheme(OrganicTheme theme) {
        if (theme == null) {
            throw new NullPointerException("Can't have null theme");
        }
        currentTheme = theme;
    }

    public static ColorUIResource getControl1() { return currentTheme.getControl1(); }
    public static ColorUIResource getControl2() { return currentTheme.getControl2(); }
    public static ColorUIResource getControl3() { return currentTheme.getControl3(); }
    public static ColorUIResource getControl4() { return currentTheme.getControl4(); }

    public static ColorUIResource getHighlight1() { return currentTheme.getHighlight1(); }
    public static ColorUIResource getHighlight2() { return currentTheme.getHighlight2(); }
    public static ColorUIResource getHighlight3() { return currentTheme.getHighlight3(); }
    public static ColorUIResource getHighlight4() { return currentTheme.getHighlight4(); }

    public static ColorUIResource getDarkAccent1() { return currentTheme.getDarkAccent1(); }
    public static ColorUIResource getDarkAccent2() { return currentTheme.getDarkAccent2(); }
    public static ColorUIResource getDarkAccent3() { return currentTheme.getDarkAccent3(); }
    public static ColorUIResource getDarkAccent4() { return currentTheme.getDarkAccent4(); }

    public static ColorUIResource getLightAccent1() { return currentTheme.getLightAccent1(); }
    public static ColorUIResource getLightAccent2() { return currentTheme.getLightAccent2(); }
    public static ColorUIResource getLightAccent3() { return currentTheme.getLightAccent3(); }
    public static ColorUIResource getLightAccent4() { return currentTheme.getLightAccent4(); }

    public static ColorUIResource getWhite() { return currentTheme.getWhite(); } 
    public static ColorUIResource getBlack() { return currentTheme.getBlack(); }

    public static FontUIResource getControlTextFont() { return currentTheme.getControlTextFont();}
    public static FontUIResource getUserTextFont() { return currentTheme.getUserTextFont();}
    public static FontUIResource getMenuTextFont() { return currentTheme.getMenuTextFont();}
    public static FontUIResource getEmphasisTextFont() { return currentTheme.getEmphasisTextFont();}

    public static ColorUIResource getDesktopColor() { return currentTheme.getDesktopColor(); }
    public static ColorUIResource getFocusColor() { return currentTheme.getFocusColor(); }


    public static ColorUIResource getSystemTextColor() { return currentTheme.getSystemTextColor(); }
    public static ColorUIResource getControlTextColor() { return currentTheme.getControlTextColor(); }  
    public static ColorUIResource getInactiveSystemTextColor() { return currentTheme.getInactiveSystemTextColor(); }
    public static ColorUIResource getUserTextColor() { return currentTheme.getUserTextColor(); }
    public static ColorUIResource getTextHighlightColor() { return currentTheme.getTextHighlightColor(); }
    public static ColorUIResource getHighlightedTextColor() { return currentTheme.getHighlightedTextColor(); }

    public static ColorUIResource getWindowBackground() { return currentTheme.getWindowBackground(); }
    public static ColorUIResource getWindowTitleBackground() { return currentTheme.getWindowTitleBackground(); }  
    public static ColorUIResource getWindowTitleInactiveBackground() { return currentTheme.getWindowTitleInactiveBackground(); }
    public static ColorUIResource getWindowTitleInactiveForeground() { return currentTheme.getWindowTitleInactiveForeground(); }
    public static ColorUIResource getWindowTitleForeground() { return currentTheme.getWindowTitleForeground(); }
    public static ColorUIResource getPaletteTitleBackground() { return currentTheme.getPaletteTitleBackground(); }
    public static ColorUIResource getPaletteTitleForeground() { return currentTheme.getPaletteTitleForeground(); }
    public static ColorUIResource getWindowFrameTop() { return currentTheme.getWindowFrameTop(); }   
    public static ColorUIResource getWindowFrameBottom() { return currentTheme.getWindowFrameBottom(); }   
    public static ColorUIResource getWindowFrameRight() { return currentTheme.getWindowFrameRight(); }   
    public static ColorUIResource getWindowFrameLeft() { return currentTheme.getWindowFrameLeft(); }   
    public static ColorUIResource getWindowFrameInactive() { return currentTheme.getWindowFrameInactive(); }   

    public static ColorUIResource getMenuBackground() { return currentTheme.getMenuBackground(); }
    public static ColorUIResource getMenuForeground() { return  currentTheme.getMenuForeground(); }
    public static ColorUIResource getMenuSelectedBackground() { return currentTheme.getMenuSelectedBackground(); }
    public static ColorUIResource getMenuSelectedForeground() { return currentTheme.getMenuSelectedForeground(); }
    public static ColorUIResource getMenuItemForeground() { return  currentTheme.getMenuItemForeground(); }
    public static ColorUIResource getMenuItemSelectedForeground() { return  currentTheme.getMenuItemSelectedForeground(); }

}
    
