/*
 * @(#)OrganicLabelUI.java	1.5 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.*;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Insets;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Font;
import java.awt.FontMetrics;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.BasicLabelUI;



/**
 * A Java L&F implementation of LabelUI.  This implementation 
 * is completely static, i.e. there's only one UIView implementation 
 * that's shared by all JLabel objects.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.5 02/02/98
 * @author Tom Santos
 */
public class OrganicLabelUI extends BasicLabelUI
{
    private static final OrganicLabelUI organicLabelUI = new OrganicLabelUI();


    public static ComponentUI createUI(JComponent c) {
	return organicLabelUI;
    }

    public void paint(Graphics g, JComponent c) 
    {
	JLabel label = (JLabel)c;
	String text = label.getText();

	Icon icon;
	if(label.isEnabled()) {
	    icon = label.getIcon();
	} else {
	    icon = label.getDisabledIcon();
	}

	if ((icon == null) && (text == null)) {
	    return;
	}

	FontMetrics fm = g.getFontMetrics();
	Rectangle iconR = new Rectangle();
	Rectangle textR = new Rectangle();
	Rectangle viewR = new Rectangle(c.getSize());
	Insets viewInsets = c.getInsets();

	viewR.x = viewInsets.left;
	viewR.y = viewInsets.top;
	viewR.width -= (viewInsets.left + viewInsets.right);
	viewR.height -= (viewInsets.top + viewInsets.bottom);

	String clippedText = layoutCL(label, fm, text, icon, viewR, iconR, textR);

	if (label.isOpaque()) {
	    g.setColor(label.getBackground());
	    g.fillRect(0, 0, label.getWidth(), label.getHeight());
	}

	if (icon != null) {
	    icon.paintIcon(c, g, iconR.x, iconR.y);
	}

	if (text != null) {
	    int textX = textR.x;
	    int textY = textR.y + fm.getAscent();
	    int accChar = label.getDisplayedMnemonic();

	    if (label.isEnabled()) {
		g.setColor(label.getForeground());
	    }
	    else {
	        g.setColor( UIManager.getColor("Label.disabled") );
	    }

	    OrganicUtilities.drawString(g, clippedText, accChar, textX, textY);
	}
    }
}

