/*
 * @(#)OrganicInternalFrameUI.java	1.6 98/02/06
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.basic.*;
import java.util.EventListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.*;
import java.io.Serializable;

/**
 * Organic implementation of JInternalFrame.  
 *
 * @version 1.6 02/06/98
 * @author Steve Wilson
 */
public class OrganicInternalFrameUI extends BasicInternalFrameUI {

  private OrganicInternalFrameTitlePane titlePane;

  private PropertyChangeListener paletteListener;
  
  protected static String IS_PALETTE = "JInternalFrame.isPalette";

  public OrganicInternalFrameUI(JInternalFrame b)   {
    super(b);
  }

  public static ComponentUI createUI(JComponent c)    {
      return new OrganicInternalFrameUI( (JInternalFrame) c);
  }

  public void installUI(JComponent c) { 
    frame = (JInternalFrame)c;

    paletteListener = new PaletteListener();
    c.addPropertyChangeListener(paletteListener);

    super.installUI(c);

    Object paletteProp = c.getClientProperty( IS_PALETTE );
    if ( paletteProp != null ) {
	setPalette( ((Boolean)paletteProp).booleanValue() );
    }
  }
  
  public void uninstallUI(JComponent c) {                  
      c.removePropertyChangeListener(paletteListener);
      super.uninstallUI(c);
  } 
    
  protected JComponent createNorthPane(JInternalFrame w) {
    titlePane = new OrganicInternalFrameTitlePane(w);
    return titlePane;
  }

  public void setPalette(boolean isPalette) {
    if (isPalette) {
        LookAndFeel.installBorder(frame, "InternalFrame.paletteBorder");
	//    frame.setBorder(organicPaletteBorder);
    } else {
        LookAndFeel.installBorder(frame, "InternalFrame.border");
	//   frame.setBorder(organicFrameBorder);
    }
    titlePane.setPalette(isPalette);

  }

  class PaletteListener implements PropertyChangeListener, Serializable {
    public void propertyChange(PropertyChangeEvent e) {
	String name = e.getPropertyName();
	if ( name.equals( IS_PALETTE ) ) {
	    if ( e.getNewValue() != null ) {
	        setPalette( ((Boolean)e.getNewValue()).booleanValue() );
	    }
	    else {
		setPalette( false );
	    }
        }
    }
  } // end class PaletteListener

}

