/*
 * @(#)OrganicInternalFrameTitlePane.java	1.4 98/04/10
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.event.InternalFrameEvent;
import java.util.EventListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.beans.PropertyVetoException;

class OrganicActiveInternalFrameButtonUI extends OrganicButtonUI {
    protected Color getSelectColor()       { return OrganicLookAndFeel.getControl3(); }
}

class OrganicInactiveInternalFrameButtonUI extends OrganicButtonUI {
    protected Color getSelectColor()       { return OrganicLookAndFeel.getControl2(); }
}

class OrganicPaletteButtonUI extends OrganicButtonUI {
    protected Color getSelectColor()       { return OrganicLookAndFeel.getHighlight4(); }
}

class OrganicActiveFrameButtonBorder extends OrganicRolloverButtonBorder {    
    protected Color getTopLeftColor()            { return OrganicLookAndFeel.getLightAccent1(); }
    protected Color getBottomRightColor()        { return OrganicLookAndFeel.getControl3(); }
    protected Color getPressedBottomRightColor() { return OrganicLookAndFeel.getControl1(); }
}

class OrganicInactiveFrameButtonBorder extends OrganicRolloverButtonBorder {    
    protected Color getTopLeftColor()      { return OrganicLookAndFeel.getWhite(); }
    protected Color getBottomRightColor()  { return OrganicLookAndFeel.getControl3(); }
}

class OrganicPaletteButtonBorder extends OrganicRolloverButtonBorder {    
    protected Color getTopLeftColor()            { return OrganicLookAndFeel.getLightAccent1(); }
    protected Color getBottomRightColor()        { return OrganicLookAndFeel.getHighlight4(); }
    protected Color getPressedBottomRightColor() { return OrganicLookAndFeel.getHighlight2(); }
}

/**
 * Package private class that manages a organic title bar
 * @version 1.4 04/10/98
 * @author Michael C. Albers
 */
// Could not extend BasicInternalFrameTitlePane because it's private
class OrganicInternalFrameTitlePane extends JComponent 
                                implements LayoutManager, 
					   ActionListener, 
					   PropertyChangeListener {

  protected JMenuBar menuBar;
  protected boolean isPalette = false;					    
  JInternalFrame frame;
  // the three control buttons
  protected OrganicInternalFrameButton iconButton;
  protected OrganicInternalFrameButton maxButton;
  protected OrganicInternalFrameButton closeButton;
  // the rollover borders for these buttons
  protected static Border activeFrameButtonBorder =  new OrganicActiveFrameButtonBorder();
  protected static Border inactiveFrameButtonBorder =  new OrganicInactiveFrameButtonBorder();
  protected static Border paletteButtonBorder =  new OrganicPaletteButtonBorder();

  // The different colored UI objects for active and inactive frames
  protected static OrganicActiveInternalFrameButtonUI activeFrameUI = new OrganicActiveInternalFrameButtonUI();
  protected static OrganicInactiveInternalFrameButtonUI inactiveFrameUI = new OrganicInactiveInternalFrameButtonUI();
  protected static OrganicPaletteButtonUI paletteButtonUI = new OrganicPaletteButtonUI();

  // the pictures/icons in these three buttons
  Icon maxIcon; 
  Icon altMaxIcon; 
  Icon iconIcon; 
  Icon closeIcon;

  final int RESTORE_MENU_ITEM = 0;
  final int MOVE_MENU_ITEM = 1;
  final int SIZE_MENU_ITEM = 2;
  final int MINIMIZE_MENU_ITEM = 3;
  final int MAXIMIZE_MENU_ITEM = 4;
  final int SEPARATOR_MENU_ITEM = 5;
  final int CLOSE_MENU_ITEM = 6;

  static Color activeForeground;
  static Color inactiveForeground;
  static Color activeBackground;
  static Color inactiveBackground;					     
  static Color paletteForeground;
  static Color paletteBackground;
    
  public OrganicInternalFrameTitlePane(JInternalFrame f) {
    frame = f;
    //   setPreferredSize(new Dimension(100, 19));
    
    activeForeground = UIManager.getColor("InternalFrameTitlePane.activeForeground");
    inactiveForeground = UIManager.getColor("InternalFrameTitlePane.inactiveForeground");
    activeBackground = UIManager.getColor("InternalFrameTitlePane.activeBackground");
    inactiveBackground = UIManager.getColor("InternalFrameTitlePane.inactiveBackground");				     
    paletteForeground = UIManager.getColor("InternalFrameTitlePane.paletteForeground");
    paletteBackground = UIManager.getColor("InternalFrameTitlePane.paletteBackground");
    maxIcon = (Icon)UIManager.get("InternalFrameTitlePane.maximizeIcon");
    altMaxIcon = (Icon)UIManager.get("InternalFrameTitlePane.altMaximizeIcon");
    iconIcon = (Icon)UIManager.get("InternalFrameTitlePane.iconizeIcon");
    closeIcon = (Icon)UIManager.get("InternalFrameTitlePane.closeIcon");

    setFont( UIManager.getFont("InternalFrameTitlePane.font") );
    menuBar = new JMenuBar(){
      public boolean isFocusTraversable() { return false; }
      public void requestFocus() {}
      // PENDING(klobad) Should be able to configure Menu + Button instead
      public void paint(Graphics g) {}
      public boolean isOpaque() { return false; }
    };
    
    menuBar.setBorderPainted(false);
    
    iconButton = new OrganicInternalFrameButton( inactiveFrameUI );
    if(!frame.isIcon())
      iconButton.setIcon(iconIcon);
    else
      iconButton.setIcon(iconIcon);  // iconify
    iconButton.setFocusPainted(false);
    iconButton.addActionListener(this);
    iconButton.setActionCommand("Iconify");
    

    maxButton = new OrganicInternalFrameButton( inactiveFrameUI );
    if(!frame.isMaximum())
      maxButton.setIcon(maxIcon);
    else
      maxButton.setIcon(altMaxIcon);
    maxButton.setFocusPainted(false);
    maxButton.addActionListener(this);
    maxButton.setActionCommand("Maximize");
    

    closeButton = new OrganicInternalFrameButton( inactiveFrameUI );
    closeButton.setIcon(closeIcon);
    closeButton.setFocusPainted(false);     
    closeButton.addActionListener(this);
    closeButton.setActionCommand("Close");
    
    setLayout(this);
    
    add(menuBar);
    add(iconButton);
    add(maxButton);
    add(closeButton);             
    
    // Make sure these are ok to leave on?
    frame.addPropertyChangeListener(this);
    updateControls();
  }
					     
  public void paint(Graphics g)  {
    boolean isSelected = frame.isSelected();
    Color color = g.getColor();
    

    g.setColor(getTitleBarColor());
    g.fillRect(0, 0, getWidth(), getHeight());
    
    if(frame.getTitle() != null) {
      Font f = getFont();
      g.setFont(f);
      FontMetrics fm = g.getFontMetrics();
      int fHeight = fm.getHeight();

      int xOffset = 2;
      Icon icon = frame.getFrameIcon();
      if ( icon != null ) {
        xOffset += icon.getIconWidth()+2;
	icon.paintIcon(frame, g, 2, 2);
      }


      g.setColor(getTitleTextColor());
      int yOffset = 2;
      if (isPalette)
	  yOffset++;
      g.drawString(frame.getTitle(),
		   menuBar.getX() + menuBar.getWidth() + xOffset,
		   fHeight - yOffset);

      if (isPalette) {
	  g.drawLine(0, fHeight+2, getWidth(), fHeight+2 );
	
      }
      g.setFont(f);
    }
    
    g.setColor(color);
    super.paint(g);
  }
					     
    /**
     * Post a WINDOW_CLOSING-like event to the frame, so that it can
     * be treated like a regular Frame.
     */
    void postClosingEvent(JInternalFrame frame) {
        InternalFrameEvent e = new InternalFrameEvent(
            frame, InternalFrameEvent.INTERNAL_FRAME_CLOSING);
        // Try posting event, unless there's a SecurityManager.
        if (JInternalFrame.class.getClassLoader() == null) {
            try {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(e);
                return;
            } catch (SecurityException se) {
                // Use dispatchEvent instead.
            }
        }
        frame.dispatchEvent(e);
    }

    public void actionPerformed(ActionEvent e) {
      if("Close".equals(e.getActionCommand()) && frame.isClosable())
          postClosingEvent(frame);
      else if("Iconify".equals(e.getActionCommand()) && frame.isIconifiable()) {
	if(!frame.isIcon())
	  try { frame.setIcon(true); } catch (PropertyVetoException e1) { }
	else
	  try { frame.setIcon(false); } catch (PropertyVetoException e1) { }

	  ButtonModel model = iconButton.getModel();
	  if ( model != null ) {
	      model.setRollover( false );
	  }
      } else if("Minimize".equals(e.getActionCommand()) && frame.isMaximizable()) {
	try { frame.setIcon(true); } catch (PropertyVetoException e2) { }
      } else if("Maximize".equals(e.getActionCommand()) && frame.isMaximizable()) {
	if(!frame.isMaximum()) {
	  try { frame.setMaximum(true); } catch (PropertyVetoException e5) { }
	} else {
	  try { frame.setMaximum(false); } catch (PropertyVetoException e6) { }
	}
      } else if("Restore".equals(e.getActionCommand()) && 
                frame.isMaximizable() && frame.isMaximum()) {
	try { frame.setMaximum(false); } catch (PropertyVetoException e4) { }
      } else if("Restore".equals(e.getActionCommand()) && 
                frame.isIconifiable() && frame.isIcon()) {
	try { frame.setIcon(false); } catch (PropertyVetoException e4) { }
      }
    }
					     
    public void propertyChange(PropertyChangeEvent evt) {
      String prop = (String)evt.getPropertyName();
      JInternalFrame f = (JInternalFrame)evt.getSource();
      boolean value = false;

      if ( frame.isSelected() ) {
	  repaint();
      }
      if(JInternalFrame.IS_SELECTED_PROPERTY.equals(prop)) {
	  updateControls();
	  repaint();
      } else if(JInternalFrame.IS_MAXIMUM_PROPERTY.equals(prop)) {
	value = ((Boolean)evt.getNewValue()).booleanValue();
	if(value)
	  maxButton.setIcon(altMaxIcon);
	else
	  maxButton.setIcon(maxIcon);  
      } else if(JInternalFrame.IS_ICON_PROPERTY.equals(prop)) {
	value = ((Boolean)evt.getNewValue()).booleanValue();
	if(value)
	  iconButton.setIcon(iconIcon);
	else
	  iconButton.setIcon(iconIcon);  
      } 
    }
    
    public void addLayoutComponent(String name, Component c) {}
    public void removeLayoutComponent(Component c) {}   
 
   public Dimension preferredLayoutSize(Container c)  {
       return getPreferredSize(c);
    }


    public Dimension getPreferredSize(Container c)  {
      return new Dimension(c.getSize().width, computeHeight());
    }

    public Dimension minimumLayoutSize(Container c) {
      return preferredLayoutSize(c);
    } 
    
    protected int computeHeight() {
      FontMetrics fm =  Toolkit.getDefaultToolkit().getFontMetrics(getFont());
      int fHeight = fm.getHeight();
      fHeight += 3;
      return fHeight;
    }	
				    
    public void layoutContainer(Container c) {
      int w = getWidth();
      int buttonHeight = computeHeight()-2;  // this includes the border
      int buttonWidth = buttonHeight+3;  // this includes the border

      int x = (w - buttonWidth) - 1;
      
      if(frame.isClosable()) {
	closeButton.setBounds(x, 1, buttonWidth, buttonHeight);
	x -= buttonWidth;
      } else if(closeButton.getParent() != null) {
	closeButton.getParent().remove(closeButton);
      }
      
      if(frame.isMaximizable()) {
	maxButton.setBounds(x, 1, buttonWidth, buttonHeight);
	x -= buttonWidth;
      } else if(maxButton.getParent() != null) {
	maxButton.getParent().remove(maxButton);
      }
      
      if(frame.isIconifiable()) {
	iconButton.setBounds(x, 1, buttonWidth, buttonHeight);
      } else if(iconButton.getParent() != null) {
	iconButton.getParent().remove(iconButton);
      }
    } 

    protected Color getTitleBarColor() {
        Color color;
	if (isPalette)
	  color = paletteBackground;
	else {
	  if (frame.isSelected())
	    color = activeBackground;
	  else
	    color = inactiveBackground;
	}
	return color;
    }

    protected Color getTitleTextColor() {
        Color color;
	if (isPalette)
	  color = paletteForeground;
	else {
	  if (frame.isSelected())
	    color = activeForeground;
	  else
	    color = inactiveForeground;
	}
	return color;
    }

    public void setPalette(boolean b) {
        isPalette = b;
	updateControls();
    }

    protected void updateControls() {
      Color background;
      if (isPalette) {
	      background = paletteBackground;
	      iconButton.setNewUI( paletteButtonUI );
	      iconButton.setBorder( paletteButtonBorder );

	      maxButton.setNewUI( paletteButtonUI );
	      maxButton.setBorder( paletteButtonBorder );
	      closeButton.setNewUI( paletteButtonUI );
	      closeButton.setBorder( paletteButtonBorder );
      } 
      else {
	  if ( frame.isSelected() ) {
	      background = activeBackground;
	      iconButton.setNewUI( activeFrameUI );
	      iconButton.setBorder( activeFrameButtonBorder );
	      maxButton.setNewUI( activeFrameUI );
	      maxButton.setBorder( activeFrameButtonBorder );
	      closeButton.setNewUI( activeFrameUI );
	      closeButton.setBorder( activeFrameButtonBorder );
	  }
	  else {
	      background = inactiveBackground;
	      iconButton.setNewUI( inactiveFrameUI );
	      iconButton.setBorder( inactiveFrameButtonBorder );
	      maxButton.setNewUI( inactiveFrameUI );
	      maxButton.setBorder( inactiveFrameButtonBorder );
	      closeButton.setNewUI( inactiveFrameUI );
	      closeButton.setBorder( inactiveFrameButtonBorder );
	  }
      }
      iconButton.setBackground( background );
      maxButton.setBackground( background );
      closeButton.setBackground( background );
    }					     
};    /// End Title Pane Class
