/*
 * @(#)OrganicIconFactory.java	1.7 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.*;
import com.sun.java.swing.plaf.UIResource;
import java.awt.*;
import java.io.Serializable;

/**
 * Factory object that can vend Icons appropriate for the organic.
 * These are used extensively in OrganicLookAndFeel via the defaults mechanism.
 * While other Look and Feels use GIFs for some of these, doing this work in code
 * facilitates things when switching to other Themes.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.7 02/02/98
 * @author Michael C. Albers
 */
public class OrganicIconFactory implements Serializable {
    private static Icon frame_closeIcon;
    private static Icon frame_iconifyIcon;
    private static Icon frame_maxIcon;
    private static Icon frame_minIcon;
    private static Icon frame_resizeIcon;
    private static Icon checkBoxIcon;
    private static Icon radioButtonIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon menuItemCheckIcon;
    private static Icon menuItemArrowIcon;
    private static Icon menuArrowIcon;
    private static Icon treeNodeClosedIcon;
    private static Icon treeNodeOpenIcon;
    private static Icon treeNodeLeafIcon;
    private static Icon treeComputerIcon;
    private static Icon treeHardDriveIcon;
    private static Icon treeFloppyDriveIcon;
    private static Icon fileChooserNewFolderIcon;
    private static Icon fileChooserUpFolderIcon;
    private static Icon fileChooserHomeFolderIcon;
    private static Icon fileChooserDetailsViewIcon;
    private static Icon fileChooserListViewIcon;

    public static Icon getFileChooserListViewIcon() {
	if (fileChooserListViewIcon == null) {
	    fileChooserListViewIcon = new FileChooserListViewIcon();
	}
	return fileChooserListViewIcon;
    }

    public static Icon getFileChooserDetailsViewIcon() {
	if (fileChooserDetailsViewIcon == null) {
	    fileChooserDetailsViewIcon = new FileChooserDetailsViewIcon();
	}
	return fileChooserDetailsViewIcon;
    }

    public static Icon getFileChooserHomeFolderIcon() {
	if (fileChooserHomeFolderIcon == null) {
	    fileChooserHomeFolderIcon = new FileChooserHomeFolderIcon();
	}
	return fileChooserHomeFolderIcon;
    }

    public static Icon getFileChooserUpFolderIcon() {
	if (fileChooserUpFolderIcon == null) {
	    fileChooserUpFolderIcon = new FileChooserUpFolderIcon();
	}
	return fileChooserUpFolderIcon;
    }

    public static Icon getFileChooserNewFolderIcon() {
	if (fileChooserNewFolderIcon == null) {
	    fileChooserNewFolderIcon = new FileChooserNewFolderIcon();
	}
	return fileChooserNewFolderIcon;
    }

    public static Icon getTreeNodeClosedIcon() {
	if (treeNodeClosedIcon == null) {
	    treeNodeClosedIcon = new TreeNodeClosedIcon();
	}
	return treeNodeClosedIcon;
    }

    public static Icon getTreeNodeOpenIcon() {
	if (treeNodeOpenIcon == null) {
	    treeNodeOpenIcon = new TreeNodeOpenIcon();
	}
	return treeNodeOpenIcon;
    }

    public static Icon getTreeNodeLeafIcon() {
	if (treeNodeLeafIcon == null) {
	    treeNodeLeafIcon = new TreeNodeLeafIcon();
	}
	return treeNodeLeafIcon;
    }

    public static Icon getTreeComputerIcon() {
	if (treeComputerIcon == null) {
	    treeComputerIcon = new TreeComputerIcon();
	}
	return treeComputerIcon;
    }

    public static Icon getTreeHardDriveIcon() {
	if (treeHardDriveIcon == null) {
	    treeHardDriveIcon = new TreeHardDriveIcon();
	}
	return treeHardDriveIcon;
    }

    public static Icon getTreeFloppyDriveIcon() {
	if (treeFloppyDriveIcon == null) {
	    treeFloppyDriveIcon = new TreeFloppyDriveIcon();
	}
	return treeFloppyDriveIcon;
    }

    public static Icon getMenuItemCheckIcon() {
	if (menuItemCheckIcon == null) {
	    menuItemCheckIcon = new MenuItemCheckIcon();
	}
	return menuItemCheckIcon;
    }

    public static Icon getMenuItemArrowIcon() {
	if (menuItemArrowIcon == null) {
	    menuItemArrowIcon = new MenuItemArrowIcon();
	}
	return menuItemArrowIcon;
    }

    public static Icon getMenuArrowIcon() {
	if (menuArrowIcon == null) {
	    menuArrowIcon = new MenuArrowIcon();
	}
	return menuArrowIcon;
    }

    public static Icon getCheckBoxIcon() {
	if (checkBoxIcon == null) {
	    checkBoxIcon = new CheckBoxIcon();
	}
	return checkBoxIcon;
    }

    public static Icon getRadioButtonIcon() {
	if (radioButtonIcon == null) {
	    radioButtonIcon = new RadioButtonIcon();
	}
	return radioButtonIcon;
    }
  
    public static Icon getCheckBoxMenuItemIcon() {
	if (checkBoxMenuItemIcon == null) {
	    checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
	}
	return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
	if (radioButtonMenuItemIcon == null) {
	    radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
	}
	return radioButtonMenuItemIcon;
    }
  
  public static Icon createFrameCloseIcon() {
    if(frame_closeIcon == null)
      frame_closeIcon = new CloseIcon();
    return frame_closeIcon;
  }
  
  public static Icon createFrameIconifyIcon() {
    if(frame_iconifyIcon == null)
      frame_iconifyIcon = new IconifyIcon();
    return frame_iconifyIcon;
  }
  
  public static Icon createFrameMaximizeIcon() {
    if(frame_maxIcon == null)
      frame_maxIcon = new MaximizeIcon();
    return frame_maxIcon;
  }
  
  public static Icon createFrameMinimizeIcon() {
    if(frame_minIcon == null)
      frame_minIcon = new MinimizeIcon();
    return frame_minIcon;
  }
  
  public static Icon createFrameResizeIcon() {
    if(frame_resizeIcon == null)
      frame_resizeIcon = new ResizeIcon();
    return frame_resizeIcon;
  }
  
 
  // Draw the Swirlly
  private static class CloseIcon implements Icon, Serializable {
    int height = 15;
    int width = 18;
    public void paintIcon(Component c, Graphics g, int x, int y) {
      // Do main drawing color first
      g.setColor(OrganicLookAndFeel.getLightAccent1());

      g.translate( x+4, y+3 );

      g.drawLine(3,3, 3,4);
      g.drawLine(4,5, 5,5);
      g.drawLine(6,4, 6,2);
      g.drawLine(5,1, 5,1);
      g.drawLine(4,0, 2,0);
      g.drawLine(1,1, 1,1);
      g.drawLine(0,2, 0,5);
      g.drawLine(1,7, 1,7);
      g.drawLine(3,8, 6,8);
      g.drawLine(8,7, 8,7);
      g.drawLine(9,5, 9,2);

      // Do drawing with accent color
      g.setColor(OrganicLookAndFeel.getControl1());
      g.drawLine(6,1, 6,1);
      g.drawLine(5,0, 5,0);
      g.drawLine(1,0, 1,0);
      g.drawLine(0,1, 0,1);
      g.drawLine(0,6, 1,6);
      g.drawLine(2,7, 2,8);
      g.drawLine(7,8, 7,7);
      g.drawLine(8,6, 9,6);
      g.drawLine(9,1, 8,1);

      g.translate( -(x+4), -(x+3) );
    }
    public int getIconWidth() { return width; }
    public int getIconHeight() { return height; }
  };
  
  private static class IconifyIcon implements Icon, Serializable {
    int height = 15;
    int width = 18;
    public void paintIcon(Component c, Graphics g, int x, int y) {
      // Do main drawing color first
      g.setColor(OrganicLookAndFeel.getLightAccent1());

      g.translate( x+4, y+4 );

      g.drawLine(0,1, 1,2);
      g.drawLine(5,0, 5,1);
      g.drawLine(9,2, 10,1);
      g.fillRect(3,6, 5, 2 );

      // Do drawing with accent color
      g.setColor(OrganicLookAndFeel.getControl1());
      g.drawLine(0,2, 1,1);
      g.drawLine(2,3, 2,3);
      g.drawLine(5,2, 5,2);
      g.drawLine(9,1, 10,2);
      g.drawLine(8,3, 8,3);

      g.translate( -(x+4), -(y+4) );
    }
    public int getIconWidth() { return width; }
    public int getIconHeight() { return height; }
  };
  
  private static class MaximizeIcon implements Icon, Serializable {
    int height = 15;
    int width = 18;
    public void paintIcon(Component c, Graphics g, int x, int y) {
      g.setColor(OrganicLookAndFeel.getLightAccent1());

      g.translate( x+4, y+4 );

      g.drawRect(1,0, 8,8);
      g.drawLine(2,1, 8,1);

      g.translate( -(x+4), -(y+4) );
    }
    public int getIconWidth() { return width; }
    public int getIconHeight() { return height; }
  };
  
  private static class MinimizeIcon implements Icon, Serializable {
    int height = 16;
    int width = 14;
    public void paintIcon(Component c, Graphics g, int x, int y) {
      g.setColor(OrganicLookAndFeel.getControl1());

      // Draw the little window
      g.translate( x+1, y+6 );

      g.drawRect(1,0, 8,7);
      g.drawLine(2,1, 8,1);

      g.translate( -(x+1), -(y+6) );

      // Draw the action
      g.translate( x+2, y+1 );

      g.setColor( OrganicLookAndFeel.getLightAccent1() );
      g.drawLine( 6,1, 6,2 );
      g.drawLine( 10,3, 11,2 );
      g.drawLine( 11,7, 12,7 );

      g.setColor( OrganicLookAndFeel.getControl1() );
      g.drawLine( 6,3, 6,3 );
      g.drawLine( 10,2, 11,3 );
      g.drawLine( 9,4, 9,4 );
      g.drawLine( 10,7, 10,7 );

      g.translate( -(x+2), -(y+1) );
    }
    public int getIconWidth() { return width; }
    public int getIconHeight() { return height; }
  };
  
  private static class ResizeIcon implements Icon, Serializable {
    public void paintIcon(Component c, Graphics g, int x, int y) {
      g.setColor(OrganicLookAndFeel.getLightAccent1() );
      g.drawLine(0, 11, 11, 0);
      g.drawLine(4, 11, 11, 4);
      g.drawLine(8, 11, 11, 8);
      
      g.setColor(OrganicLookAndFeel.getWindowTitleBackground() );
      g.drawLine(1, 11, 11, 1);
      g.drawLine(2, 11, 11, 2);
      g.drawLine(5, 11, 11, 5);
      g.drawLine(6, 11, 11, 6);
      g.drawLine(9, 11, 11, 9);
      g.drawLine(10, 11, 11, 10);
    }
    public int getIconWidth() { return 13; }
    public int getIconHeight() { return 13; }
  };
  
    private static class CheckBoxIcon implements Icon, UIResource, Serializable
    {
	public void paintIcon( Component c, Graphics g, int x, int y )
	{

	}

	public int getIconWidth() { return 0; }

	public int getIconHeight() { return 0; }

    }  // End class CheckBoxIcon

    private static class CheckBoxMenuItemIcon implements Icon, UIResource, Serializable
    {
	public void paintIcon( Component c, Graphics g, int x, int y )
	{
	    AbstractButton b = (AbstractButton) c;
	    ButtonModel model = b.getModel();
	    boolean isSelected = model.isSelected();
	    boolean isPressed = model.isPressed();
	    boolean isArmed = model.isArmed();
	    
	    Color oldColor = g.getColor();
	    g.translate( 5, 0 );

	    g.setColor( OrganicLookAndFeel.getControl2()  );
	    g.drawRect( x, y, 8, 8 );

	    if ( isPressed || isArmed )
	    {
		g.setColor( OrganicLookAndFeel.getMenuBackground()  );
	        g.fillRect( x + 1, y + 1, 7, 7 );
	    }

	    if ( isSelected )
	    {
	        g.translate( 2, 0 );
		
		g.setColor( OrganicLookAndFeel.getMenuForeground()  );
		g.drawLine( x, y + 2, x, y + 6 );
		g.drawLine( x + 1, y + 2, x + 1, y + 6 );
		g.drawLine( x + 2, y + 4, x + 6, y );
		g.drawLine( x + 2, y + 5, x + 7, y );
		
		g.translate( -2, 0 );
	    }

	    g.translate( -5, 0 );
	    g.setColor( oldColor );
	}

	public int getIconWidth() { return 12; }

	public int getIconHeight() { return 9; }

    }  // End class CheckBoxMenuItemIcon

    private static class RadioButtonIcon implements Icon, UIResource, Serializable
    {
        public void paintIcon(Component c, Graphics g, int x, int y) {
	        JRadioButton rb = (JRadioButton)c;
		ButtonModel model = rb.getModel();

	        Color background = UIManager.getColor("RadioButton.background");
	        Color shadow = UIManager.getColor("RadioButton.shadow");
	        Color darkShadow = UIManager.getColor("RadioButton.darkShadow");
	        Color highlight = UIManager.getColor("RadioButton.highlight");
	        Color lightHighlight = UIManager.getColor("RadioButton.lightHighlight");
		Color dot = UIManager.getColor("RadioButton.dot");

		// Set up the colors for each area
		Color outerLeftColor = lightHighlight;
		if ( !model.isEnabled() ) {
		    outerLeftColor = shadow;
		}
		else if ( model.isSelected() || (model.isPressed() && model.isArmed() ) ) {
		    outerLeftColor = darkShadow;
		}
		
		Color outerRightColor = shadow;
		if ( !model.isEnabled() ) {
		    outerRightColor = shadow;
		}
		else if ( model.isSelected() || (model.isPressed() && model.isArmed()) ) {
		    outerRightColor = lightHighlight;
		}
		
		// Set up the colors for each area
		Color leftColor = lightHighlight;
		Color rightColor = shadow;
		Color dotColor = dot;
		Color interiorColor = background;
		boolean drawDot = model.isSelected();
		boolean drawCorners = !model.isEnabled();

		if ( !model.isEnabled() ) {
		    interiorColor = background;
		    leftColor = shadow;
		    rightColor =shadow;
		    dotColor = darkShadow;
		}
		else if ( model.isPressed() && model.isArmed() ) {
		    if ( model.isSelected() ) {
		        interiorColor = background;
		    }
		    else {
		        interiorColor = shadow;
		    }
		    leftColor = darkShadow;
		    rightColor = lightHighlight;		    
		}
		else if ( model.isSelected() ) {
		    interiorColor = background;
		    leftColor = darkShadow;
		    rightColor = lightHighlight;		    
		}
		else {
		    interiorColor = background;
		    leftColor = lightHighlight;
		    rightColor = shadow;
		}

		// fill interior
		g.setColor( interiorColor );
		g.fillRect(x+2, y+2, 9, 9);
		g.drawLine(x+4, y+1, x+9, y+1);
		g.drawLine(x+11, y+3, x+11, y+8);
		g.drawLine(x+8, y+11, x+3, y+11);
		g.drawLine(x+1, y+9, x+1, y+4);
		
		// outter left arc
		g.setColor( leftColor );
		g.drawLine(x+1, y+10, x+1, y+10);
		g.drawLine(x+0, y+8, x+0, y+4);
		g.drawLine(x+1, y+3, x+1, y+2);
      		g.drawLine(x+2, y+1, x+3, y+1);
      		g.drawLine(x+4, y+0, x+8, y+0);
      		g.drawLine(x+10, y+1, x+10, y+1);
 
		// outer right arc
		g.setColor( rightColor );
		g.drawLine(x+11, y+2, x+11, y+2);
		g.drawLine(x+12, y+4, x+12, y+8);
		g.drawLine(x+11, y+9, x+11, y+10);
		g.drawLine(x+10, y+11, x+9, y+11);
		g.drawLine(x+8, y+12, x+4, y+12);
		g.drawLine(x+2, y+11, x+2, y+11);
		
		// corners
		if ( drawCorners ) {
		    g.drawLine( x+1, y+9, x+1, y+9 );
		    g.drawLine( x+9, y+1, x+9, y+1 );		    
		    g.drawLine( x+11, y+3, x+11, y+3 );
		    g.drawLine( x+3, y+11, x+3, y+11 );
		}
 
		// selected dot
		if ( drawDot ) {
		    g.setColor( dotColor );
		    g.fillRect(x+4, y+4, 5, 5);
		    g.fillRect(x+5, y+3, 3, 7);
		    g.fillRect(x+3, y+5, 7, 3);
		    g.setColor(darkShadow);
		    g.drawLine(x+3, y+4, x+4, y+3);
		    g.drawLine(x+8, y+3, x+9, y+4);
		    g.drawLine(x+9, y+8, x+8, y+9);
		    g.drawLine(x+4, y+9, x+3, y+8);
		}

	        // Draw the khaki circle around it
	        g.translate( x, y );
	        g.setColor( background );
	        g.drawLine( -1, 8, -1, 4 );
		g.drawLine( 0, 3, 0, 2 );
		g.drawLine( 1, 1, 1, 1 );
		g.drawLine( 2, 0, 3, 0 );
		g.drawLine( 4, -1, 8, -1 );
		g.drawLine( 9, 0, 10, 0 );
		g.drawLine( 11, 1, 11, 1 );
		g.drawLine( 12, 2, 12, 3 );
		g.drawLine( 13, 4, 13, 8 );
		g.drawLine( 12, 9, 12, 10 );
		g.drawLine( 11, 11, 11, 11 );
		g.drawLine( 9, 12, 10, 12 );
		g.drawLine( 4, 13, 8, 13 );
		g.drawLine( 2, 12, 3, 12 );
		g.drawLine( 1, 11, 1, 11 );
		g.drawLine( 0, 9, 0, 10 );
		g.translate( -x, -y );
	    }

	    public int getIconWidth() {
		return 13;
	    }
		
	    public int getIconHeight() {
		return 13;
	    }

    }  // End class RadioButtonIcon

    private static class RadioButtonMenuItemIcon implements Icon, UIResource, Serializable
    {
	public void paintIcon( Component c, Graphics g, int x, int y )
	{
	    AbstractButton b = (AbstractButton) c;
	    ButtonModel model = b.getModel();
	    boolean isSelected = model.isSelected();
	    boolean isPressed = model.isPressed();
	    boolean isArmed = model.isArmed();

	    Color oldColor = g.getColor();
	    g.translate( 6, 0 );
	    g.setColor( OrganicLookAndFeel.getControl2()  );

	    g.drawLine( x + 2, y, x + 5, y );
	    g.drawLine( x + 1, y + 1, x + 1, y + 1 );
	    g.drawLine( x + 6, y + 1, x + 6, y + 1 );
	    g.drawLine( x, y + 2, x, y + 5 );
	    g.drawLine( x + 7, y + 2, x + 7, y + 5 );
	    g.drawLine( x + 1, y + 6, x + 1, y + 6 );
	    g.drawLine( x + 6, y + 6, x + 6, y + 6 );
	    g.drawLine( x + 2, y + 7, x + 5, y + 7 );
		
	    if ( isSelected )
	    {
		g.setColor( OrganicLookAndFeel.getControl2() );

		g.drawLine( x + 2, y + 1, x + 5, y + 1 );
		g.drawLine( x + 1, y + 2, x + 6, y + 2 );
		g.drawLine( x + 1, y + 3, x + 6, y + 3 );
		g.drawLine( x + 1, y + 4, x + 6, y + 4 );
		g.drawLine( x + 1, y + 5, x + 6, y + 5 );
		g.drawLine( x + 2, y + 6, x + 5, y + 6 );
	    }
	    else if ( isPressed || isArmed )
	    {
		g.setColor( OrganicLookAndFeel.getMenuBackground() );

		g.drawLine( x + 2, y + 1, x + 5, y + 1 );
		g.drawLine( x + 1, y + 2, x + 6, y + 2 );
		g.drawLine( x + 1, y + 3, x + 6, y + 3 );
		g.drawLine( x + 1, y + 4, x + 6, y + 4 );
		g.drawLine( x + 1, y + 5, x + 6, y + 5 );
		g.drawLine( x + 2, y + 6, x + 5, y + 6 );
	    }

	    if ( isSelected )
	    {
	        g.translate( 2, 2 );
		g.setColor( OrganicLookAndFeel.getMenuForeground() );

		g.drawLine( x + 1, y, x + 2, y );
		g.drawLine( x, y + 1, x + 3, y + 1 );
		g.drawLine( x, y + 2, x + 3, y + 2 );
		g.drawLine( x + 1, y + 3, x + 2, y + 3 );
		
	        g.translate( -2, -2 );
	    }

	    g.translate( -6, 0 );
	    g.setColor( oldColor );
	}

	public int getIconWidth() { return 12; }

	public int getIconHeight() { return 9; }

    }  // End class RadioButtonMenuItemIcon

    private static class MenuItemCheckIcon implements Icon, UIResource, Serializable{
	public void paintIcon(Component c, Graphics g, int x, int y) {
	    /* For debugging:
	       Color oldColor = g.getColor();
	    g.setColor(Color.orange);
	    g.fill3DRect(x,y,getIconWidth(), getIconHeight(), true);
	    g.setColor(oldColor);
	    */
	}
	public int getIconWidth() { return 12; }
	public int getIconHeight() { return 9; }

    } // End class MenuItemCheckIcon

    private static class MenuItemArrowIcon implements Icon, UIResource, Serializable {
	public void paintIcon(Component c, Graphics g, int x, int y) {
	    /* For debugging:
	    Color oldColor = g.getColor();
	    g.setColor(Color.green);
	    g.fill3DRect(x,y,getIconWidth(), getIconHeight(), true);
	    g.setColor(oldColor);
	    */
	}
	public int getIconWidth() { return 5; }
	public int getIconHeight() { return 7; }

    } // End class MenuItemArrowIcon

    private static class MenuArrowIcon implements Icon, UIResource, Serializable
    {
	public void paintIcon(Component c, Graphics g, int x, int y)
	{
	    Color oldColor = g.getColor();
	    g.translate( 0, 0 );

	    g.setColor( OrganicLookAndFeel.getMenuForeground() );
	    g.drawLine( x, y, x + 3, y + 3 );
	    g.drawLine( x + 1, y, x + 4, y + 3 );
	    g.drawLine( x, y + 6, x + 3, y + 3 );
	    g.drawLine( x + 1, y + 6, x + 4, y + 3 );

	    g.setColor( OrganicLookAndFeel.getControl3() );
	    g.drawLine( x, y + 1, x + 2, y + 3 );
	    g.drawLine( x, y + 5, x + 2, y + 3 );

	    g.translate( 0, 0 );
	    g.setColor( oldColor );
	}

	public int getIconWidth() { return 5; }

	public int getIconHeight() { return 7; }
    } // End class MenuArrowIcon


  // Draw the icons for a closed tree node
  private static class TreeNodeClosedIcon implements Icon, UIResource, Serializable {
    public void paintIcon(Component c, Graphics g, int x, int y) {
      g.translate(x,y);
      // Draw Tab = draw LightAccent4 (Dark Orange) 
      g.setColor(OrganicLookAndFeel.getLightAccent4());
      g.drawLine(2,2, 5,2);
      g.drawLine(2,3, 5,3);

      // Draw highlights on top left, top right, bottom left
      //  Control2 (medium Khaki)
      g.setColor(OrganicLookAndFeel.getControl2());
      g.drawLine(1,3, 1,3);   // top left
      g.drawLine(13,3, 13,3); // top right
      g.drawLine(1,13, 1,13); // bottom left

      // Draw edges in Control3 (MediumDark Khaki)
      g.setColor(OrganicLookAndFeel.getControl3());
      g.drawLine(6,3, 12,3); // top line
      g.drawLine(1,4, 13,4); // one line down
      g.drawLine(1,5, 1,12); // down the left side
      g.drawLine(14,6, 14,13); // down the right side
      g.drawLine(2,13, 13,13); // bottom line

      // Draw internal highlights (Cream)
      g.setColor(OrganicLookAndFeel.getLightAccent1());
      g.drawLine(3,6, 13,6);  // across the top
      g.drawLine(3,7, 3,12);  // down the left

      // Draw one highlight and the body of the folder (light Khaki)
      g.setColor(OrganicLookAndFeel.getControl1());
      g.drawLine(14,5, 14,5); // single highlight - upper right
      g.fillRect(3,6, 11, 7); // body of folder

      g.translate(-x,-y);
    }
    public int getIconWidth() { return 16; }
    public int getIconHeight() { return 16; }
  };


  // Draw the icons for an open tree node
  private static class TreeNodeOpenIcon implements Icon, UIResource, Serializable {
    public void paintIcon(Component c, Graphics g, int x, int y) {
      g.translate(x,y);
      // Draw Tab = draw LightAccent4 (Dark Orange) 
      g.setColor(OrganicLookAndFeel.getLightAccent4());
      g.drawLine(1,3, 4,3);
      g.drawLine(1,4, 4,4);

      // Draw highlights on top left, top right, bottom left
      //  Control2 (medium Khaki)
      g.setColor(OrganicLookAndFeel.getControl2());
      g.drawLine(0,4, 0,4);   // top left
      g.drawLine(12,4, 12,4); // top right
      g.drawLine(0,13, 0,13); // bottom left

      // Draw inside color for folder (MediumDark Khaki)
      g.setColor(OrganicLookAndFeel.getControl3());
      g.drawLine(5,4, 11,4); // top line
      g.drawLine(0,5, 12,5); // one line down
      g.drawLine(0,6, 3,6); 
      g.fillRect(0,7, 3, 2);
      g.fillRect(0,9, 2, 2);
      g.drawLine(0,11, 0,11);
      g.drawLine(0,12, 0,12);

      // Draw front edge of folder (light green)
      g.setColor(OrganicLookAndFeel.getHighlight2());
      g.drawLine(4,6, 15,6);      //////////// across the top
      g.drawLine(3,7, 3,8);      // down the left
      g.drawLine(2,9, 2,10);    // down the left
      g.drawLine(1,11, 1,12);  // down the left

      // Draw body of the folder (dark green)
      g.setColor(OrganicLookAndFeel.getHighlight4());
      g.drawLine(4,7, 14,7); 
      g.drawLine(4,8, 13,8); 
      g.drawLine(3,9, 13,9); 
      g.drawLine(3,10, 12,10); 
      g.drawLine(2,11, 12,11); 
      g.drawLine(2,12, 11,12);

      // Draw black bottom and right edge
      g.setColor(OrganicLookAndFeel.getBlack());
      g.drawLine(15,7, 15,7);   // right edge
      g.drawLine(14,8, 14,9);   // right edge
      g.drawLine(13,10, 13,11); // right edge
      g.drawLine(12,12, 12,12); // right edge
      g.drawLine(1,13, 12,13);  // bottom edge

      g.translate(-x,-y);
    }
    public int getIconWidth() { return 16; }
    public int getIconHeight() { return 16; }
  };


  // Draw the icons for a leaf tree node
  private static class TreeNodeLeafIcon implements Icon, UIResource, Serializable {
    public void paintIcon(Component c, Graphics g, int x, int y) {
      g.translate(x,y);
      // Draw big blocks of LightAccent1 (Cream) to be the background
      g.setColor(OrganicLookAndFeel.getLightAccent1());
      g.fillRect(3,2, 9, 11); // big top rect
      g.drawLine(9,13, 11,13); // missed a line

      // Draw top  and left edge of document
      g.setColor(OrganicLookAndFeel.getDarkAccent3());
      g.drawLine(2,1, 11,1); // top
      g.drawLine(2,2, 2,11); // left

      // Draw black - right edge and bottom pieces
      g.setColor(OrganicLookAndFeel.getBlack());
      g.drawLine(12,2, 12,14); // right edge
      g.drawLine(8,14, 12,14); // bottom edge
      g.drawLine(8,13, 8,13); // bottom piece
      g.drawLine(7,12, 7,12); // bottom piece
      g.drawLine(5,11, 6,11); // bottom piece
      g.drawLine(3,12, 4,12); // bottom piece
      g.drawLine(5,13, 6,13); // bottom piece

      // Draw DarkAccent4's accents
      g.setColor(OrganicLookAndFeel.getDarkAccent4());
      g.drawLine(12,1, 12,1); // top right pixel
      g.drawLine(7,13, 7,14); // highlights on bottom area
      g.drawLine(6,10, 6,10); // highlights on bottom area
      g.drawLine(6,12, 6,12); // highlights on bottom area

      // Draw DarkAccent1's smattering of color about document
      g.setColor(OrganicLookAndFeel.getDarkAccent1());
      g.drawLine(3,7, 3,7);
      g.drawLine(4,8, 4,8);
      g.drawLine(6,8, 6,8);
      g.drawLine(3,9, 3,9);
      g.drawLine(5,9, 5,9);
      g.drawLine(7,9, 7,9);
      g.drawLine(9,9, 9,9);
      g.drawLine(11,9, 11,9);
      g.drawLine(4,10, 4,10);
      g.drawLine(6,10, 6,10);
      g.drawLine(8,10, 8,10);
      g.drawLine(10,10, 10,10);
      g.drawLine(3,11, 4,11);
      g.drawLine(7,11, 7,11);
      g.drawLine(9,11, 9,11);
      g.drawLine(11,11, 11,11);
      g.drawLine(5,12, 5,12);
      g.drawLine(8,12, 8,12);
      g.drawLine(10,12, 10,12);
      g.drawLine(9,13, 9,13);
      g.drawLine(11,13, 11,13);

      g.translate(-x,-y);
    }
    public int getIconWidth() { return 16; }
    public int getIconHeight() { return 16; }
  };


  // Draw the computer icon used in the tree and directory pane
  private static class TreeComputerIcon implements Icon, UIResource, Serializable {
      Color screenColor = new Color(175,239,223);
    public void paintIcon(Component c, Graphics g, int x, int y) {
      g.translate(x,y);
      // Draw big blocks of Control1 for monitor and CPU
      g.setColor(OrganicLookAndFeel.getControl1());
      g.fillRect(2,0,  12,10); // monitor
      g.fillRect(0,10, 16,6); // CPU

      // Draw top and left edge of monitor and CPU
      g.setColor(OrganicLookAndFeel.getLightAccent1());
      g.drawLine(2,0, 12,0); // monitor - top
      g.drawLine(2,1,  2,8); // monitor - left
      g.drawLine(0,10, 14,10); // CPU - top
      g.drawLine(0,11,  0,14); // CPU - left

      // Draw right and bottom edge of monitor and CPU
      g.setColor(OrganicLookAndFeel.getDarkAccent4());
      g.drawLine(13,1, 13,9); // monitor - right
      g.drawLine( 3,9, 12,9); // monitor - bottom
      g.drawLine(15,11, 15,15); // CPU - right
      g.drawLine(1,15,  14,15); // CPU - bottom

      // Draw floppy drives on CPU
      g.setColor(OrganicLookAndFeel.getControl3());
      g.drawLine( 6,12,  9,12);
      g.drawLine(11,12, 14,12);

      // Draw screen portion of monitor
      g.setColor(screenColor);
      g.fillRect(4,2, 8,6);

      g.translate(-x,-y);
    }
    public int getIconWidth() { return 16; }
    public int getIconHeight() { return 16; }
  };


  // Draw the hard drive icon used in the tree and directory pane
  private static class TreeHardDriveIcon implements Icon, UIResource, Serializable {
    public void paintIcon(Component c, Graphics g, int x, int y) {
      g.translate(x,y);
      // Draw big block of Control1
      g.setColor(OrganicLookAndFeel.getControl1());
      g.fillRect(0,8, 16,7);

      // Draw highlight on hard drive case
      g.setColor(OrganicLookAndFeel.getControl2());
      g.drawLine(2,12, 13,12);

      // Draw little activity lights on hard drive case
      g.setColor(OrganicLookAndFeel.getHighlight1());
      g.drawLine(10,10, 11,10);
      g.setColor(OrganicLookAndFeel.getHighlight2());
      g.drawLine(12,10, 13,10);

      // Draw the left/top highlights on hard drive
      g.setColor(OrganicLookAndFeel.getLightAccent1());
      g.drawLine(0,8, 14,8); // top
      g.drawLine(0,9, 0,13); // left

      // Draw the right/bottom highlights on hard drive
      g.setColor(OrganicLookAndFeel.getDarkAccent3());
      g.drawLine(15,9, 15,14); // right
      g.drawLine(1,14, 14,14); // bottom

      g.translate(-x,-y);
    }
    public int getIconWidth() { return 16; }
    public int getIconHeight() { return 16; }
  };


  // Draw the floppy drive icon used in the tree and directory pane
  private static class TreeFloppyDriveIcon implements Icon, UIResource, Serializable {
      Color screenColor = new Color(175,239,223);
    public void paintIcon(Component c, Graphics g, int x, int y) {
      g.translate(x,y);
      // Draw Control3 for background (becomes the edge only)
      g.setColor(OrganicLookAndFeel.getControl3());
      g.fillRect(0,0, 16,16);

      // Draw Control1 for body of floppy
      g.setColor(OrganicLookAndFeel.getControl1());
      g.fillRect(1,1, 14,14);

      // Draw the label on the floppy
      g.setColor(OrganicLookAndFeel.getLightAccent1());
      g.fillRect(2,1, 12,7);

      // Draw the dashes on the label
      g.setColor(OrganicLookAndFeel.getDarkAccent3());
      g.drawLine(2,0, 13,0);
      g.drawLine(3,2, 12,2);
      g.drawLine(3,4, 12,4);
      g.drawLine(3,6, 12,6);

      // Draw floppy door
      // open part
      g.setColor(OrganicLookAndFeel.getDarkAccent2());
      g.drawLine(11,10, 12,10);
      g.fillRect(12,11, 2,4);
      // actual door part
      g.setColor(OrganicLookAndFeel.getDarkAccent4());
      g.drawLine(5,10, 10,10);
      g.fillRect(4,11, 8,4);
      // draw hole in door
      g.setColor(OrganicLookAndFeel.getLightAccent1());
      g.drawLine(6,11, 6,13);

      g.translate(-x,-y);
    }
    public int getIconWidth() { return 16; }
    public int getIconHeight() { return 16; }
  };


  // Draw the icon for the "new folder" in the file chooser
  private static class FileChooserNewFolderIcon implements Icon, UIResource, Serializable {
    public void paintIcon(Component c, Graphics g, int x, int y) {
      g.translate(x,y);

      // Fill body area with Control1
      g.setColor(OrganicLookAndFeel.getControl1());
      g.fillRect(1,4, 16,10);

      // Draw edge highlights on top and left
      //  LightAccent1 (Cream)
      g.setColor(OrganicLookAndFeel.getLightAccent1());
      g.drawLine(1,4, 16,4); // top - part of this gets overwritten
      g.drawLine(1,5, 1,13); // left

      // Draw edges in DarkAccent3 (Darkish Purple)
      g.setColor(OrganicLookAndFeel.getDarkAccent3());
      g.drawLine(17,5, 17,14); // right
      g.drawLine(2,14, 16,14); // bottom

      // Draw Tab = draw DarkAccent4 (Dark Purple) and DarkAccent1
      g.setColor(OrganicLookAndFeel.getDarkAccent4());
      g.drawLine(3,2, 6,2);
      g.drawLine(2,3, 7,3);
      g.setColor(OrganicLookAndFeel.getDarkAccent1());
      g.drawLine(2,4, 7,4); // overwrites part of a cream line

      g.translate(-x,-y);
    }
    public int getIconWidth() { return 19; }
    public int getIconHeight() { return 17; }
  };


  // Draw the icon for the "up folder" in the file chooser
  private static class FileChooserUpFolderIcon implements Icon, UIResource, Serializable {
    public void paintIcon(Component c, Graphics g, int x, int y) {
      g.translate(x,y);

      // Fill body area of both folders with Control1
      g.setColor(OrganicLookAndFeel.getControl1());
      g.fillRect(0,1, 9,6); // top folder
      g.fillRect(9,10, 9,6); // bottom folder

      // Draw edge highlights on top and left
      //  LightAccent1 (Cream)
      g.setColor(OrganicLookAndFeel.getLightAccent1());
      // Top folder
      g.drawLine(0,1, 8,1); // top - part of this gets overwritten
      g.drawLine(0,2, 0,6); // left
      // Bottom folder
      g.drawLine(9,10, 16,10); // top - part of this gets overwritten
      g.drawLine(9,11, 9,15);  // left

      // Draw edges in DarkAccent3 (Darkish Purple)
      g.setColor(OrganicLookAndFeel.getDarkAccent3());
      // Top Folder
      g.drawLine(9,2, 9,7); // right
      g.drawLine(1,7, 8,7); // bottom
      // Bottom Folder
      g.drawLine(17,11, 17,16); // right
      g.drawLine(10,16, 17,16); // bottom

      // Draw Tab = draw DarkAccent4 (Dark Purple) and DarkAccent1
      g.setColor(OrganicLookAndFeel.getDarkAccent4());
      g.drawLine(1,0, 3,0);  // Top folder
      g.drawLine(10,9, 12,9); // Bottom folder
      g.setColor(OrganicLookAndFeel.getDarkAccent1());
      g.drawLine(1,1, 3,1);     // Top folder - overwrites part of a cream line
      g.drawLine(10,10, 12,10); // Bottom folder - overwrites part of a cream line

      // Draw Arrow in Black and Control2
      g.setColor(OrganicLookAndFeel.getBlack());
      g.drawLine(10,4, 14,4); // horiz line
      g.drawLine(11,3, 11,5);
      g.drawLine(12,2, 12,6);
      g.drawLine(15,5, 15,5); // turning point of arrow
      g.drawLine(16,6, 16,9); // vert line
      g.setColor(OrganicLookAndFeel.getControl2());
      g.drawLine(15,4, 15,4);
      g.drawLine(16,5, 16,5);

      // Draw tree-like connecting line between folders (in DarkAccent4)
      g.setColor(OrganicLookAndFeel.getDarkAccent4());
      g.drawLine(4,10, 4,13); // Vert line
      g.drawLine(5,13, 6,13); // Horiz line

      g.translate(-x,-y);
    }
    public int getIconWidth() { return 19; }
    public int getIconHeight() { return 17; }
  };


  // Draw the icon for the "home folder" in the file chooser
  private static class FileChooserHomeFolderIcon implements Icon, UIResource, Serializable {
    public void paintIcon(Component c, Graphics g, int x, int y) {
      g.translate(x,y);

      // Fill body area with Control1
      g.setColor(OrganicLookAndFeel.getControl1());
      // fill top arrow
      g.drawLine(9,3,  9,3);
      g.drawLine(8,4, 10,4);
      g.drawLine(7,5, 11,5);
      g.drawLine(6,6, 12,6);
      g.drawLine(5,7, 13,7);
      // fill bottom arrow
      g.drawLine(9, 9,  9, 9);
      g.drawLine(8,10, 10,10);
      g.drawLine(7,11, 11,11);
      g.drawLine(6,12, 12,12);
      g.drawLine(5,13, 13,13);

      // Draw edge highlight on the left diagonal in LightAccent1 (Cream)
      g.setColor(OrganicLookAndFeel.getLightAccent1());
      // top arrow
      g.drawLine(8,3, 8,3);
      g.drawLine(7,4, 7,4);
      g.drawLine(6,5, 6,5);
      g.drawLine(5,6, 5,6);
      g.drawLine(4,7, 4,7);
      // bottom arrow
      g.drawLine(8,9,  8,9);
      g.drawLine(7,10, 7,10);
      g.drawLine(6,11, 6,11);
      g.drawLine(5,12, 5,12);
      g.drawLine(4,13, 4,13);

      // Draw edge highlight on the right diagonal in DarkAccent3
      g.setColor(OrganicLookAndFeel.getDarkAccent3());
      // top arrow
      g.drawLine(10,3, 10,3);
      g.drawLine(11,4, 11,4);
      g.drawLine(12,5, 12,5);
      g.drawLine(13,6, 13,6);
      g.drawLine(14,7, 14,7);
      // bottom arrow
      g.drawLine(10,9,  10,9);
      g.drawLine(11,10, 11,10);
      g.drawLine(12,11, 12,11);
      g.drawLine(13,12, 13,12);
      g.drawLine(14,13, 14,13);

      // All Horizontal lines in DarkAccent3 (Darkish Purple)
      g.setColor(OrganicLookAndFeel.getDarkAccent3());
      g.drawLine(4,2,  15,2);  // top
      g.drawLine(4,8,  15,8);  // middle
      g.drawLine(4,14, 15,14); // bottom

      g.translate(-x,-y);
    }
    public int getIconWidth() { return 19; }
    public int getIconHeight() { return 17; }
  };


  // Draw the icon for the "details view" in the file chooser
  private static class FileChooserDetailsViewIcon implements Icon, UIResource, Serializable {
    public void paintIcon(Component c, Graphics g, int x, int y) {
      g.translate(x,y);

      // Fill document area with LightAccent1 (ooooh yummy, Cream filling)
      g.setColor(OrganicLookAndFeel.getLightAccent1());
      g.fillRect(0,2, 11,11); // top part of document
      g.fillRect(5,13, 6, 3); // bottom part of document

      // Draw everything in DarkAccent3
      g.setColor(OrganicLookAndFeel.getDarkAccent3());
      g.drawLine(0,2, 9, 2); // edge highlight on the document's top
      g.drawLine(0,3, 0,12); // edge highlight on the document's left

      // Draw DarkAccent4 highlights
      g.setColor(OrganicLookAndFeel.getDarkAccent4());
      g.drawLine(10,2, 10,2); // top right corner highlight
      g.drawLine(4,11, 4,13); // line in document - partially overwritten by black
      g.drawLine(5,14, 5,15); // line in document

      // Draw everything in Black
      g.setColor(OrganicLookAndFeel.getBlack());
      // document black
      g.drawLine(10,3, 10,15); // edge highlight on the document's right
      g.drawLine(6,15,  9,15); // edge highlight on the document's bottom
      g.drawLine(6,14,  6,14); // random document dot
      g.drawLine(5,13,  5,13); // random document dot
      g.drawLine(4,12,  3,12); // random document dot
      g.drawLine(1,13,  2,13); // random document dot
      g.drawLine(3,14,  4,14); // random document dot
      // details black
      g.drawLine(12,4, 12,4); // top row
      g.drawLine(14,4, 14,4);
      g.drawLine(16,4, 16,4);
      g.drawLine(18,4, 18,4);
      g.drawLine(12,7, 12,7); // second row
      g.drawLine(14,7, 14,7);
      g.drawLine(16,7, 16,7);
      g.drawLine(12,10, 12,10); // third row
      g.drawLine(14,10, 14,10);
      g.drawLine(16,10, 16,10);
      g.drawLine(12,13, 12,13); // bottom row
      g.drawLine(14,13, 14,13);
      g.drawLine(16,13, 16,13);
      g.drawLine(18,13, 18,13);

      // All the little DarkAccent1 dots in document
      //  working left -> right and top -> bottom
      g.setColor(OrganicLookAndFeel.getDarkAccent1());
      g.drawLine(1,8, 1,8);
      g.drawLine(2,9, 2,9);
      g.drawLine(4,9, 4,9);
      g.drawLine(1,10, 1,10);
      g.drawLine(3,10, 3,10);
      g.drawLine(5,10, 5,10);
      g.drawLine(7,10, 7,10);
      g.drawLine(9,10, 9,10);
      g.drawLine(2,11, 2,11);
      g.drawLine(6,11, 6,11);
      g.drawLine(8,11, 8,11);
      g.drawLine(1,12, 2,12);
      g.drawLine(5,12, 5,12);
      g.drawLine(7,12, 7,12);
      g.drawLine(9,12, 9,12);
      g.drawLine(3,13, 3,13);
      g.drawLine(6,13, 6,13);
      g.drawLine(8,13, 8,13);
      g.drawLine(7,14, 7,14);
      g.drawLine(9,14, 9,14);

      g.translate(-x,-y);
    }
    public int getIconWidth() { return 19; }
    public int getIconHeight() { return 17; }
  };


  // Draw the icon for the "list view" in the file chooser
  private static class FileChooserListViewIcon implements Icon, UIResource, Serializable {
    public void paintIcon(Component c, Graphics g, int x, int y) {
      g.translate(x,y);

      // Fill body area of folders with LightAccent1
      g.setColor(OrganicLookAndFeel.getLightAccent1());
      g.fillRect(1,2,   3,4); // top left folder
      g.fillRect(11,2,  3,4); // top right folder
      g.fillRect(1,10,  3,4); // bottom left folder
      g.fillRect(11,10, 3,4); // bottom right folder

      // Draw top/left/bottomish edges in DarkAccent3 (Darkish Purple)
      g.setColor(OrganicLookAndFeel.getDarkAccent3());
      // top left document
      g.drawLine(0,1, 3,1); // top
      g.drawLine(0,2, 0,6); // left
      g.drawLine(1,6, 2,6); // bottomish
      g.drawLine(2,7, 2,7); // bottomish
      // top right document
      g.drawLine(10,1, 13,1); // top
      g.drawLine(10,2, 10,6); // left
      g.drawLine(11,6, 12,6); // bottomish
      g.drawLine(12,7, 12,7); // bottomish
      // bottom left document
      g.drawLine(0,9, 3,9); // top
      g.drawLine(0,10, 0,14); // left
      g.drawLine(1,14, 2,14); // bottomish
      g.drawLine(2,15, 2,15); // bottomish
      // bottom right document
      g.drawLine(10,9,  13,9); // top
      g.drawLine(10,10, 10,14); // left
      g.drawLine(11,14, 12,14); // bottomish
      g.drawLine(12,15, 12,15); // bottomish

      // Draw the four DarkAccent4 dots - upper right of each document
      g.setColor(OrganicLookAndFeel.getDarkAccent4());
      g.drawLine( 4,1,  4,1); // top left document
      g.drawLine(14,1, 14,1); // top right document
      g.drawLine( 4,9,  4,9); // bottom left document
      g.drawLine(14,9, 14,9); // bottom right document

      // Draw the Black right/bottomish highlights for each document
      g.setColor(OrganicLookAndFeel.getBlack());
      g.drawLine( 4,2,  4,7); // top left document right edge
      g.drawLine( 3,7,  3,7); // top left document bottom dot
      g.drawLine(14,2, 14,7); // top right document right edge
      g.drawLine(13,7, 13,7); // top right document bottom dot
      g.drawLine( 4,10,  4,15); // bottom left document right edge
      g.drawLine( 3,15,  3,15); // bottom left document bottom dot
      g.drawLine(14,10, 14,15); // bottom right document right edge
      g.drawLine(13,15, 13,15); // bottom right document bottom dot
      // Draw the Black info line for each document
      g.drawLine( 6, 3,   8,3); // top left document
      g.drawLine(16, 3,  18,3); // top right document
      g.drawLine( 6,11,  8,11); // bottom left document
      g.drawLine(16,11, 18,11); // bottom right document

      // Draw the inner document DarkAccent1 dots/highlights
      g.setColor(OrganicLookAndFeel.getDarkAccent1());
      g.drawLine( 2,5,  2,5); // top left document
      g.drawLine( 3,6,  3,6);
      g.drawLine(12,5, 12,5); // top right document
      g.drawLine(13,6, 13,6);
      g.drawLine( 2,13,  2,13); // bottom left document
      g.drawLine( 3,14,  3,14);
      g.drawLine(12,13, 12,13); // bottom right document
      g.drawLine(13,14, 13,14);

      // Draw single Control3 highlight at bottom of document
      g.setColor(OrganicLookAndFeel.getControl3());
      g.drawLine( 1,7,  1,7); // top left document
      g.drawLine(11,7, 11,7); // top right document
      g.drawLine( 1,15,  1,15); // bottom left document
      g.drawLine(11,15, 11,15); // bottom right document

      g.translate(-x,-y);
    }
    public int getIconWidth() { return 19; }
    public int getIconHeight() { return 17; }
  };

}

