/*
 * @(#)OrganicGrayTheme.java	1.3 98/01/30
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.plaf.*;
import java.awt.Font;

/**
 * This describes the default "Gray" theme for the Organic Look and Feel.
 * It's commonly referred to as the "Vancouver" theme.
 *
 * @version 1.3 01/30/98
 * @author Steve Wilson
 */

public class OrganicGrayTheme extends OrganicTheme{

    private final static String name = "Vancouver";

    /*     Purple-ish colors */
    private final ColorUIResource Purple4 = new ColorUIResource(102, 102, 153);
    private final ColorUIResource Purple3 = new ColorUIResource(119, 111, 175);
    private final ColorUIResource Purple2 = new ColorUIResource(167, 167, 231);
    private final ColorUIResource Purple1 = new ColorUIResource(204, 204, 255);
    /*     Orange-ish colors */
    private final ColorUIResource Orange4 = new ColorUIResource(255, 127, 000);
    private final ColorUIResource Orange3 = new ColorUIResource(255, 151,  79);
    private final ColorUIResource Orange2 = new ColorUIResource(255, 204, 153);
    private final ColorUIResource Orange1 = new ColorUIResource(255, 255, 255);
    /*     Green-ish colors */
    private final ColorUIResource Green4  = new ColorUIResource(051, 102, 102);
    private final ColorUIResource Green3  = new ColorUIResource(051, 102, 102);
    private final ColorUIResource Green2  = new ColorUIResource(159, 215, 183);
    private final ColorUIResource Green1  = new ColorUIResource(207, 239, 199);
    /*     Gray-ish colors */
    private final ColorUIResource Gray4  = new ColorUIResource( 51,  51,  51);
    private final ColorUIResource Gray3  = new ColorUIResource(102, 102, 102);
    private final ColorUIResource Gray2  = new ColorUIResource(153, 153, 153);
    private final ColorUIResource Gray1  = new ColorUIResource(204, 204, 204);

    private final ColorUIResource white  = new ColorUIResource(255, 255, 255);
    private final ColorUIResource black  = new ColorUIResource(0, 0, 0);
    private final ColorUIResource desktop = new ColorUIResource(223, 223, 223);

    private final FontUIResource systemFont = new FontUIResource("Dialog", Font.PLAIN, 12);
    private final FontUIResource windowTitleFont = new FontUIResource("SansSerif", Font.BOLD, 12);
    private final FontUIResource userFont = new FontUIResource("SansSerif", Font.PLAIN, 12);

    public ColorUIResource getControl1() { return Gray1; }
    public ColorUIResource getControl2() { return Gray2; }
    public ColorUIResource getControl3() { return Gray3; }
    public ColorUIResource getControl4() { return Gray4; }

    public ColorUIResource getHighlight1() { return Green1; }
    public ColorUIResource getHighlight2() { return Green2; }
    public ColorUIResource getHighlight3() { return Green3; }
    public ColorUIResource getHighlight4() { return Green4; }

    public ColorUIResource getDarkAccent1()  { return Purple1; }
    public ColorUIResource getDarkAccent2()  { return Purple2; } 
    public ColorUIResource getDarkAccent3()  { return Purple3; }
    public ColorUIResource getDarkAccent4()  { return Purple4; }

    public ColorUIResource getLightAccent1()  { return Orange1; }
    public ColorUIResource getLightAccent2()  { return Orange2; }
    public ColorUIResource getLightAccent3()  { return Orange3; }
    public ColorUIResource getLightAccent4()  { return Orange4; }

    public ColorUIResource getWhite()  { return white; }
    public ColorUIResource getBlack() { return black; }

    public ColorUIResource getDesktopColor() { return desktop; }

    public String getName() {return name;}

    public FontUIResource getControlTextFont() { return systemFont;}
    public FontUIResource getUserTextFont() { return userFont;}
    public FontUIResource getMenuTextFont() { return systemFont;}
    public FontUIResource getEmphasisTextFont() { return windowTitleFont;}
}
