/*
 * @(#)OrganicFrameBorder.java	1.4 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */

package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;
import java.awt.*;

/**
 * Object capable of rendering a line border of arbitrary thickness
 * using four seperate colors.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.4 02/02/98
 * @author Michael C. Albers
 */
public class OrganicFrameBorder extends AbstractBorder {

  private          JInternalFrame jif = null;

  protected static int thickness = 2;
  protected static Color leftColor;
  protected static Color rightColor;
  protected static Color topColor;
  protected static Color bottomColor;
  protected static Color inactiveColor;
  
  
  public OrganicFrameBorder(Color lcolor, Color rcolor, 
			Color tcolor, Color bcolor, 
			Color iColor, int thickness)  {
    leftColor   = lcolor;
    rightColor  = rcolor;
    topColor    = tcolor;
    bottomColor = bcolor;
    inactiveColor = iColor;
    this.thickness = thickness;
  }

  public void paintBorder(Component c, Graphics g, int x, int y,
			  int width, int height) {
    Color oldColor = g.getColor();
    boolean isSelected = true;

    if (c instanceof JInternalFrame) {
      jif = (JInternalFrame)c;
      isSelected = jif.isSelected();
    }

    for(int i = 0; i < thickness; i++)  {
      // Draw top lines (upper left to upper right)
      if (isSelected) {
	g.setColor(topColor);
      } else {
	g.setColor(inactiveColor);
      }
      g.drawLine(x, y+i, x+width-thickness-1, y+i);
      // Draw right lines (upper right to lower right)
      if (isSelected) {
	g.setColor(rightColor);
      } else {
	g.setColor(inactiveColor);
      }
      g.drawLine(x+width-i-1, y, x+width-i-1, y+height-thickness-1);
      // Draw bottom lines (bottom left to botom right)
      if (isSelected) {
	g.setColor(bottomColor);
      } else {
	g.setColor(inactiveColor);
      }
      g.drawLine(x+thickness, y+height-i-1, x+width-1, y+height-i-1);
      // Draw left lines (upper left to lower left)
      if (isSelected) {
	g.setColor(leftColor);
      } else {
	g.setColor(inactiveColor);
      }
      g.drawLine(x+i, y+thickness, x+i, y+height-1);
    }
    g.setColor(oldColor);
  }
  
  // Private method used to determine which colors to use for the 
  //  multicolor or unicolor border depending on whether the window
  //  is selected or not.
  private void setBorderColors(boolean isSelected) {
    
  }

  /**
   * Returns the insets of the border.
   * @param c the component for which this border insets value applies
   */
  public Insets getBorderInsets(Component c) {
    return new Insets(thickness, thickness, thickness, thickness);
  }

  /**
   * Returns the top-edge color of the border.
   */
  public Color getTopColor()     {
    return topColor;
  }

  /**
   * Returns the bottom-edge color of the border.
   */
  public Color getBottomColor()     {
    return bottomColor;
  }

  /**
   * Returns the right-edge color of the border.
   */
  public Color getRightColor()     {
    return rightColor;
  }

  /**
   * Returns the left-edge color of the border.
   */
  public Color getLeftColor()     {
    return leftColor;
  }
  
  /**
   * Returns the thickness of the border.
   */
  public int getThickness()       {
    return thickness;
  }

  /**
   * Returns whether or not the border is opaque.
   */
  public boolean isBorderOpaque() { return true; }
}
