/*
 * @(#)OrganicDesktopPaneUI.java	1.5 98/02/05
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
  
package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.*;
import com.sun.java.swing.plaf.ComponentUI;
import java.awt.event.*;
import java.awt.Component;
import java.awt.Point;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Graphics;
import com.sun.java.swing.plaf.DesktopPaneUI;
import com.sun.java.swing.plaf.basic.BasicDesktopPaneUI;
import java.util.*;

/**
 * This class is in charge of display of the OrganicDesktop.  It creates a OrganicDesktopMenu
 * which it installs inside itself.  It then registers for MouseEvents.  When the
 * mouse enters the OrganicDesktopMenu it pops down a menu to display the iconized windows.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @see OrganicDesktopManager
 * @see OrganicDesktopMenu
 * @version 1.5 02/05/98
 * @author Steve Wilson
 */
public class OrganicDesktopPaneUI extends BasicDesktopPaneUI 
                              implements MouseListener, ActionListener, ContainerListener {

//    OrganicDesktopManager organicDesktopManager;
    OrganicDesktopMenu desktopMenu;
    boolean desktopMenuRemoved = false;

    /**
      * This fuction creates and returns a new OrganicDesktopPaneUI.
      * in the current implementation each JDesktopPane needs its own UI.
      * They cannot be shared.  BAD THINGS WOULD HAPPEN.
      */
    public static ComponentUI createUI(JComponent c) {
        return new OrganicDesktopPaneUI();
    }

    public OrganicDesktopPaneUI() {
        super();
    }

    /**
      * This fuction creates the OrganicDesktopManager.
      * It also causes all JDesktopIcons to be removed from the 
      * container and put into the desktop menu.
      * It also creates and installs the OrganicDesktopMenu.
      *
      */
    public void installUI(JComponent c)   {
        super.installUI(c);
	installDesktopMenu(c);
	installListeners(c);

    }

    /**
      * This replaces desktop icons back to the Desktop.
      * It also kills the DesktopMenu.
      *
      */    
    public void uninstallUI(JComponent c)   {
	uninstallListeners(c);
        replaceDesktopIcons();
	uninstallDesktopMenu(c);
        super.uninstallUI(c);
    }

    protected void installListeners(JComponent c) {
        desktopMenu.addMouseListener(this);
	desktop.addComponentListener(desktopMenu);
	desktop.addContainerListener(this);
    }

    protected void uninstallListeners(JComponent c) {
	desktopMenu.removeMouseListener(this);
	desktop.removeContainerListener(this);
	desktop.removeComponentListener(desktopMenu);
    }

    protected void installDesktopManager() {
	if(desktop.getDesktopManager() == null) {
	    desktopManager = new OrganicDesktopManager();
	    desktop.setDesktopManager(desktopManager);
	    ((OrganicDesktopManager)desktopManager).setTheDesktop(desktop);
	    ((OrganicDesktopManager)desktopManager).setDesktopUI(this);
	}
    }

    protected void installDesktopMenu(JComponent c){
        desktopMenu = new OrganicDesktopMenu(this);
	desktop.add(desktopMenu);
	desktopMenu.locateInParent(c);
	removeDesktopIcons();
	desktopMenu.change();
    }

    protected void uninstallDesktopMenu(JComponent c) {
	desktop.remove(desktopMenu);
    }


    public void paint(Graphics g, JComponent c) {
        if (desktopMenuRemoved) {
	    desktop.add(desktopMenu);
	    desktopMenu.locateInParent(desktop);
	    desktopMenuRemoved = false;
	}
    }			
    /**
      * This function removes any DesktopIcons from the desktop
      * and asks the DesktopManager to place them in the iconizedWindowList.
      * It is called by installUI.
      *
      */   
    protected void removeDesktopIcons() {
         Component[] framesAndIcons = desktop.getComponents();
	     for (int i = 0; i < framesAndIcons.length; i++) {
	         if ( framesAndIcons[i] instanceof JInternalFrame.JDesktopIcon ) {
		       ((OrganicDesktopManager)desktopManager).addToIconizedWindowList( (JInternalFrame.JDesktopIcon)framesAndIcons[i] );
		       desktop.remove(framesAndIcons[i]);
		 } // end if
	   }  // end for i
    }

    /**
      * This function removes InternalFrames from the IconizedWindowList
      * and places the DesktopIcons into the desktop.
      * It is called by uninstallUI.
      *
      */   
      protected void replaceDesktopIcons() {
          Vector iconizedWindowList = ((OrganicDesktopManager)desktopManager).getIconizedWindows();
	  Enumeration iter = iconizedWindowList.elements();
	  while (iter.hasMoreElements()) {
	      JInternalFrame frame = (JInternalFrame)iter.nextElement();
	      JInternalFrame.JDesktopIcon icon = frame.getDesktopIcon();
	      ((OrganicDesktopManager)desktopManager).replaceDesktopIcon( icon );
	  } // end while
    }

    /**
      * This is an implementation of a MouseListener function.
      * and asks the DesktopManager to place them in the iconizedWindowList.
      * It is called by installUI.
      *
      */   
    public void mouseEntered(MouseEvent e) {
	showSelectionMenu();
    }

     /** This function shows the popup menu which allows the user to select a window to deiconify.
       * It is called by mouseEntered.
       *
       */      
      protected void showSelectionMenu() {
	Vector iconizedWindows = getIconizedWindows();
	JPopupMenu menu = new JPopupMenu();
	JMenuItem item = null;
	Enumeration iter = iconizedWindows.elements();
	int windowNumber = 0;
	while (iter.hasMoreElements()) {  // put each iconized window into the PopupMenu
	    JInternalFrame window = (JInternalFrame)iter.nextElement();
	    item = new JMenuItem(window.getTitle(), window.getFrameIcon());
	    menu.add(item);
	    item.setActionCommand(String.valueOf(windowNumber));
	    item.addActionListener(this);
	    windowNumber++;
	}
	if (windowNumber != 0) {  // prevent showing empty menu.
	    java.awt.Point loc = desktopMenu.getPopupLocation(menu);
	    menu.show(desktopMenu, loc.x, loc.y);
	}
    }

    /** This function returns the list of all iconizedWindows.
      */
    public Vector getIconizedWindows() {
        return ((OrganicDesktopManager)desktopManager).getIconizedWindows();
    }

    /** This function is called each time a frame is iconified.
      * it is called by OrganicDesktopManager.
      * this notification is used to tell the DesktopMenu to update.
      */
    public void frameIconified() {
        desktopMenu.change();
    }

    /** This function is called each time a frame is deiconified.
      * it is called by OrganicDesktopManager.
      * this notification is used to tell the DesktopMenu to update.
      */
    public void frameDeiconified() {
        desktopMenu.change();
    }

    /** This is an implemention of ActionListener.
      * this function is called when the user selects an item from the menu
      * which is created in the showDesktopMenu
      */
    public void actionPerformed(ActionEvent e) {
        String selectedWindowNumberAsString = e.getActionCommand();
	int selectedWindowNumber = Integer.parseInt(selectedWindowNumberAsString);
	JInternalFrame frameToDeiconify = 
	        (JInternalFrame)((OrganicDesktopManager)desktopManager).getIconizedWindows().elementAt(selectedWindowNumber);
	((OrganicDesktopManager)desktopManager).deiconifyFrame(frameToDeiconify);
	((JComponent)e.getSource()).getParent().setVisible(false);
    }

    /*
     * If someone removes the desktop menu.  Put it back in!
     */
    public void componentRemoved(ContainerEvent e) {
        Component c = e.getChild();  // the removed component
	if ( c == desktopMenu ) {
	    desktopMenuRemoved = true;
	    desktop.repaint();
	}
    }
			
    public void mouseExited(MouseEvent e) {}  // stubbed for MouseListener

    public void mousePressed(MouseEvent e) {}// stubbed for MouseListener

    public void mouseReleased(MouseEvent e) {}// stubbed for MouseListener

    public void mouseClicked(MouseEvent e) {}// stubbed for MouseListener

    public void componentAdded(ContainerEvent e) {}// stubbed for ContainerListener

}
