/*
 * @(#)OrganicDesktopMenu.java	1.5 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
  
package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.*;
import java.awt.event.*;
import java.awt.Point;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Graphics;
import com.sun.java.swing.plaf.DesktopPaneUI;
import com.sun.java.swing.plaf.basic.BasicDesktopPaneUI;
import java.util.*;


/**
 * This class implements the little square in the top-right corner of the OrganicDesktopPane.
 * It doesn't have much behavior.  It is mostly in charge of display.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @see OrganicDesktopPaneUI
 * @see OrganicDesktopManager
 * @version 1.5 02/02/98
 * @author Steve Wilson
 */
public class OrganicDesktopMenu extends JComponent implements ComponentListener{
    static final int initWidth = 41;
    static final int initHeight = 6;
    static final int iconizedWindowHeight = 3;

    private int numberIconizedWindows;

    private OrganicDesktopPaneUI desktop;
  

    public OrganicDesktopMenu(OrganicDesktopPaneUI pane) {
        setSize (initWidth, initHeight);
	desktop = pane;
    }

    /**
      * this function moves the DesktopMenu to the correct location in it's parent
      * container.  In Organic this is the Top-Right corner of the window.
      */
    protected void locateInParent(JComponent parent) {
        setLocation(parent.getSize().width - (initWidth), 0 );

    }

    /**
      * This method changes the size of the Desktop menu to allow
      * each iconized window representation to fit within the bounds of the window
      * it is called by the change() method in this class.
      */
    protected void resizeForWindows() {
        numberIconizedWindows = desktop.getIconizedWindows().size();
        setSize(initWidth, initHeight + numberIconizedWindows * iconizedWindowHeight);
    }
       
    /**
      * This method is called to notify the desktop menu
      * that the number of iconized windows has changed.  When this
      * function is called it causes the desktop menu to update its
      * display to reflect the current state of the system.
      */
    public void change() {
        resizeForWindows();
	repaint();	
    }

    /**
      * this override from component displays the proper look 
      * of the desktop menu.
      */
    public void paint (Graphics g) {
        Dimension size = getSize();

        g.setColor(OrganicLookAndFeel.getLightAccent1()); 
        g.fillRect(0,0, size.width, size.height); // paint the background

        g.setColor(OrganicLookAndFeel.getWindowFrameRight());
        g.fillRect(1,1, 9, initHeight-2);  // paint the first square

        g.setColor(OrganicLookAndFeel.getWindowFrameBottom());
        g.fillRect(11,1, 9, initHeight-2);  // paint the second square

        g.setColor(OrganicLookAndFeel.getWindowFrameTop());
        g.fillRect(21,1, 9, initHeight-2);  // paint the third square

        g.setColor(OrganicLookAndFeel.getWindowFrameLeft());
        g.fillRect(31,1, 9, initHeight-2);  // paint the fourth square


	// paint each iconized window represenation
	for ( int bar = 0; bar < numberIconizedWindows; bar++) {
	    int h = initHeight+(iconizedWindowHeight*bar);
	    g.setColor(OrganicLookAndFeel.getControl1());
	    g.drawLine( 1, h-1, initWidth-2, h-1 );
	    g.setColor(OrganicLookAndFeel.getControl3());
	    g.fillRect( 1, h, initWidth-2, iconizedWindowHeight-1);
	}

     }
  
     /** 
       *gets the location (in this components coordinate system
       * which specifies where to display the popup menu
       */
     public Point getPopupLocation(JPopupMenu pop) {
        int popWidth = pop.getPreferredSize().width;
        int x = -popWidth + initWidth;
        return new Point ( x, initHeight );

     }

     /**
       * This implementation from ComponentListener is designed to
       * deal with the case that someone resizes the desktop.
       * If the desktop is resized then this is called back and we
       * can adjust the location of the desktop menu
       */
     public void componentResized(ComponentEvent e) {
         locateInParent((JComponent)this.getParent());
     }
  
     public void componentHidden(ComponentEvent e) {} // stubbed for ComponentListener

     public void componentShown(ComponentEvent e) {} // stubbed for ComponentListener

     public void componentMoved(ComponentEvent e) {} // stubbed for ComponentListener

}
