/*
 * @(#)OrganicDesktopManager.java	1.3 98/02/05
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */

package com.sun.java.swing.plaf.organic;

import java.awt.*;
import java.beans.*;
import com.sun.java.swing.*;
import java.util.*;

/** This is an extension of the DefaultDesktopManager. 
  * It helps implement the Organic desktop management scheme.  It is mostly concerned
  * with iconization and deiconization of internal frames
  *
  * @see DefaultDesktopManager
  * @see OrganicDesktopPaneUI
  * @see OrganicDesktopMenu
  * @version 1.3 02/05/98
  * @author Steve Wilson
  */
public class OrganicDesktopManager extends DefaultDesktopManager {

    Vector iconizedWindows = new Vector();
    Container theDesktop;
    OrganicDesktopPaneUI desktopUI;

    /** Removes the frame from it's parent and stores it for later use. 
      */
    public void iconifyFrame(JInternalFrame f) {

        theDesktop.remove(f);
        iconizedWindows.addElement(f);

        theDesktop.repaint(f.getX(), f.getY(), f.getWidth(), f.getHeight());
        try { f.setSelected(false); } catch (PropertyVetoException e2) { }
	desktopUI.frameIconified();
	
    }

    /** replaces the frame in  the parent and removed it from the iconizedWindowList
      */
    public void deiconifyFrame(JInternalFrame f) {

	iconizedWindows.removeElement(f);
	try  {f.setIcon(false);} catch (PropertyVetoException e2) { }
	theDesktop.add(f);
        try { f.setSelected(true); } catch (PropertyVetoException e2) { }
	desktopUI.frameDeiconified();

    }

    /** this function puts a DesktopIcon back into the frame
     * this function is used when switching from Organic to another Look & Feel
     * it is called by OrganicDesktopPaneUI.replaceDesktopIcons
     */
    protected void replaceDesktopIcon(JInternalFrame.JDesktopIcon icon) {
        Rectangle iconBounds = icon.getBounds();
	JInternalFrame f = icon.getInternalFrame();
	theDesktop.add(icon);
        if (iconBounds.equals( new Rectangle(0,0,0,0) )) {
	    Rectangle r = getBoundsForIconOf(f);
	    icon.setBounds(r.x, r.y, r.width, r.height);
	    setWasIcon(f, Boolean.TRUE);
	} // end if

    }

    /**
      * returns the list of iconized windows.
      * in Organic these windows will appear in the small menu in the top-right corner
      */
    public Vector getIconizedWindows() {
        return iconizedWindows;
    }
    
    /**
     * This function takes a JDesktopIcon and adds it to the list of iconized windows
     * it is called by OrganicDesktopPaneUI.removeDesktopIcons()
     */
    public void addToIconizedWindowList(JInternalFrame.JDesktopIcon icon) {
        iconizedWindows.addElement(icon.getInternalFrame());
    }

    /**
      * this function takes the Container which will contain the InternalFrames
      * this should usually be a JDesktopPane
      */
    public void setTheDesktop(Container c) {
        theDesktop = c;
    }  

    public void setDesktopUI(OrganicDesktopPaneUI ui) {
        desktopUI = ui;
    }  

    /**
      * this is an override of a function from BasicDesktopManager
      * it works around a bug in the current implementation
      * this may be removed later, but we might still want to keep our own
      * this function is called by OrganicDesktopManager.replaceIcon()
      */
    protected Rectangle getBoundsForIconOf(JInternalFrame f) {

        Dimension prefSize = f.getDesktopIcon().getPreferredSize();
        int x2, y2, w2, h2;

        w2 = prefSize.width;
        h2 = prefSize.height;
        x2 = 0;
        y2 = theDesktop.getSize().height - h2;

        return  new Rectangle(x2, y2, w2, h2);
    }

    public void deactivateFrame(JInternalFrame f) {
        f.repaint(); // this is inefficient.  should just redraw border?
    }

}

