/*
 * @(#)OrganicDefaultTheme.java	1.3 98/01/30
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.plaf.*;
import java.awt.Font;

/**
 * This describes the default "Khaki" theme for the Organic Look and Feel.
 * It's commonly referred to as the "Santa Fe" theme.
 *
 * @version 1.3 01/30/98
 * @author Steve Wilson
 */

public class OrganicDefaultTheme extends OrganicTheme{

    private final static String name = "Santa Fe";
    /* Define Organic Colors using the JOS palette*/

    /*   JOS color mapping */
    /*     Purple-ish colors */
    private final ColorUIResource josPurple4 = new ColorUIResource(103,  87, 167);
    private final ColorUIResource josPurple3 = new ColorUIResource(119, 111, 175);
    private final ColorUIResource josPurple2 = new ColorUIResource(167, 167, 231);
    private final ColorUIResource josPurple1 = new ColorUIResource(204, 204, 255);
    /*     Orange-ish colors */
    private final ColorUIResource josOrange4 = new ColorUIResource(255, 127, 000);
    private final ColorUIResource josOrange3 = new ColorUIResource(255, 151,  79);
    private final ColorUIResource josOrange2 = new ColorUIResource(255, 204, 153);
    private final ColorUIResource josOrange1 = new ColorUIResource(255, 255, 240);
    /*     Green-ish colors */
    private final ColorUIResource josGreen4  = new ColorUIResource(051, 102, 102);
    private final ColorUIResource josGreen3  = new ColorUIResource(119, 159, 127);
    private final ColorUIResource josGreen2  = new ColorUIResource(159, 215, 183);
    private final ColorUIResource josGreen1  = new ColorUIResource(207, 239, 199);
    /*     Brown-ish colors */
    private final ColorUIResource josKhaki4  = new ColorUIResource( 87,  87,  47);
    private final ColorUIResource josKhaki3  = new ColorUIResource(159, 151, 111);
    private final ColorUIResource josKhaki2  = new ColorUIResource(199, 183, 143);
    private final ColorUIResource josKhaki1  = new ColorUIResource(231, 215, 183);

    private final ColorUIResource white  = new ColorUIResource(255, 255, 255);
    private final ColorUIResource black  = new ColorUIResource(0, 0, 0);
    private final ColorUIResource desktop = new ColorUIResource(223, 223, 223);

    private final FontUIResource systemFont = new FontUIResource("Dialog", Font.PLAIN, 12);
    private final FontUIResource windowTitleFont = new FontUIResource("SansSerif", Font.BOLD, 12);
    private final FontUIResource userFont = new FontUIResource("SansSerif", Font.PLAIN, 12);

    public ColorUIResource getControl1() { return josKhaki1; }
    public ColorUIResource getControl2() { return josKhaki2; }
    public ColorUIResource getControl3() { return josKhaki3; }
    public ColorUIResource getControl4() { return josKhaki4; }

    public ColorUIResource getHighlight1() { return josGreen1; }
    public ColorUIResource getHighlight2() { return josGreen2; }
    public ColorUIResource getHighlight3() { return josGreen3; }
    public ColorUIResource getHighlight4() { return josGreen4; }

    public ColorUIResource getDarkAccent1()  { return josPurple1; }
    public ColorUIResource getDarkAccent2()  { return josPurple2; } 
    public ColorUIResource getDarkAccent3()  { return josPurple3; }
    public ColorUIResource getDarkAccent4()  { return josPurple4; }

    public ColorUIResource getLightAccent1()  { return josOrange1; }
    public ColorUIResource getLightAccent2()  { return josOrange2; }
    public ColorUIResource getLightAccent3()  { return josOrange3; }
    public ColorUIResource getLightAccent4()  { return josOrange4; }

    public ColorUIResource getWhite()  { return white; }
    public ColorUIResource getBlack() { return black; }

    public ColorUIResource getDesktopColor() { return desktop; }

    public String getName() {return name;}

    public FontUIResource getControlTextFont() { return systemFont;}
    public FontUIResource getUserTextFont() { return userFont;}
    public FontUIResource getMenuTextFont() { return systemFont;}
    public FontUIResource getEmphasisTextFont() { return windowTitleFont;}
}
