/*
 * @(#)OrganicComboBoxUI.java	1.6 98/04/10
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.metal.*;
import com.sun.java.swing.border.*;
import java.io.Serializable;
import com.sun.java.swing.plaf.basic.BasicComboBoxUI;


/**
 * Organic UI for JComboBox
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @see OrganicComboBoxListCellRenderer
 * @see OrganicPopupMenuBorder
 * @version 1.6 04/10/98
 * @author Tom Santos
 */
public class OrganicComboBoxUI extends MetalComboBoxUI  {
/*
    protected OrganicComboBoxButton button;
    protected JButton arrowCache;

    private static Border emptyBorder = new BorderUIResource (
					    new EmptyBorder(0,0,0,0));

    public static ComponentUI createUI(JComponent c) {
        return new OrganicComboBoxUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);

	editablePropertyChanged();
    }

    public void uninstallUI( JComponent c ) {
	if ( button != null ) {
	    comboBox.remove( button );
	    button = null;
	}

        super.uninstallUI( c );       
    }

    public void paint(Graphics g, JComponent c) {
    }

    protected JButton createArrowButton() {
	return new OrganicComboBoxButton( comboBox, new OrganicComboBoxIcon(), true );
    }

    public void layoutContainer(Container parent) {
        if ( comboBox.isEditable() ) {
	    super.layoutContainer( parent );
	}
	else {
	    if ( button != null ) {
	        button.setSize( comboBox.getSize().width, comboBox.getSize().height );
	    }
	}
    }

    public void editablePropertyChanged() {
        if ( comboBox.isEditable() ) {
	    if ( button != null ) {
	        comboBox.remove( button );
		button = null;
	    }

	    if ( arrowCache != null ) {
	        comboBox.add( arrowCache );
	    }

	    super.editablePropertyChanged();

	    comboBox.setBorder(emptyBorder);
	}
	else {
	    removeEditor();
	    if ( arrowButton != null ) {
	        comboBox.remove( arrowButton );
		arrowCache = arrowButton;
		arrowButton = null;
	    }

	    if ( button == null ) {
	        Insets insets = comboBox.getInsets();
	        button = new OrganicComboBoxButton( comboBox, new OrganicComboBoxIcon() );
		button.setLocation( 0, 0 );
		button.setSize( comboBox.getSize().width - 2,
				comboBox.getSize().height );
	    }
	    comboBox.add( button );
	}
    }

    protected void setupListBox(JList listBox, JComboBox comboBox) {
	listBox.setFont(comboBox.getFont());
        listBox.setForeground(UIManager.getColor("ComboBox.listForeground"));
        listBox.setBackground(UIManager.getColor("ComboBox.listBackground"));
        listBox.setSelectionForeground(UIManager.getColor("ComboBox.selectedForeground"));
        listBox.setSelectionBackground(UIManager.getColor("ComboBox.selectedBackground"));
    }

    public void focusGained(FocusEvent e) {
        super.focusGained( e );
	if ( button != null ) {
	    button.forceDrawFocus( true );
	    button.repaint();
	}
    }

    public void focusLost(FocusEvent e) {
        super.focusLost( e );
	if ( button != null ) {
	    button.forceDrawFocus( false );
	    button.repaint();
	}
    }

    public CellRendererPane getCurrentValuePane() {
        return currentValuePane;
    }

    public void addArrowButton() {
        arrowButton = createArrowButton();
        arrowButton.setRequestFocusEnabled(true);
        arrowButton.resetKeyboardActions();
        comboBox.add(arrowButton);
    }

    public void removeArrowButton() {
        if(arrowButton != null) {
            comboBox.remove(arrowButton);
            arrowButton = null;
        }
    }

    public void mouseReleased( MouseEvent anEvent ) {
        super.mouseReleased( anEvent );

	if ( anEvent.getSource() == listBox && button != null ) {
	    button.getModel().setPressed( false );
	}
	else if ( anEvent.getSource() == listBox && arrowButton != null ) {
	    arrowButton.getModel().setPressed( false );
	}
    }

    public void doMouseDragged( MouseEvent anEvent ) {
        if ( popupIsVisible() ) {
	    Window sourceWindow;
	    MouseEvent tmp = convertEventToListBox(anEvent);
	    updateListBoxSelectionForEvent(tmp,true);
	    lastMouseLocation = SwingUtilities.convertPoint((Component)anEvent.getSource(),anEvent.getPoint(),null);
	    sourceWindow = SwingUtilities.windowForComponent((Component)anEvent.getSource());
	    lastMouseLocation.x += sourceWindow.getBounds().x;
	    lastMouseLocation.y += sourceWindow.getBounds().y;
	    startAutoscrolling();        
	}
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension basicSize = super.getMaximumSize( c );
	
	if ( !comboBox.isEditable() ) {
	    basicSize.height += 4;
	}

        return basicSize;
    }


    public void doMouseReleased( MouseEvent anEvent ) {
        stopAutoscrolling();
	if ( popupIsVisible() ) {
	    Object sv;
	    MouseEvent tmp = convertEventToListBox(anEvent);
	    updateListBoxSelectionForEvent(tmp,true);
	    sv = listBox.getSelectedValue();
	    if(sv != null)
	        comboBox.getModel().setSelectedItem(sv);
	    hidePopup();
	}
    }

    public void enablePropertyChanged() {
        if ( button != null ) {
	    button.setEnabled( comboBox.isEnabled() );
	}
	if ( arrowCache != null ) {
	    arrowCache.setEnabled( comboBox.isEnabled() );
	}
	super.enablePropertyChanged();
    }
*/
}
