/*
 * @(#)OrganicComboBoxIcon.java	1.5 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.border.*;
import java.io.Serializable;
import com.sun.java.swing.plaf.basic.BasicComboBoxUI;
import java.io.*;


/**
 * This utility class draws the arrow which indicate a OrganicComboBox
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @see OrganicComboBoxUI
 * @version 1.5 02/02/98
 * @author Steve Wilson
 */
public class OrganicComboBoxIcon implements Icon, UIResource, Serializable {
     
    /**
     * Paints the horizontal bars for the 
     */
    public void paintIcon(Component c, Graphics g, int x, int y){
	int iconWidth = getIconWidth();

	g.translate( x, y );

	g.setColor( OrganicLookAndFeel.getBlack() );
	g.drawLine( 0, 0, iconWidth - 1, 0 );
	g.drawLine( 1, 1, 1 + (iconWidth - 3), 1 );
	g.drawLine( 2, 2, 2 + (iconWidth - 5), 2 );
	g.drawLine( 3, 3, 3 + (iconWidth - 7), 3 );
	g.drawLine( 4, 4, 4 + (iconWidth - 9), 4 );

	g.translate( -x, -y );
    }
    
    /**
     * stubbed to statify the interface.
     */
    public int getIconWidth() { return 10; }

    /**
     * stubbed to statify the interface.
     */
    public int getIconHeight()  { return 5; }

}
