/*
 * @(#)OrganicComboBoxButton.java	1.6 98/04/10
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.border.*;


/**
 * JButton subclass to help out OrganicComboBoxUI
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @see OrganicComboBoxButton
 * @version 1.6 04/10/98
 * @author Tom Santos
 */
public class OrganicComboBoxButton extends JButton {
/*
    protected JComboBox comboBox;
    protected Icon comboIcon;
    protected boolean iconOnly = false;
    protected boolean forceDrawFocus = false;

    public final JComboBox getComboBox() { return comboBox; }
    public final void setComboBox( JComboBox cb ) { comboBox = cb; }

    public final Icon getComboIcon() { return comboIcon; }
    public final void setComboIcon( Icon i ) { comboIcon = i; }

    static OrganicComboBoxButtonBorder comboBoxBorder = new OrganicComboBoxButtonBorder();

    OrganicComboBoxButton() {
        super( "" );
    }

    public OrganicComboBoxButton( JComboBox cb, Icon i ) {
	super( "" );

        comboBox = cb;
	comboIcon = i;
    }

    public OrganicComboBoxButton( JComboBox cb, Icon i, boolean onlyIcon ) {
        this( cb, i );
        iconOnly = onlyIcon;
    }

    public Insets getInsets() {
        return comboBox != null ? comboBox.getInsets() : new Insets( 0, 0, 0, 0 );
    }

    public void paint( Graphics g ) {
        // Paint the button as usual
        super.paint( g );

	Dimension size = getSize();
	Insets insets = getInsets();
	size.width -= insets.left + insets.right;
	size.height -= insets.top + insets.bottom;
	int iconLeft = insets.left + size.width;

	// Paint the icon
	if ( comboIcon != null ) {
	    int iconWidth = comboIcon.getIconWidth();
	    final int RIGHT_BUFFER = 8;

	    if ( iconOnly ) {
	        iconLeft = (insets.left + (size.width / 2)) - (iconWidth / 2);
	    }
	    else {
	        iconLeft -= iconWidth + RIGHT_BUFFER;
	    }

	    int iconHeight = comboIcon.getIconHeight();
	    int iconTop = (insets.top + (size.height / 2)) - (iconHeight / 2);

	    comboIcon.paintIcon( this, g, iconLeft, iconTop );
	}

	// Let the renderer paint
	if ( ! iconOnly && comboBox != null) {
	    OrganicComboBoxUI ui = (OrganicComboBoxUI)comboBox.getUI();
	    ListCellRenderer renderer = comboBox.getRenderer();
	    Component c;
	    ui.validateMenu();
	    boolean renderPressed = getModel().isPressed();
	    c = renderer.getListCellRendererComponent(ui.getList(),
						      comboBox.getSelectedItem(), -1, renderPressed, false);
	    c.setFont(ui.getCurrentValuePane().getFont());

            if (model.isArmed() && model.isPressed()) {
	        if (isOpaque()) {
		    c.setBackground(UIManager.getColor("Button.pressed"));
		}
	    } else {
		c.setBackground(comboBox.getBackground());
	    }
	    c.setForeground(comboBox.getForeground());

	    ui.getCurrentValuePane().paintComponent( g, c, this, insets.left+4, insets.top+4,
						     (iconLeft - 8) - insets.left,
						     insets.top + size.height - 8 );
	}

	if ( (isFocusPainted() && hasFocus()) || forceDrawFocus ) {
	    OrganicComboBoxButtonUI buttonUI = (OrganicComboBoxButtonUI)getUI();
	    buttonUI.paintFocus( g, insets.left+3, insets.top+3, size.width-7, size.height-7 );
	}
    }

    public void forceDrawFocus( boolean b ) {
        forceDrawFocus = b;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void requestFocus() { }

    public void updateUI() {
        setUI( new OrganicComboBoxButtonUI( this ) );
    }

    class OrganicComboBoxButtonUI extends OrganicButtonUI {
        OrganicComboBoxButtonListener newListener;

        public OrganicComboBoxButtonUI( OrganicComboBoxButton button ) {
	    newListener = new OrganicComboBoxButtonListener( button );
	}

        public void installUI( JComponent c ) {
	    super.installUI( c );
	    LookAndFeel.uninstallBorder(c);
	    c.setBorder( comboBoxBorder );

	    removeMouseListener( listener );
	    removeMouseMotionListener( listener );
	    addMouseListener( newListener );
	    addMouseMotionListener( (MouseMotionListener)newListener );
	}

        public void uninstallUI( JComponent c ) {
	    removeMouseListener( newListener );
	    removeMouseMotionListener( (MouseMotionListener)newListener );
	    super.uninstallUI( c );
	}
    }

    class OrganicComboBoxButtonListener extends BasicButtonListener {
        OrganicComboBoxButton button;
        boolean isDraggingProtection = false;

        public OrganicComboBoxButtonListener( OrganicComboBoxButton aButton ) {
	    super( aButton );
	    button = aButton;
	}

        public void mousePressed(MouseEvent anEvent) {
	    super.mousePressed( anEvent );

	    OrganicComboBoxUI ui = (OrganicComboBoxUI)button.getComboBox().getUI();

	    if ( isDraggingProtection ) {
	        return;
	    }
	    else {
	        isDraggingProtection = true;
	    }

	    if(!comboBox.isEnabled())
	        return;

	    if(!SwingUtilities.isLeftMouseButton(anEvent))
	        return;

	    if ( ui.popupIsVisible() ) {
	        ui.hidePopup();
	    }
	    else {
	        ui.showPopup();
	    }
	}
      
        public void mouseReleased(MouseEvent anEvent) {
	    isDraggingProtection = false;
	    OrganicComboBoxUI ui = (OrganicComboBoxUI)button.getComboBox().getUI();
	    if ( !(SwingUtilities.getLocalBounds(button).contains(anEvent.getPoint())) ) {
	        ui.doMouseReleased( anEvent );
	    }
	    super.mouseReleased( anEvent );
	}

        public void mouseDragged(MouseEvent anEvent) {
	    OrganicComboBoxUI ui = (OrganicComboBoxUI)button.getComboBox().getUI();
	    if ( !(SwingUtilities.getLocalBounds(button).contains(anEvent.getPoint())) ) {
	        ui.doMouseDragged( anEvent );
	    }
	}
    };
*/
}

//
// This class is here to disable the green "default" border that buttons normally have
//
class OrganicComboBoxButtonBorder extends OrganicButtonBorder {
    public OrganicComboBoxButtonBorder() {
        super();
    }

    protected int getDefaultBorderWidth() { return 0; }
}
