/*
 * @(#)OrganicCheckBoxIcon.java	1.6 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.*;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.plaf.*;
import java.io.*;

/**
 * CheckboxIcon implementation for OrganicCheckBoxUI
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.6 02/02/98
 * @author Steve Wilson
 */
public class OrganicCheckBoxIcon implements Icon, UIResource, Serializable {

    protected int getControlSize() { return 13; }

    protected Color getControlColor() { return OrganicLookAndFeel.getControl1(); }
    protected Color getAccentColor() { return OrganicLookAndFeel.getWhite(); }
    protected Color getShadowColor() { return OrganicLookAndFeel.getControl2(); }
    protected Color getDarkShadowColor() { return OrganicLookAndFeel.getControl3(); }
    protected Color getBlackColor() { return OrganicLookAndFeel.getBlack(); }

    /************************** The View *************************/


    public void paintIcon(Component c, Graphics g, int x, int y) {

        JCheckBox cb = (JCheckBox)c;
	ButtonModel model = cb.getModel();
	int controlSize = getControlSize();

	// Set up the colors for each area
	Color leftColor = getAccentColor();
	Color rightColor = getShadowColor();
	Color checkColor = getBlackColor();
      	Color frameColor = getControlColor();
       	Color fillColor = getControlColor();
       	boolean drawCheck = model.isSelected();
       	boolean drawCorners = !model.isEnabled();
	if ( !model.isEnabled() ) {
       	    leftColor = getShadowColor();
       	    rightColor = getShadowColor();
       	    checkColor = getDarkShadowColor();
       	}
       	else if ( !model.isSelected() && !model.isArmed() ) {
       	    leftColor = getAccentColor();
       	    rightColor = getDarkShadowColor();
       	}
       	else if ( model.isPressed() || model.isSelected() ) {
       	    leftColor = getDarkShadowColor();
       	    rightColor = getAccentColor();
       	}

       	// Background
       	if ( model.isPressed() && model.isArmed() ) {
       	    fillColor = getShadowColor();
       	}
       	else {
       	    fillColor = getControlColor();
       	}

       	g.setColor( frameColor );
       	g.fillRect( x-1, y-1, controlSize+2, controlSize+2 );
	g.setColor( fillColor );
       	g.fillRect( x, y, controlSize-1, controlSize-1 );

       	// left bevel
       	g.setColor( leftColor );
       	g.drawLine(x, y, x+(controlSize-2), y);
       	g.drawLine(x, y, x, y+(controlSize-2));
		
       	// right bevel
       	g.setColor( rightColor );
       	g.drawLine( x+(controlSize-1), y+1, x+(controlSize-1), y+(controlSize-1) );
       	g.drawLine( x+(controlSize-1), y+(controlSize-1), x+1, y+(controlSize-1) );
		
       	// Fill Corners
       	if ( drawCorners ) {
       	    g.setColor( leftColor );
       	    g.drawLine( x+(controlSize-1), y, x+(controlSize-1), y );
       	    g.drawLine( x, y+(controlSize-1), x, y+(controlSize-1) );
       	}
	// Check
       	g.setColor( checkColor );
       	if ( drawCheck ) {

		/*    g.fillRect( x+3, y+5, 2, 5 );
		    g.drawLine( x+9, y+3, x+5, y+7 );
		    g.drawLine( x+10, y+3, x+5, y+8 );*/
	    
	    drawCheck(c,g,x,y);
	}
    }

    protected void drawCheck(Component c, Graphics g, int x, int y) {
	int controlSize = getControlSize();
	g.fillRect( x+3, y+5, 2, controlSize-8 );
	g.drawLine( x+(controlSize-4), y+3, x+5, y+(controlSize-6) );
	g.drawLine( x+(controlSize-3), y+3, x+5, y+(controlSize-5) );
    }

    public int getIconWidth() {
        return getControlSize();
    }
       
    public int getIconHeight() {
        return getControlSize();
    }
 }
