/*
 * @(#)OrganicButtonUI.java	1.5 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.basic.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.plaf.*;

/**
 * OrganicButtonUI implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.5 02/02/98
 * @author Michael C. Albers
 * @author Tom Santos
 */
public class OrganicButtonUI extends BasicButtonUI {

  protected Color getSelectColor()       { return UIManager.getColor("Button.pressed"); }
  protected Color getDisabledColor()     { return UIManager.getColor("Button.disabled"); }
  protected Color getDisabledTextColor() { return UIManager.getColor("Button.disabledText"); }
  protected Color getFocusColor() { return UIManager.getColor("Button.focus"); }

  // We pass null here because nobody actually uses the component any more.
  protected OrganicButtonListener organicButtonListener = new OrganicButtonListener( null );

  private final static OrganicButtonUI organicButtonUI = new OrganicButtonUI(); 

  // visual constants
  private static final int defaultTextIconGap = 4;

 
  public static ComponentUI createUI(JComponent c) {
    return organicButtonUI;
  }
 

  protected BasicButtonListener createListener(JComponent c) {
    return organicButtonListener;
  }
  
  
  /**
   * ComponentUI implementation for OrganicButton
   *
   */
  public void paint(Graphics g, JComponent c) {
    AbstractButton b = (AbstractButton) c;
    ButtonModel model = b.getModel();
    
    Dimension size = b.getSize();
    FontMetrics fm = g.getFontMetrics();
    
    int shift_offset = 0;
    
    Insets i = getInsets(c);
    
    Rectangle viewRect = new Rectangle(size);
    
    viewRect.x += i.left;
    viewRect.y += i.top;
    viewRect.width -= (i.right + viewRect.x);
    viewRect.height -= (i.bottom + viewRect.y);
    
    Rectangle iconRect = new Rectangle();
    Rectangle textRect = new Rectangle();
    
    Font f = c.getFont();
    g.setFont(f);
    
    // layout the text and icon
    String text = SwingUtilities.layoutCompoundLabel(
	fm, b.getText(), b.getIcon(),
	b.getVerticalAlignment(), b.getHorizontalAlignment(),
	b.getVerticalTextPosition(), b.getHorizontalTextPosition(),
	viewRect, iconRect, textRect,
	b.getText() == null ? 0 : defaultTextIconGap);
    
    if (model.isArmed() && model.isPressed()) {
      // Note that in the Organic, things only offset to the left, that is, in X
      //  They do NOT offset up or down (in Y)
      shift_offset = 1;

      if (c.isOpaque()) {
	g.setColor( getSelectColor() );
	g.fillRect(1, 1, size.width-2, size.height-2);
      }
   }
    
    // Paint the Icon
    boolean isIcon = b.getIcon() != null;
    if(isIcon) { 
      Icon icon = null;
      if(!model.isEnabled()) {
	icon = (Icon) b.getDisabledIcon();
      } else if(model.isPressed() && model.isArmed()) {
	icon = (Icon) b.getPressedIcon();
	if(icon == null) {
	  // Use default icon
	  icon = (Icon) b.getIcon();
	}
      } else if(model.isRollover()) {
	icon = (Icon) b.getRolloverIcon();
      } 
      
      if (icon == null) {
	icon = (Icon) b.getIcon();
      }
      
	icon.paintIcon(c, g, iconRect.x - shift_offset, iconRect.y);
    }
    
    // Draw the Text
    if(text != null && !text.equals("")) {
      if(!model.isEnabled()) {
	// *** paint the text disabled
	g.setColor(getDisabledTextColor());
      } else {
	// *** paint the text normally
	g.setColor(c.getForeground());
      }
      g.drawString(text,
		   textRect.x - shift_offset,
		   textRect.y + fm.getAscent());
    }
    
    // draw the dashed focus line.
    if (b.isFocusPainted() && b.hasFocus()) {
      // Draw each dash of the line pixel by pixel.
      // The performance of this is surely poor -- Be sure
      // to rewrite when 2d graphics package is ready.
      Rectangle focusRect = new Rectangle();

      // If there is text
      if ( text != null & !text.equals( "" ) ) {
  	  if ( !isIcon ) {
	      focusRect.setBounds( textRect );
	  }
	  else {
	      focusRect.setBounds( iconRect.union( textRect ) );
	  }
      }
      // If there is an icon and no text
      else if ( isIcon ) {
	  focusRect.setBounds( iconRect );
      }

      paintFocus( g, (focusRect.x-1) - shift_offset, (focusRect.y-1),
		  focusRect.width+1, focusRect.height+1 );
    }
  }

  public void paintFocus( Graphics g, int x, int y, int w, int h ) {
      g.setColor(OrganicLookAndFeel.getLightAccent1());
      g.drawRect( x, y, w, h );
      g.setColor(getFocusColor());
      OrganicUtilities.drawDashedRect(g, x, y, w+1, h+1 );            
  }
  
  
  // I shouldn't need to redefine this.
  // REMIND(mca)
  public Insets getInsets(JComponent c) { 
    Border border = c.getBorder();
    Insets i = border != null? border.getBorderInsets(c) : new Insets(0,0,0,0);
    return i;
  }
  



  /**
   * Button margin.
   * <p>
   * Warning: serialized objects of this class will not be compatible with
   * future swing releases.  The current serialization support is appropriate
   * for short term storage or RMI between Swing1.0 applications.  It will
   * not be possible to load serialized Swing1.0 objects with future releases
   * of Swing.  The JDK1.2 release of Swing will be the compatibility
   * baseline for the serialized form of Swing objects.
   */
  public static class OrganicButtonMargin extends AbstractBorder {
    
    public Insets getBorderInsets(Component c)       {
      if (c instanceof AbstractButton) {
	AbstractButton b = (AbstractButton)c;
	return b.getMargin();
      }
      return new Insets(0, 0, 0, 0);
    }
  }
  
}

