/*
 * @(#)OrganicButtonBorder.java	1.4 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.basic.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.plaf.*;

/**
 * OrganicButtonBorder implementation
 *  This is the border that "normal" buttons use.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.4 02/02/98
 * @author Michael C. Albers
 * @author Tom Santos
 */
public class OrganicButtonBorder extends AbstractBorder {

  protected Color getTopLeftColor()            { return UIManager.getColor("Button.highlight"); }
  protected Color getBottomRightColor()        { return UIManager.getColor("Button.shadow"); }
  protected Color getPressedTopLeftColor()     { return UIManager.getColor("Button.shadow"); }
  protected Color getPressedBottomRightColor() { return UIManager.getColor("Button.highlight"); }
  protected Color getDisabledColor()           { return UIManager.getColor("Button.disabled"); }
  
  protected int getSafetyBorderWidth() { return 1; }
  protected int getDefaultBorderWidth() { return 1; }

  public void paintBorder(Component c, Graphics g, int x, int y, 
			  int w, int h) {
    Color downRight;
    Color upLeft;
    Color safetyB = UIManager.getColor("Button.background");
    Color defaultB = safetyB;
    Color dots = defaultB;
    boolean isPressed = false;
    boolean hasFocus = false;
    boolean isDisabled = false;
    boolean isDefault = false;
    boolean isArmed = false;
    
    if (c instanceof AbstractButton) {
      AbstractButton b = (AbstractButton)c;
      ButtonModel model = b.getModel();
      
      isPressed = (model.isPressed() && model.isArmed());
      hasFocus = (model.isArmed() && isPressed) || 
	          (b.isFocusPainted() && b.hasFocus());
      isDisabled = !model.isEnabled();
      isArmed = model.isArmed();
    }

    if ( !isDisabled && (hasFocus && !isPressed) ) {
	defaultB = UIManager.getColor("Button.focus");
    }

    // Set the colors
    if ( isDisabled ) {
        upLeft = getDisabledColor();
	downRight = getDisabledColor();
    }
    else if ( isPressed && isArmed ) {
        upLeft = getPressedTopLeftColor();
	downRight = getPressedBottomRightColor();
    }
    else {
        upLeft = getTopLeftColor();
	downRight = getBottomRightColor();
    }

    // DRAW
    //  For visual differentiation regardless of background
    int sB = getSafetyBorderWidth(); //sB = SafetyBorder for width of visual differentiation

    if ( sB > 0 ) {
      g.setColor(safetyB);
      g.drawLine(x,y, x+w-1,y); // UL -> UR
      g.drawLine(x,y, x,y+h-1); // UL -> BL
      g.drawLine(x+1,y+h-1, x+w-1,y+h-1); // BL -> BR
      g.drawLine(x+w-1,y, x+w-1,y+h-1); // UR -> BR
    }

    int dB = getDefaultBorderWidth(); //dB = DefaultBorder for width
    if ( dB > 0 ) {
      g.setColor(defaultB);
      g.drawLine(x+sB,y+sB, x+w-1-sB,y+sB); // UL -> UR
      g.drawLine(x+sB,y+sB, x+sB,y+h-1-sB); // UL -> BL
      g.drawLine(x+1+sB,y+h-1-sB, x+w-1-sB,y+h-1-sB); // BL -> BR
      g.drawLine(x+w-1-sB,y+sB, x+w-1-sB,y+h-1-sB); // UR -> BR
    }

    int tB = sB + dB; //tB is the total width of the borders
    g.setColor(upLeft); // top and left edge
    g.drawLine(x+tB,y+tB, x+w-tB-1,y+tB); // UL -> UR
    g.drawLine(x+tB,y+tB, x+tB,y+h-tB-1); // UL -> BL
    
    g.setColor(downRight); // bottom and right
    g.drawLine(x+tB,y+h-tB-1, x+w-tB-1,y+h-tB-1); // BL -> BR
    g.drawLine(x+w-tB-1,y+tB, x+w-tB-1,y+h-tB-1); // UR -> BR
    
    g.setColor(dots); // dots in corners
    g.drawLine(x+tB,y+h-tB-1, x+tB,y+h-tB-1);  // downLeft dot
    g.drawLine(x+w-tB-1,y+tB, x+w-tB-1,y+tB);  // upRight dot
  }
  
  public Insets getBorderInsets(Component c)       {
    return new Insets(3, 3, 3, 3);
  }
}

