/*
 * @(#)OrganicBigTheme.java	1.4 98/01/30
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.organic;

import com.sun.java.swing.plaf.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import java.io.*;
import java.awt.*;

/**
 * This describes an example "Low Vision" theme for the Organic Look and Feel.
 * It is commonly referred to as the "Dallas" theme.
 * Its main intent is to be an example of the power and flexibility
 *  of the theme's mechanism.
 * We encourage others to use this mechanism to develop a theme
 *  more applicable to people with vision problems.
 *
 * @version 1.4 01/30/98
 * @author Steve Wilson
 */

public class OrganicBigTheme extends OrganicGrayTheme{

    private final static String name = "Dallas";

    private final ColorUIResource control4  = new ColorUIResource( 51,  51,  51);
    private final ColorUIResource control3  = new ColorUIResource(102, 102, 102);
    private final ColorUIResource control2  = new ColorUIResource(153, 153, 153);
    private final ColorUIResource control1  = new ColorUIResource(255, 255, 255);

    private final ColorUIResource control1AndHalf  = new ColorUIResource(204, 204, 204);

    private final FontUIResource systemFont = new FontUIResource("Dialog", Font.PLAIN, 24);
    private final FontUIResource windowTitleFont = new FontUIResource("SansSerif", Font.BOLD, 24);
    private final FontUIResource userFont = new FontUIResource("SansSerif", Font.PLAIN, 24);

    public String getName() {return name;}

    public ColorUIResource getControl1() { return control1; }
    public ColorUIResource getControl2() { return control2; }
    public ColorUIResource getControl3() { return control3; }
    public ColorUIResource getControl4() { return control4; }

    public ColorUIResource getLightAccent1()  { return control2; }
    public ColorUIResource getWhite()  { return control2; }

    public ColorUIResource getWindowFrameTop() { return getControl3(); }   
    public ColorUIResource getWindowFrameBottom() { return getControl3(); }   
    public ColorUIResource getWindowFrameRight() { return getControl3(); }   
    public ColorUIResource getWindowFrameLeft() { return getControl3(); }   
    public ColorUIResource getWindowFrameInactive() { return getControl4(); }   

    public ColorUIResource getMenuForeground() { return  getBlack(); }
    public ColorUIResource getMenuSelectedForeground() { return  control1; }
    public ColorUIResource getMenuItemForeground() { return  getBlack(); }
    public ColorUIResource getMenuItemSelectedForeground() { return  control1; }
    public ColorUIResource getMenuSelectedBackground() { return getBlack(); }


    public ColorUIResource getWindowBackground() { return getControl1(); }
    public ColorUIResource getWindowTitleBackground() { return getBlack(); }  
    public ColorUIResource getWindowTitleInactiveBackground() { return getControl1(); }
    public ColorUIResource getWindowTitleForeground() { return getControl1(); }
    public ColorUIResource getWindowTitleInactiveForeground() { return getBlack(); }

    public ColorUIResource getTextHighlightColor() { return getBlack(); }
    public ColorUIResource getHighlightedTextColor() { return getControl1(); }

    public FontUIResource getControlTextFont() { return systemFont;}
    public FontUIResource getUserTextFont() { return userFont;}
    public FontUIResource getMenuTextFont() { return systemFont;}
    public FontUIResource getEmphasisTextFont() { return windowTitleFont;}


    public void addCustomEntriesToTable(UIDefaults table) {

	Object checkBoxIcon = new UIDefaults.LazyValue() {
	    public Object createValue(UIDefaults table) {
		return new OrganicBigCheckBoxIcon();
	    }
	};


        table.put ("CheckBox.icon", checkBoxIcon);
        table.put ("ScrollBar.width", new Integer ( 20 ) );
	table.put ("InternalFrameTitlePane.maximizeIcon", new MaximizeIcon() );
	table.put ("InternalFrameTitlePane.altMaximizeIcon", new MaximizeIcon() );
	table.put ("InternalFrameTitlePane.iconizeIcon", new IconizeIcon() );
	table.put ("InternalFrameTitlePane.closeIcon", new CloseIcon() );
        table.put ("TabbedPane.tabBackground", control1AndHalf );
        table.put ("ScrollBar.track", getControl1());
	table.put ("Tree.hash", getBlack());
    }
}

  // New icon for internal frame's maximize icon
  class MaximizeIcon implements Icon, Serializable {
    int height = 24;
    int width = 24;
    public void paintIcon(Component c, Graphics g, int x, int y) {
      g.setColor(OrganicLookAndFeel.getControl2());

      g.translate( x+4, y+4 );

      g.drawRect(0,0, 16,16);
      g.drawRect(1,1, 14,14);
      g.drawRect(2,2, 12,12);

      g.drawLine(2,3, 14,3);
      g.drawLine(2,4, 14,4);

      g.translate( -(x+4), -(y+4) );
    }
    public int getIconWidth() { return width; }
    public int getIconHeight() { return height; }
  };

  // New icon for internal frame's iconify icon
  class IconizeIcon implements Icon, Serializable {
    int height = 24;
    int width = 24;
    public void paintIcon(Component c, Graphics g, int x, int y) {
      g.setColor(OrganicLookAndFeel.getControl2());

      g.translate( x+4, y+4 );

      g.fillRect(0,8, 16, 4);


      g.translate( -(x+4), -(y+4) );
    }
    public int getIconWidth() { return width; }
    public int getIconHeight() { return height; }
  };

  // New icon for internal frame's close icon
  class CloseIcon implements Icon, Serializable {
    int height = 24;
    int width = 24;
    public void paintIcon(Component c, Graphics g, int x, int y) {
      Color old = g.getColor();
      g.setColor(OrganicLookAndFeel.getControl2());

      g.translate( x+4, y+4 );

      g.fillOval(0,0, 16,16);
      g.setColor(old);
      g.fillOval( 3,3, 10, 10);

      g.translate( -(x+4), -(y+4) );
    }
    public int getIconWidth() { return width; }
    public int getIconHeight() { return height; }
  };

  // New icon for checkbox to use
  class OrganicBigCheckBoxIcon extends OrganicCheckBoxIcon {

    protected int getControlSize() { return 20; }

    protected Color getAccentColor() { return OrganicLookAndFeel.getControl2(); }
    
    protected void drawCheck(Component c, Graphics g, int x, int y) {
	int controlSize = getControlSize();
	g.fillRect( x+3, y+6, 3, controlSize-9 );

	g.drawLine( x+(controlSize-4), y+3, x+5, y+(controlSize-6) );
	g.drawLine( x+(controlSize-3), y+3, x+5, y+(controlSize-5) );
	g.drawLine( x+(controlSize-5), y+3, x+5, y+(controlSize-7) );
    }

}
