/*
 * @(#)MultiTreeUI.java	1.17 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.multi;

import java.util.Vector;
import java.io.Serializable;
import com.sun.java.swing.*;
import java.awt.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.tree.*;

/**
 * MultiTreeUI implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.17 02/02/98
 * @author Willie Walker
 */
public class MultiTreeUI extends TreeUI
	implements Serializable {

    /**
     * The Vector containing the real UI's.  This is populated 
     * in the call to createUI, and can be obtained by calling
     * getUIs.  The first element is guaranteed to the real UI 
     * obtained from the default look and feel.
     */
    protected Vector uis = new Vector();

////////////////////
// Common UI methods
////////////////////

    public static ComponentUI createUI(JComponent c) {
        ComponentUI mui = new MultiTreeUI();
        return MultiLookAndFeel.createUIs(mui,
                                          ((MultiTreeUI) mui).uis,
                                          c);
    }

    /**
     * Return the list of UI's associated with this multiplexing UI.  This 
     * allows processing of the UI's by an application aware of multiplexing 
     * UI's on components.
     */
    public ComponentUI[] getUIs() {
        return MultiLookAndFeel.uisToArray(uis);
    }

//////////////////////
// ComponentUI methods
//////////////////////

    public void installUI(JComponent c) {
        for (int i = 0; i < uis.size(); i++) {
            ((ComponentUI) (uis.elementAt(i))).installUI(c);
        }
    }

    public void uninstallUI(JComponent c) {
        for (int i = 0; i < uis.size(); i++) {
            ((ComponentUI) (uis.elementAt(i))).uninstallUI(c);
        }
    }
  
    public void paint(Graphics g, JComponent c) {
        for (int i = 0; i < uis.size(); i++) {
            ((ComponentUI) (uis.elementAt(i))).paint(g,c);
        }
    }
      
    public void update(Graphics g, JComponent c) {
        for (int i = 0; i < uis.size(); i++) {
            ((ComponentUI) (uis.elementAt(i))).update(g,c);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        return ((ComponentUI) (uis.elementAt(0))).getPreferredSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return ((ComponentUI) (uis.elementAt(0))).getMinimumSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return ((ComponentUI) (uis.elementAt(0))).getMaximumSize(c);
    }

    public boolean contains(JComponent c, int x, int y) {
        return ((ComponentUI) (uis.elementAt(0))).contains(c,x,y);
    }

/////////////////
// TreeUI Methods
/////////////////

    public int getRowCount() {
        return ((TreeUI) (uis.elementAt(0))).getRowCount();
    }

    public boolean isExpanded(TreePath path) {
        return ((TreeUI) (uis.elementAt(0))).isExpanded(path);
    }

    public boolean isExpanded(int row) {
        return ((TreeUI) (uis.elementAt(0))).isExpanded(row);
    }

    public boolean isCollapsed(TreePath path) {
        return ((TreeUI) (uis.elementAt(0))).isCollapsed(path);
    }

    public boolean isCollapsed(int row) {
        return ((TreeUI) (uis.elementAt(0))).isCollapsed(row);
    }

    public void makeVisible(TreePath path) {
        for (int i = 0; i < uis.size(); i++) {
            ((TreeUI) (uis.elementAt(i))).makeVisible(path);
        }
    }
    
    public boolean isVisible(TreePath path) {
        return ((TreeUI) (uis.elementAt(0))).isVisible(path);
    }

    public Rectangle getPathBounds(TreePath path) {
        return ((TreeUI) (uis.elementAt(0))).getPathBounds(path);
    }

    public Rectangle getRowBounds(int row) {
        return ((TreeUI) (uis.elementAt(0))).getRowBounds(row);
    }

    public void scrollPathToVisible(TreePath path) {
        for (int i = 0; i < uis.size(); i++) {
            ((TreeUI) (uis.elementAt(i))).scrollPathToVisible(path);
        }
    }

    public void scrollRowToVisible(int row) {
        for (int i = 0; i < uis.size(); i++) {
            ((TreeUI) (uis.elementAt(i))).scrollRowToVisible(row);
        }
    }

    public TreePath getPathForRow(int row) {
        return ((TreeUI) (uis.elementAt(0))).getPathForRow(row);
    }

    public int getRowForPath(TreePath path) {
        return ((TreeUI) (uis.elementAt(0))).getRowForPath(path);
    }

    public void expandPath(TreePath path) {
        for (int i = 0; i < uis.size(); i++) {
            ((TreeUI) (uis.elementAt(i))).expandPath(path);
        }
    }

    public void expandRow(int row) {
        for (int i = 0; i < uis.size(); i++) {
            ((TreeUI) (uis.elementAt(i))).expandRow(row);
        }
    }

    public void collapsePath(TreePath path) {
        for (int i = 0; i < uis.size(); i++) {
            ((TreeUI) (uis.elementAt(i))).collapsePath(path);
        }
    }

    public void collapseRow(int row) {
        for (int i = 0; i < uis.size(); i++) {
            ((TreeUI) (uis.elementAt(i))).collapseRow(row);
        }
    }

    public TreePath getClosestPathForLocation(int x, int y) {
        return ((TreeUI) (uis.elementAt(0))).getClosestPathForLocation(x, y);
    }

    public int getClosestRowForLocation(int x, int y) {
        return ((TreeUI) (uis.elementAt(0))).getClosestRowForLocation(x, y);
    }

    public boolean isEditing() {
        return ((TreeUI) (uis.elementAt(0))).isEditing();
    }

    public boolean stopEditing() {
        return ((TreeUI) (uis.elementAt(0))).stopEditing();
    }

    public void startEditingAtPath(TreePath path) {
        for (int i = 0; i < uis.size(); i++) {
            ((TreeUI) (uis.elementAt(i))).startEditingAtPath(path);
        }
    }

    public TreePath getEditingPath() {
        return ((TreeUI) (uis.elementAt(0))).getEditingPath();
    }
}

