/*
 * @(#)MultiTextUI.java	1.18 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.multi;

import java.util.Vector;
import java.io.Serializable;
import com.sun.java.swing.*;
import com.sun.java.swing.text.*;
import java.awt.*;
import com.sun.java.swing.plaf.*;

/**
 * MultiTextUI implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.18 02/02/98
 * @author Willie Walker
 */
public class MultiTextUI extends TextUI 
	implements Serializable {

    /**
     * The Vector containing the real UI's.  This is populated 
     * in the call to createUI, and can be obtained by calling
     * getUIs.  The first element is guaranteed to the real UI 
     * obtained from the default look and feel.
     */
    protected Vector uis = new Vector();

////////////////////
// Common UI methods
////////////////////

    public static ComponentUI createUI(JComponent c) {
        ComponentUI mui = new MultiTextUI();
        return MultiLookAndFeel.createUIs(mui,
                                          ((MultiTextUI) mui).uis,
                                          c);
    }

    /**
     * Return the list of UI's associated with this multiplexing UI.  This 
     * allows processing of the UI's by an application aware of multiplexing 
     * UI's on components.
     */
    public ComponentUI[] getUIs() {
        return MultiLookAndFeel.uisToArray(uis);
    }

//////////////////////
// ComponentUI methods
//////////////////////

    public void installUI(JComponent c) {
        for (int i = 0; i < uis.size(); i++) {
            ((ComponentUI) (uis.elementAt(i))).installUI(c);
        }
    }

    public void uninstallUI(JComponent c) {
        for (int i = 0; i < uis.size(); i++) {
            ((ComponentUI) (uis.elementAt(i))).uninstallUI(c);
        }
    }
  
    public void paint(Graphics g, JComponent c) {
        for (int i = 0; i < uis.size(); i++) {
            ((ComponentUI) (uis.elementAt(i))).paint(g,c);
        }
    }
      
    public void update(Graphics g, JComponent c) {
        for (int i = 0; i < uis.size(); i++) {
            ((ComponentUI) (uis.elementAt(i))).update(g,c);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        return ((ComponentUI) (uis.elementAt(0))).getPreferredSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return ((ComponentUI) (uis.elementAt(0))).getMinimumSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return ((ComponentUI) (uis.elementAt(0))).getMaximumSize(c);
    }

    public boolean contains(JComponent c, int x, int y) {
        return ((ComponentUI) (uis.elementAt(0))).contains(c,x,y);
    }

/////////////////
// TextUI methods
/////////////////

    public Rectangle modelToView(int pos) throws BadLocationException {
        return ((TextUI) (uis.elementAt(0))).modelToView(pos);
    }

    public int viewToModel(Point p) {
        return ((TextUI) (uis.elementAt(0))).viewToModel(p);
    }

    public void damageRange(int p0, int p1) {
        for (int i = 0; i < uis.size(); i++) {
            ((TextUI) (uis.elementAt(i))).damageRange(p0, p1);
        }
    }

    public EditorKit getEditorKit() {
        return ((TextUI) (uis.elementAt(0))).getEditorKit();
    }

    public View getRootView() {
        return ((TextUI) (uis.elementAt(0))).getRootView();
    }

    public Insets getDefaultMargin() {
        return ((TextUI) (uis.elementAt(0))).getDefaultMargin();
    }

}
