/*
 * @(#)MultiLookAndFeel.java	1.17 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing.plaf.multi;

import java.util.Vector;
import java.io.Serializable;
import java.lang.reflect.Method;
import com.sun.java.swing.*;
import com.sun.java.swing.plaf.*;

/**
 * <p>A Multiplexing UI Look and Feel that allows more than one UI 
 * to be associated with a component at the same time. 
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.17 02/02/98
 * @author Willie Walker
 */
public class MultiLookAndFeel extends LookAndFeel 
	implements Serializable {

//////////////////////////////
// LookAndFeel methods
//////////////////////////////

    public String getName() {
        return "Multiplexing Look and Feel";
    }
    
    public String getID() {
	return "Multiplex";
    }

    public String getDescription() {
        return "Allows multiple UI instances per component instance";
    }

    public boolean isNativeLookAndFeel() {
	return false;
    }

    public boolean isSupportedLookAndFeel() {
	return true;
    }

    public UIDefaults getDefaults() {
	UIDefaults table = new UIDefaults();
	String packageName = "com.sun.java.swing.plaf.multi.Multi";
	Object[] uiDefaults = {
		   "ButtonUI", packageName + "ButtonUI",
	 "CheckBoxMenuItemUI", packageName + "CheckBoxMenuItemUI",
		 "CheckBoxUI", packageName + "ToggleButtonUI",
             "ColorChooserUI", packageName + "ColorChooserUI",
		 "ComboBoxUI", packageName + "ComboBoxUI",
	      "DesktopIconUI", packageName + "DesktopIconUI",
	      "DesktopPaneUI", packageName + "DesktopPaneUI",
            "DirectoryPaneUI", packageName + "DirectoryPaneUI",
               "EditorPaneUI", packageName + "TextUI",
              "FileChooserUI", packageName + "FileChooserUI",
	    "InternalFrameUI", packageName + "InternalFrameUI",
		    "LabelUI", packageName + "LabelUI",
		     "ListUI", packageName + "ListUI",
		  "MenuBarUI", packageName + "MenuBarUI",
		 "MenuItemUI", packageName + "MenuItemUI",
		     "MenuUI", packageName + "MenuUI",
	       "OptionPaneUI", packageName + "OptionPaneUI",
	    "PasswordFieldUI", packageName + "TextUI",
		"PopupMenuUI", packageName + "PopupMenuUI",
	      "ProgressBarUI", packageName + "ProgressBarUI",
      "RadioButtonMenuItemUI", packageName + "RadioButtonMenuItemUI",
	      "RadioButtonUI", packageName + "ToggleButtonUI",
		"ScrollBarUI", packageName + "ScrollBarUI",
	       "ScrollPaneUI", packageName + "ScrollPaneUI",
		"SeparatorUI", packageName + "SeparatorUI",
		   "SliderUI", packageName + "SliderUI",
		  "SpinnerUI", packageName + "SpinnerUI",
		"SplitPaneUI", packageName + "SplitPaneUI",
	       "TabbedPaneUI", packageName + "TabbedPaneUI",
	      "TableHeaderUI", packageName + "TableHeaderUI",
		    "TableUI", packageName + "TableUI",
		 "TextAreaUI", packageName + "TextUI",
		"TextFieldUI", packageName + "TextUI",
		 "TextPaneUI", packageName + "TextUI",
	     "ToggleButtonUI", packageName + "ToggleButtonUI",
		  "ToolBarUI", packageName + "ToolBarUI",
		  "ToolTipUI", packageName + "ToolTipUI",
		     "TreeUI", packageName + "TreeUI",
	};

	table.putDefaults(uiDefaults);
	return table;
    }

///////////////////////////////
// Utility methods for the UI's
///////////////////////////////

    /**
     * Create the real UI's from the default and auxiliary look and feels,
     * placing the results in the uis vector passed in.  
     * @return the ComponentUI for the component.
     */
    public static ComponentUI createUIs(ComponentUI mui,
				        Vector      uis,
			                JComponent  target) {
        ComponentUI ui;

        // Make sure we can at least get the default UI
        //
        ui = UIManager.getDefaults().getUI(target);
        if (ui != null) {
            uis.addElement(ui);
            LookAndFeel[] auxiliaryLookAndFeels;
	    auxiliaryLookAndFeels = UIManager.getAuxiliaryLookAndFeels();
            if (auxiliaryLookAndFeels != null) {
                for (int i = 0; i < auxiliaryLookAndFeels.length; i++) {
                    ui = auxiliaryLookAndFeels[i].getDefaults().getUI(target);
                    if (ui != null) {
                        uis.addElement(ui);
                    }
                }
	    }
        } else {
	    return null;
	}

        // Don't bother returning the multiplexing UI if all we did was
        // get a UI from just the default look and feel.
        //
	if (uis.size() == 1) {
	    return (ComponentUI) uis.elementAt(0);
	} else {
	    return mui;
	}
    }

    /**
     * Turn the Vector of UI's into an array.
     */
    protected static ComponentUI[] uisToArray(Vector uis) {
        if (uis == null) {
            return new ComponentUI[0];
        } else {
            int count = uis.size();
            if (count > 0) {
                ComponentUI[] u = new ComponentUI[count];
                for (int i = 0; i < count; i++) {
                    u[i] = (ComponentUI)uis.elementAt(i);
                }
                return u;
            } else {
                return null;
            }
        }
    }
}
