/*
 * @(#)MotifTreeUI.java	1.11 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.motif;

import java.awt.*;
import java.awt.event.*;

import java.io.*;
import java.util.*;

import com.sun.java.swing.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.tree.*;
import com.sun.java.swing.plaf.basic.*;

/**
 * Motif rendition of the tree component.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.11 02/02/98
 * @author Jeff Dinkins
 */
public class MotifTreeUI extends BasicTreeUI
{
    static final int HALF_SIZE = 7;
    static final int SIZE = 14;
    static final int ROW_HEIGHT = 18;

    /**
     * creates a UI object to represent a Motif Tree widget
     */
    public MotifTreeUI() {
	super();
    }

    public void installUI(JComponent c) {
	super.installUI(c);
	setRowHeight(ROW_HEIGHT);
    }

    // BasicTreeUI overrides
  
    protected void drawVerticalLine( Graphics g, JComponent c, int x, int top, int bottom )
      {
	g.fillRect( x - 1, top, 2, bottom - top );
      }

    protected void drawHorizontalLine( Graphics g, JComponent c, int y, int left, int right )
      {
	g.fillRect( left - 1, y, right - left, 2 );
      }


    /**
     * The minus sign button icon.
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    public static class MotifExpandedIcon implements Icon, Serializable {
	static Color bg;
	static Color fg;
	static Color highlight;
	static Color shadow;

	public MotifExpandedIcon() {
	    bg = UIManager.getColor("Tree.iconBackground");
	    fg = UIManager.getColor("Tree.iconForeground");
	    highlight = UIManager.getColor("Tree.iconHighlight");
	    shadow = UIManager.getColor("Tree.iconShadow");
	}

        public static Icon createExpandedIcon() {
	    return new MotifExpandedIcon();
        }

	public void paintIcon(Component c, Graphics g, int x, int y) {
	    g.setColor(highlight);
	    g.drawLine(x, y, x+SIZE-1, y);
	    g.drawLine(x, y+1, x, y+SIZE-1);

	    g.setColor(shadow);
	    g.drawLine(x+SIZE-1, y+1, x+SIZE-1, y+SIZE-1);
	    g.drawLine(x+1, y+SIZE-1, x+SIZE-1, y+SIZE-1);

	    g.setColor(bg);
	    g.fillRect(x+1, y+1, SIZE-2, SIZE-2);

	    g.setColor(fg);
	    g.drawLine(x+3, y+HALF_SIZE-1, x+SIZE-4, y+HALF_SIZE-1);
	    g.drawLine(x+3, y+HALF_SIZE, x+SIZE-4, y+HALF_SIZE);
	}

	public int getIconWidth() { return SIZE; }
	public int getIconHeight() { return SIZE; }
    }

    /**
     * The plus sign button icon.
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    public static class MotifCollapsedIcon extends MotifExpandedIcon {
        public static Icon createCollapsedIcon() {
	    return new MotifCollapsedIcon();
        }

	public void paintIcon(Component c, Graphics g, int x, int y) {
	    super.paintIcon(c, g, x, y);
	    g.drawLine(x + HALF_SIZE-1, y + 3, x + HALF_SIZE-1, y + (SIZE - 4));
	    g.drawLine(x + HALF_SIZE, y + 3, x + HALF_SIZE, y + (SIZE - 4));
	}
    }
    
    public static ComponentUI createUI(JComponent x) {
	return new MotifTreeUI();
    }

    /**
     * Returns the default cell renderer that is used to do the
     * stamping of each node.
     */
    public TreeCellRenderer getDefaultCellRenderer() {
	return new MotifTreeCellRenderer();
    }

}
