/*
 * @(#)MotifTreeCellRenderer.java	1.5 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.tree.*;
import com.sun.java.swing.plaf.basic.BasicTreeCellRenderer;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.util.*;

/**
 * Motif rendered to display a tree cell.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.5 02/02/98
 * @author Jeff Dinkins
 */
public class MotifTreeCellRenderer extends BasicTreeCellRenderer
{
    static final int LEAF_SIZE = 13;
    static final Icon LEAF_ICON = new IconUIResource(new TreeLeafIcon());

    public MotifTreeCellRenderer() {
	super();
    }

    public static Icon loadLeafIcon() {
	return LEAF_ICON;
    }

    /**
     * Icon for a node with no children.
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    public static class TreeLeafIcon implements Icon, Serializable {

	Color bg;
	Color shadow;
	Color highlight;

	public TreeLeafIcon() {
	    bg = UIManager.getColor("Tree.iconBackground");
	    shadow = UIManager.getColor("Tree.iconShadow");
	    highlight = UIManager.getColor("Tree.iconHighlight");
	}

	public void paintIcon(Component c, Graphics g, int x, int y) {
	    g.setColor(bg);
	    g.fillRect(4, 7, 5, 5);

	    g.drawLine(6, 6, 6, 6);
	    g.drawLine(3, 9, 3, 9);
	    g.drawLine(6, 12, 6, 12);
	    g.drawLine(9, 9, 9, 9);

	    g.setColor(highlight);
	    g.drawLine(2, 9, 5, 6);
	    g.drawLine(3, 10, 5, 12);

	    g.setColor(shadow);
	    g.drawLine(6, 13, 10, 9);
	    g.drawLine(9, 8, 7, 6);
	    
	}
	
	public int getIconWidth() {
	    return LEAF_SIZE;
	}
	
	public int getIconHeight() {
	    return LEAF_SIZE;
	}
	
    }
}
