/*
 * @(#)MotifToggleButtonUI.java	1.8 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.motif;

import java.awt.*;
import java.awt.event.*;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.*;


/**
 * BasicToggleButton implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.8 04/13/98
 * @author Rich Schiavi
 */
public class MotifToggleButtonUI extends BasicToggleButtonUI 
{
  private   final static  MotifToggleButtonUI motifToggleButtonUI = new MotifToggleButtonUI();
  protected final static  Insets defaultMargin = new Insets(2,4,2,4);

  public static ComponentUI createUI(JComponent b) 
    {
      return motifToggleButtonUI;
    }

    protected void paintFocus(Graphics g, AbstractButton b,
			      Rectangle viewRect, Rectangle textRect, Rectangle iconRect){
    }

  protected void paintButtonPressed(Graphics g, AbstractButton b){
    Color oldColor = g.getColor();
    Dimension size = b.getSize();
      // paint the button in
    g.setColor(UIManager.getColor("ToggleButton.pressed"));
    g.fillRect(2,2,size.width-5,size.height-5);
    g.setColor(oldColor);
  }

  public Insets getInsets(JComponent c) 
    { 
      Border border = c.getBorder();
      Insets i = border != null? border.getBorderInsets(c) : new Insets(0,0,0,0);
      return i;
    }

  public Insets getDefaultMargin(AbstractButton b)
    {
      return defaultMargin;
    }

} // end class


