/*
 * @(#)MotifTabbedPaneUI.java	1.36 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */

package com.sun.java.swing.plaf.motif;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.BasicTabbedPaneUI;
import java.io.Serializable; 

/**
 * A Motif L&F implementation of TabbedPaneUI.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.36 02/02/98
 * @author Dave Moore
 * @author Philip Milne
 * @author Amy Fowler
 */
public class MotifTabbedPaneUI extends BasicTabbedPaneUI
{

// Class variables

    protected static int spacingHeight = 1;
    protected static int spacingWidth = 3;
    protected static int selectedTabHeightPad = 4;
    protected static int selectedTabWidthPad = 0;
    protected static Insets mContentBorderInsets = new Insets(2,2,2,2);
    protected static Insets mTabsOnTopTabAreaInsets = new Insets(4,2,0,8);
    protected static Insets mTabsOnLeftTabAreaInsets = new Insets(2,4,8,0);
    protected static Insets mTabsOnBottomTabAreaInsets = new Insets(0,2,4,8);
    protected static Insets mTabsOnRightTabAreaInsets = new Insets(2,0,8,4);

// Instance variables

    protected Color unselectedTabBackground;
    protected Color unselectedTabForeground;
    protected Color unselectedTabShadow;
    protected Color unselectedTabHighlight;


// UI creation

    public static ComponentUI createUI(JComponent tabbedPane) {
        return new MotifTabbedPaneUI();
    }


// UI Installation/De-installation

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setLayout(this);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    protected void installDefaults(JComponent c) {
        LookAndFeel.installColorsAndFont(c, "TabbedPane.tabBackground",
                                    "TabbedPane.tabForeground", "TabbedPane.font");  
        tabShadow = UIManager.getColor("TabbedPane.tabShadow");
        tabDarkShadow = tabShadow;
        tabHighlight = UIManager.getColor("TabbedPane.tabHighlight");

        unselectedTabBackground = UIManager.getColor("TabbedPane.unselectedTabBackground");
        unselectedTabForeground = UIManager.getColor("TabbedPane.unselectedTabForeground");
        unselectedTabShadow = UIManager.getColor("TabbedPane.unselectedTabShadow");
        unselectedTabHighlight = UIManager.getColor("TabbedPane.unselectedTabHighlight");
        focus = UIManager.getColor("TabbedPane.focus");
    }

// UI Rendering

   protected void paintContentBorderTopEdge(Graphics g, int tabPlacement,
                                            int selectedIndex, 
                                            int x, int y, int w, int h) {

        g.setColor(tabHighlight);
        if (tabPlacement != TOP || selectedIndex < 0) {
            g.drawLine(x, y, x+w-2, y);
        } else {
            Rectangle selRect = rects[selectedIndex];

            g.drawLine(x, y, selRect.x - 1, y);
            if (selRect.x + selRect.width < x + w - 2) {
                g.drawLine(selRect.x + selRect.width, y, 
                           x+w-2, y);
            } 
        }
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement,
                                               int selectedIndex,
                                               int x, int y, int w, int h) { 
        g.setColor(tabShadow);
        if (tabPlacement != BOTTOM || selectedIndex < 0) {
            g.drawLine(x+1, y+h-1, x+w-1, y+h-1);
        } else {
            Rectangle selRect = rects[selectedIndex];

            g.drawLine(x+1, y+h-1, selRect.x - 1, y+h-1);
            if (selRect.x + selRect.width < x + w - 2) {
                g.drawLine(selRect.x + selRect.width, y+h-1, x+w-2, y+h-1);
            } 
        }
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement,
                                               int selectedIndex,
                                               int x, int y, int w, int h) { 

        g.setColor(tabShadow);
        if (tabPlacement != RIGHT || selectedIndex < 0) {
            g.drawLine(x+w-1, y+1, x+w-1, y+h-1);
        } else {
            Rectangle selRect = rects[selectedIndex];

            g.drawLine(x+w-1, y+1, x+w-1, selRect.y - 1);

            if (selRect.y + selRect.height < y + h - 2 ) {
                g.drawLine(x+w-1, selRect.y + selRect.height, 
                           x+w-1, y+h-2);
            } 
        }
    }

    protected void paintTabBackground(Graphics g, JTabbedPane pane, 
                                      int tabPlacement, int tabIndex,
                                      int x, int y, int w, int h,
		 		      boolean isSelected ) {
        g.setColor(isSelected? pane.getBackgroundAt(tabIndex) : unselectedTabBackground);
        switch(tabPlacement) {
          case LEFT:
              g.fillRect(x+1, y+1, w-1, h-2);
              break;
          case RIGHT:
              g.fillRect(x, y+1, w-1, h-2);
              break;
          case BOTTOM:
              g.fillRect(x+1, y, w-2, h-3);
              g.drawLine(x+2, y+h-3, x+w-3, y+h-3);
              g.drawLine(x+3, y+h-2, x+w-4, y+h-2);
              break;
          case TOP:
          default:
              g.fillRect(x+1, y+3, w-2, h-3);
              g.drawLine(x+2, y+2, x+w-3, y+2);
              g.drawLine(x+3, y+1, x+w-4, y+1);
        }

    }

    protected void paintTabBorder(Graphics g, JTabbedPane pane, 
                                  int tabPlacement, int tabIndex,
                                  int x, int y, int w, int h,
				  boolean isSelected) { 
        g.setColor(isSelected? tabHighlight : unselectedTabHighlight);

        switch(tabPlacement) {
          case LEFT:
              g.drawLine(x, y+2, x, y+h-3);
              g.drawLine(x+1, y+1, x+1, y+2);
              g.drawLine(x+2, y, x+2, y+1);
              g.drawLine(x+3, y, x+w-1, y);
              g.setColor(isSelected? tabShadow : unselectedTabShadow);
              g.drawLine(x+1, y+h-3, x+1, y+h-2);
              g.drawLine(x+2, y+h-2, x+2, y+h-1);
              g.drawLine(x+3, y+h-1, x+w-1, y+h-1);
              break;
          case RIGHT:
              g.drawLine(x, y, x+w-3, y);
              g.setColor(isSelected? tabShadow : unselectedTabShadow);
              g.drawLine(x+w-3, y, x+w-3, y+1);
              g.drawLine(x+w-2, y+1, x+w-2, y+2);
              g.drawLine(x+w-1, y+2, x+w-1, y+h-3);
              g.drawLine(x+w-2, y+h-3, x+w-2, y+h-2);
              g.drawLine(x+w-3, y+h-2, x+w-3, y+h-1);
              g.drawLine(x, y+h-1, x+w-3, y+h-1);
              break;
          case BOTTOM:
              g.drawLine(x, y, x, y+h-3);
              g.drawLine(x+1, y+h-3, x+1, y+h-2);
              g.drawLine(x+2, y+h-2, x+2, y+h-1);
              g.setColor(isSelected? tabShadow : unselectedTabShadow);
              g.drawLine(x+3, y+h-1, x+w-4, y+h-1);
              g.drawLine(x+w-3, y+h-2, x+w-3, y+h-1);
              g.drawLine(x+w-2, y+h-3, x+w-2, y+h-2);
              g.drawLine(x+w-1, y, x+w-1, y+h-3);
              break;
          case TOP:
          default:
              g.drawLine(x, y+2, x, y+h-1);
              g.drawLine(x+1, y+1, x+1, y+2);
              g.drawLine(x+2, y, x+2, y+1);
              g.drawLine(x+3, y, x+w-4, y);
              g.setColor(isSelected? tabShadow : unselectedTabShadow);
              g.drawLine(x+w-3, y, x+w-3, y+1);
              g.drawLine(x+w-2, y+1, x+w-2, y+2);
              g.drawLine(x+w-1, y+2, x+w-1, y+h-1);
        }

    }

    protected void paintFocusIndicator(Graphics g, JTabbedPane pane, int tabPlacement,
                                       Rectangle[] rects, int tabIndex, 
                                       Rectangle iconRect, Rectangle textRect,
                                       boolean isSelected) {
        Rectangle tabRect = rects[tabIndex];
        if (pane.hasFocus() && isSelected) {
            int x, y, w, h;
	    g.setColor(focus);
            switch(tabPlacement) {
              case LEFT:
                  x = tabRect.x + 3;
                  y = tabRect.y + 3;
                  w = tabRect.width - 6;
                  h = tabRect.height - 7;
                  break;
              case RIGHT:
                  x = tabRect.x + 2;
                  y = tabRect.y + 3;
                  w = tabRect.width - 6;
                  h = tabRect.height - 7;
                  break;
              case BOTTOM:
                  x = tabRect.x + 3;
                  y = tabRect.y + 2;
                  w = tabRect.width - 7;
                  h = tabRect.height - 6;
                  break;
              case TOP:
              default:
                  x = tabRect.x + 3;
                  y = tabRect.y + 3;
                  w = tabRect.width - 7;
                  h = tabRect.height - 6;
            }
            g.drawRect(x, y, w, h);
        }
    }

    protected void calculateLayoutInfo(JTabbedPane pane) {
        int tabPlacement = pane.getTabPlacement();
        Font paneFont = pane.getFont(); 
        Font font = new Font(paneFont.getName(), 
                             paneFont.getStyle() | Font.BOLD, 
                             paneFont.getSize());         
        int tabCount = pane.getTabCount();
        int selectedIndex = pane.getSelectedIndex();
        
        assureRectsCreated(tabCount);
 
        arrangeTabs(pane, tabPlacement, tabCount, font); 

	padSelectedTab(pane, tabPlacement, selectedIndex);
    }

    protected int getRunIndent(JTabbedPane pane, int tabPlacement, int run) {
        return run*3;
    }

    protected int getTabOverlay(JTabbedPane pane, int tabPlacement) {
        overlay = (tabPlacement == LEFT || tabPlacement == RIGHT)?
            (int)Math.round((float)maxTabWidth * .10) :
            (int)Math.round((float)maxTabHeight * .22);
        return overlay;
    }
        
    protected Insets getTabAreaInsets(JTabbedPane pane, int tabPlacement) {
        Insets insets;
        switch(tabPlacement) {
          case LEFT:
              insets = mTabsOnLeftTabAreaInsets;
              break;
          case BOTTOM:
              insets = mTabsOnBottomTabAreaInsets;
              break;
          case RIGHT:
              insets = mTabsOnRightTabAreaInsets;
              break;
          case TOP:
          default:
              insets = mTabsOnTopTabAreaInsets;
        }
        return insets;
    }

    protected Insets getContentBorderInsets(JTabbedPane pane, int tabPlacement) {
        return mContentBorderInsets;
    }
       
}
