/*
 * @(#)MotifSliderUI.java	1.11 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.motif;

import java.awt.*;

import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.plaf.*;

import com.sun.java.swing.plaf.basic.BasicSliderUI;

/**
 * Motif Slider
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.11 02/02/98
 * @author Jeff Dinkins
 */
public class MotifSliderUI extends BasicSliderUI
{

    static final Dimension PREFERRED_HORIZONTAL_SIZE = new Dimension(164, 15);
    static final Dimension PREFERRED_VERTICAL_SIZE = new Dimension(15, 164);

    static final Dimension MINIMUM_HORIZONTAL_SIZE = new Dimension(43, 15);
    static final Dimension MINIMUM_VERTICAL_SIZE = new Dimension(15, 43);

    /**
     * MotifSliderUI Constructor
     */
    public MotifSliderUI(JSlider b)   {
	super(b);
    }

    /**
     * create a MotifSliderUI object
     */
    public static ComponentUI createUI(JComponent b)    {
        return new MotifSliderUI((JSlider)b);
    }

    public Dimension getPreferredHorizontalSize() {
	return PREFERRED_HORIZONTAL_SIZE;
    }

    public Dimension getPreferredVerticalSize() {
	return PREFERRED_VERTICAL_SIZE;
    }

    public Dimension getMinimumHorizontalSize() {
	return MINIMUM_HORIZONTAL_SIZE;
    }

    public Dimension getMinimumVerticalSize() {
	return MINIMUM_VERTICAL_SIZE;
    }

    /*
    public int getTickSize() {
	return 0;
    }
    */

    /*
    public int getTickSpace() {
	return 0;
    }
    */

    public void calculateThumbBounds()	{
	if(slider.getOrientation() == JSlider.VERTICAL)	{
	    setThumbBounds(getScrollTrackRect().x,
			   yPositionForValue(slider.getValue()) - getThumbRect().height / 2,
			   getScrollTrackRect().width,
			   30);
	} else {
	    setThumbBounds(xPositionForValue(slider.getValue()) - getThumbRect().width / 2,
			   getScrollTrackRect().y, 
			   30,
			   getScrollTrackRect().height);
	}
    }



    public void paintFocus(Graphics g)  {        
    }

    public void paintTrack(Graphics g)  {        
    }

    public void paintThumb(Graphics g)  {
	Rectangle knobBounds = getThumbRect();
        int x = knobBounds.x;
        int y = knobBounds.y;		
        int w = knobBounds.width;
        int h = knobBounds.height;		
		
	if(slider.isEnabled()) {
	    g.setColor(slider.getForeground());
	} else {
	    // PENDING(jeff) - the thumb should be dithered when disabled
	    g.setColor(slider.getForeground().darker());
	}
	
	if (slider.getOrientation() == JSlider.HORIZONTAL ) {
	    g.translate(0, knobBounds.y-1);

	    // fill
	    g.fillRect(x, 1, w, h - 1);

	    // highlight
	    g.setColor(getHighlightColor());
	    g.drawLine(x, 1, x + w - 1, 1);             // top
	    g.drawLine(x, 1, x, h);                     // left
	    g.drawLine(x + w/2, 2, x + w/2, h-1);       // center

	    // shadow
	    g.setColor(getShadowColor());
	    g.drawLine(x + 1, h, x + w - 1, h);         // bottom
	    g.drawLine(x + w - 1, 1, x + w - 1, h);     // right
	    g.drawLine(x + w/2 - 1, 2, x + w/2 - 1, h); // center

	    g.translate(0, -(knobBounds.y-1));
	} else {
	    g.translate(knobBounds.x-1, 0);

	    // fill
	    g.fillRect(1, y, w - 1, h);

	    // highlight
	    g.setColor(getHighlightColor());
	    g.drawLine(1, y, w, y);                     // top
	    g.drawLine(1, y+1, 1, y+h-1);               // left
	    g.drawLine(2, y+h/2, w-1, y+h/2);           // center

	    // shadow
	    g.setColor(getShadowColor());
	    g.drawLine(2, y+h-1, w, y+h-1);             // bottom
	    g.drawLine(w, y+h-1, w, y);                 // right
	    g.drawLine(2, y+h/2-1, w-1, y+h/2-1);       // center

	    g.translate(-(knobBounds.x-1), 0);
	}
    }
    
}

