/*
 * @(#)MotifScrollPaneUI.java	1.5 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.BasicScrollPaneUI;


/**
 * A CDE/Motif L&F implementation of ScrollPaneUI.  
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.5 02/02/98
 * @author Hans Muller
 */
public class MotifScrollPaneUI extends BasicScrollPaneUI
{
    private final static Border vsbMarginBorder = new EmptyBorder(0, 4, 0, 0);
    private final static Border hsbMarginBorder = new EmptyBorder(4, 0, 0, 0);

    protected JScrollBar createVerticalScrollBar() {
	JScrollBar vsb = super.createVerticalScrollBar();
	if (vsb != null) {
	    vsb.setBorder(new CompoundBorder(vsbMarginBorder, vsb.getBorder()));
	}
	return vsb;
    }

    protected JScrollBar createHorizontalScrollBar() {
	JScrollBar hsb = super.createHorizontalScrollBar();
	if (hsb != null) {
	    hsb.setBorder(new CompoundBorder(hsbMarginBorder, hsb.getBorder()));
	}
	return hsb;
    }

    public static ComponentUI createUI(JComponent x) {
	return new MotifScrollPaneUI();
    }
}

