/*
 * @(#)MotifScrollBarUI.java	1.4 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.basic.BasicScrollBarUI;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Graphics;
import java.awt.Color;


/**
 * Implementation of ScrollBarUI for the Motif Look and Feel
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.4 02/02/98
 * @author Rich Schiavi
 * @author Hans Muller
 */
public class MotifScrollBarUI extends BasicScrollBarUI 
{
    /* The following fields are returned by the corresponding
     * get methods rather than heap allocating new Dimension 
     * objects.
     */
    private static final Dimension minimumThumbSize = new Dimension(8, 8);
    private static final Dimension maximumThumbSize = new Dimension(4096, 4096);


    /* The following static fields are lazily computed by 
     * configureScrollBarColors() and are shared by all MotifScrollBarUI 
     * instances. 
     */

    private static Color thumbHighlightColor;
    private static Color thumbShadowColor;
    private static Color thumbColor;
    private static Color trackColor;
    private static boolean scrollBarColorsInitialized = false;


    public static ComponentUI createUI(JComponent c) {
	return new MotifScrollBarUI();
    }


    protected void configureScrollBarColors() {
	if (!scrollBarColorsInitialized) {
	    thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
	    thumbShadowColor = UIManager.getColor("ScrollBar.thumbLightShadow");
	    thumbColor = UIManager.getColor("ScrollBar.thumb");
	    trackColor = UIManager.getColor("ScrollBar.track");
	    scrollBarColorsInitialized = true;
	}
    }


    public Dimension getPreferredSize(JComponent c) {
	Insets insets = c.getInsets();
	int dx = insets.left + insets.right;
	int dy = insets.top + insets.bottom;
	return (scrollbar.getOrientation() == JScrollBar.VERTICAL)
	    ? new Dimension(dx + 11, dy + 33)
	    : new Dimension(dx + 33, dy + 11);
    }


    protected Dimension getMinimumThumbSize() { 
	return minimumThumbSize;
    }

    protected Dimension getMaximumThumbSize()	{ 
	return maximumThumbSize;
    }


    protected JButton createDecreaseButton(int orientation) {
	return new MotifScrollBarButton(orientation);
    } 

    protected JButton createIncreaseButton(int orientation) {
	return new MotifScrollBarButton(orientation);
    }
  

    public void paintTrack(Graphics g, JComponent c, Rectangle trackBounds)  {        
        g.setColor(trackColor);
        g.fillRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height);
    }


    public void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds)  
    {        
	if(thumbBounds.isEmpty() || !scrollbar.isEnabled())	{
	    return;
	}

	int w = thumbBounds.width;
	int h = thumbBounds.height;		
      
	g.translate(thumbBounds.x, thumbBounds.y);
	g.setColor(thumbColor);
	g.fillRect(0, 0, w-1, h-1);
      
	g.setColor(thumbHighlightColor);
	g.drawLine(0, 0, 0, h-1);
	g.drawLine(1, 0, w-1, 0);
      
	g.setColor(thumbShadowColor);
	g.drawLine(1, h-1, w-1, h-1);
	g.drawLine(w-1, 1, w-1, h-2);

	g.translate(-thumbBounds.x, -thumbBounds.y);
    }
}
