/*
 * @(#)MotifRadioButtonUI.java	1.10 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.basic.BasicRadioButtonUI;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;

import com.sun.java.swing.plaf.*;

import java.awt.*;

/**
 * RadioButtonUI implementation for MotifRadioButtonUI
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.10 02/02/98
 * @author Rich Schiavi
 */
public class MotifRadioButtonUI extends BasicRadioButtonUI {
  private static final MotifRadioButtonUI motifRadioButtonUI = new MotifRadioButtonUI();

  protected final static Insets defaultMargin = new Insets(2,2,6,2);   
  private static final int defaultTextIconGap = 8;

  public static ComponentUI createUI(JComponent c) {
    return motifRadioButtonUI;
  }
    
  // fix for BugID: 4091636 focus not painted on Radio/Check
    protected void paintFocus(Graphics g, Rectangle t, Dimension d){
      g.setColor( UIManager.getColor("RadioButton.focus"));
      g.drawRect(0,0,d.width-1,d.height-1);
    } 

    public Insets getDefaultMargin(AbstractButton b) {
	return defaultMargin;
    }

    public int getDefaultTextIconGap(AbstractButton b) {
	return defaultTextIconGap;
    }


} // end class MotifRadioButtonUI
