/*
 * @(#)MotifOptionPaneUI.java	1.8 98/02/05
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.*;
import com.sun.java.swing.plaf.basic.AbstractOptionPaneUI.SyncingLayoutManager;
import com.sun.java.swing.plaf.basic.BasicOptionPaneUI;
import com.sun.java.swing.plaf.ComponentUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;

/**
 * Provides the CDE/Motif look and feel for a JOptionPane.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 * 
 * @version 1.8 02/05/98
 * @author Scott Violet
 */
public class MotifOptionPaneUI extends BasicOptionPaneUI
{
    /**
      * Creates a new MotifOptionPaneUI instance.
      */
    public static ComponentUI createUI(JComponent x) {
	return new MotifOptionPaneUI();
    }

    /**
     * Creates and returns a Container containin the buttons. The buttons
     * are created by calling <code>getButtons</code>.
     */
    protected Container createButtons() {
	Container          b = super.createButtons();

	if(b != null && b.getLayout() instanceof SyncingLayoutManager) {
	    ((SyncingLayoutManager)b.getLayout()).setCentersChildren(false);
	}
	return b;
    }

    /**
     * Returns the insets to be used in the Container housing the buttons.
     */
    protected Insets getButtonInsets() {
	return new Insets(18, 0, 0, 0);
    }

    public void paint(Graphics g, JComponent c) {
	// Draws a line dividing the buttons and body, this relies on the
	// fact that AbstractOptionPaneUI.createButtons installs a top
	// inset on the button Container, that is why this can draw over it.
	if(c.getComponentCount() > 1) {
	    Rectangle          buttonBorder = c.getComponent(1).getBounds();
	    int                lineY = buttonBorder.y;
	    int                lineWidth = c.getBounds().width;

	    g.setColor(Color.darkGray);
	    g.drawLine(0, lineY, lineWidth, lineY);
	    lineY++;
	    g.setColor(Color.white);
	    g.drawLine(0, lineY, lineWidth, lineY);
	}
    }

    /**
     * Creates and adds a JLabel representing the icon returned from
     * <code>getIcon</code> to <code>top</code>. This is messaged from
     * <code>createBody</code>
     */
    protected void addIcon(Container top) {
	/* Create the icon. */
	Icon                  sideIcon = getIcon();

	if (sideIcon != null) {
	    JLabel            iconLabel = new JLabel(sideIcon);

	    iconLabel.setVerticalAlignment(SwingConstants.CENTER);
	    top.add(iconLabel, "West");
	}
    }

    /**
     * Returns null, CDE/Motif does not impose a minimum size.
     */
    public Dimension getMinimumOptionPaneSize() {
	return null;
    }

    /**
     * Returns the insets to be used for the body, the body contains both
     * the image and the actual message.
     */
    protected Insets getBodyInsets() {
	return new Insets(0, 0, 12, 0);
    }

}
