/*
 * @(#)MotifMenuUI.java	1.14 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing.plaf.motif;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.basic.*;
import java.io.Serializable;

import com.sun.java.swing.plaf.basic.BasicMenuUI;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;

/**
 * A Motif L&F implementation of MenuUI.  
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.14 02/02/98
 * @author Georges Saab
 * @author Rich Schiavi
 */
public class MotifMenuUI extends BasicMenuUI
{

    protected ChangeListener changeListener;
    protected static final int defaultTextIconGap = 2;

    public static ComponentUI createUI( JComponent x ) {
	return new MotifMenuUI();
    }
    
    protected void initListeners(JComponent c) {
	super.initListeners(c);
        changeListener = createChangeListener(c);
    }
    
    protected void addListeners(JComponent c) {
	super.addListeners(c);
        ((JMenuItem)c).addChangeListener(changeListener);	
    }

    protected void removeListeners(JComponent c) {
	super.removeListeners(c);
	((JMenuItem)c).removeChangeListener(changeListener);
    }

    protected ChangeListener createChangeListener(JComponent c) {
	return new MenuChangeListener();
    }
    public void paint(Graphics g, JComponent c){
	installDefaultIcons();
	MotifGraphicsUtils.paintMenuItem(g,c,checkIcon,menuArrow,
					 pressedBackground, pressedForeground,
					 defaultTextIconGap);
    }


    boolean popupIsOpen(JMenu m,MenuElement me[]) {
        int i;
        JPopupMenu pm = m.getPopupMenu();

        for(i=me.length-1;i>=0;i--) {
            if(me[i].getComponent() == pm)
                return true;
        }
        return false;
    }
    
    public void processMouseEvent(JMenuItem item,MouseEvent e,MenuElement path[],MenuSelectionManager manager) {
        Point p = e.getPoint();
        if(e.getID() == MouseEvent.MOUSE_MOVED ||
           e.getID() == MouseEvent.MOUSE_ENTERED ||
           e.getID() == MouseEvent.MOUSE_EXITED)
            return;
	if (item.isEnabled() == false)
	  return;

        if(p.x >= 0 && p.x < item.getWidth() &&
           p.y >= 0 && p.y < item.getHeight()) {
	    JMenu menu = (JMenu)item;
            MenuElement selectedPath[] = manager.getSelectedPath();
            if(!popupIsOpen(menu,selectedPath) || 
	       e.getID() == MouseEvent.MOUSE_RELEASED) {
                if(menu.isTopLevelMenu() || 
		   menu.getDelay() == 0) {
                    MenuElement newPath[];
                    MenuElement subElements[];
                    if(e.getID() == MouseEvent.MOUSE_RELEASED) { /** Include first item **/
                        newPath = new MenuElement[path.length+2];
                        System.arraycopy(path,0,newPath,0,path.length);
                        newPath[path.length] = menu.getPopupMenu();
                        subElements = menu.getPopupMenu().getSubElements();
                        if(subElements.length > 0) 
                            newPath[path.length+1] = subElements[0];
                        else {
                            MenuElement tmp[] = new MenuElement[path.length+1];
                            System.arraycopy(newPath,0,tmp,0,newPath.length-1);
                            newPath = tmp;
                        }
                    } else { /** Do not include first item **/
                        newPath = new MenuElement[path.length+1];
                        System.arraycopy(path,0,newPath,0,path.length);
                        newPath[path.length] = menu.getPopupMenu();
                    }
                    manager.setSelectedPath(newPath);
                } else {
                    manager.setSelectedPath(path);
                    setupPostTimer(menu);
                }
            }
        } else if(e.getID() == MouseEvent.MOUSE_RELEASED) {
	    Component c = manager.componentForPoint(e.getComponent(), e.getPoint());
	    if (c == null)
		manager.clearSelectedPath();
        }
    }

    protected class MenuChangeListener implements ChangeListener, Serializable {

	public void stateChanged(ChangeEvent e) {
	    JMenuItem c = (JMenuItem)e.getSource();
	    if (c.isArmed() || c.isSelected()) {
		c.setBorderPainted(true);
		// c.repaint();
	    } else {
		c.setBorderPainted(false);
	    }
	}
    }
}





