/*
 * @(#)MotifGraphicsUtils.java	1.23 98/02/04
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.*;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.KeyEvent;

import com.sun.java.swing.plaf.basic.*;
/*
 * @version 1.23 02/04/98
 * @author Jeff Dinkins
 * @author Dave Kloba
 */

public class MotifGraphicsUtils implements SwingConstants 
{
    public static final Font controlFont = new Font("Dialog", Font.PLAIN, 12);

    public static Color control = new Color(192,192,192);
    public static Color controlLight = new Color(231, 231, 231);
    public static Color controlShadow = new Color(102,102,102);
    public static Color controlLightShadow = new Color(155,155,155);
    public static Color controlHighlight = Color.white;
    public static Color controlDisabled = new Color(117, 117, 117);
    public static Color controlBlack = Color.black;
    public static Color controlWhite = Color.white;
    

    // ScrollBarButton colors
    public final static Color gray231 = new Color(231, 231, 231);
    public final static Color gray153 = new Color(153, 153, 153);
    public final static Color gray102 = new Color(102, 102, 102);

    /**
     * Convenience method for drawing a button bezel.
     */
    static void drawButtonBezel(Graphics g, int x, int y,
				int width, int height, boolean raised)
    {
	// ** Paint the button in
	if(raised) {
	    g.setColor(MotifGraphicsUtils.controlWhite);
	    g.drawLine(x+1, y+1, x+1, y+1);
	    
	    g.setColor(MotifGraphicsUtils.controlLight);
	    g.drawLine(x, y, x+width-3, y);
	    g.drawLine(x, y, x, y+height-4);
	    
	    g.setColor(controlLightShadow);
	    g.drawLine(x+1, y+height-2, x+width-3, y+height-2);
	    g.drawLine(x+width-2, y+height-1, x+width-2, y+1);
	    
	    g.drawLine(x+width-3, y+height-3, x+width-3, y+height-3);
	    g.drawLine(x+width-1, y+0, x+width-1, y+0);
	    g.drawLine(x+0, y+height-1, x+0, y+height-1);
	    
	    g.setColor(MotifGraphicsUtils.controlShadow);
	    g.drawLine(x+1, y+height-1, x+width-1, y+height-1);
	    g.drawLine(x+width-1, y+height-2, x+width-1, y+1);
	    g.drawLine(x+width-2, y+height-2, x+width-2, y+height-2);
	} else {
	    g.setColor(controlWhite);
	    g.drawLine(x + width-2, y + height-2, x + width-2, y + height-2);
	    
	    g.setColor(controlLight);
	    g.drawLine(x+2,       y+height-1,  x+width-1, y+height-1);
	    g.drawLine(x+width-1, y+height-2,  x+width-1, y+3);
	    
	    g.setColor(controlLightShadow);
	    g.drawLine(x+2, y+1, x+width-2, y+1);
	    g.drawLine(x+1, y+2, x+1,       y+height-2);
	    
	    g.drawLine(width-1, y,          x+width-1, y);
	    g.drawLine(x+2,     y+2,        x+2,       y+2);
	    g.drawLine(x,       y+height-1, x+0,       y+height-1);
	    
	    g.setColor(controlShadow);
	    g.drawLine(x,   y,   x+width-2, y);
	    g.drawLine(x,   y+1, x,         y+height-2);
	    g.drawLine(x+1, y+1, x+1,       y+1);
	}
    }
    
    /**
     * Convenience method for drawing a raised ScrollBar Button bezel.
     */
    static void drawRaisedScrollButtonBezel(Graphics g, int x, int y,
                                            int width, int height) {
        int maxX, maxY;
	
        maxX = x + width;
        maxY = y + height;

        g.setColor(Color.white);
        g.drawLine(x, y + 1, x, maxY - 3);
        g.drawLine(x + 1, y, maxX - 3, y);

        g.setColor(gray231);
        drawPoint(g, x, y);
        drawPoint(g, x, maxY - 2);
        drawPoint(g, maxX - 2, y);

        g.setColor(gray153);
        drawPoint(g, maxX - 1, y);
        drawPoint(g, maxX - 1, maxY - 1);
        drawPoint(g, x, maxY - 1);

        g.setColor(gray102);
        g.drawLine(maxX - 1, y + 1, maxX - 1, maxY - 2);
        g.drawLine(x + 1, maxY - 1, maxX - 2, maxY - 1);
    }

    /**
     * Convenience method for drawing a lowered ScrollBar Button bezel.
     */
    static void drawLoweredScrollButtonBezel(Graphics g, int x, int y,
                                             int width, int height) {
        int maxX, maxY;

        maxX = x + width;
        maxY = y + height;

        g.setColor(gray153);
        g.drawLine(x, maxY - 1, maxX - 1, maxY - 1);
        g.drawLine(maxX - 1, y, maxX - 1, maxY - 2);

        g.setColor(Color.lightGray);
        g.drawLine(x, y, maxX - 2, y);
        g.drawLine(x, y + 1, x, maxY - 2);
    }
	
    /**
     * Draws the point (<b>x</b>, <b>y</b>) in the current color.
     */
    static void drawPoint(Graphics g, int x, int y) {
        g.drawLine(x, y, x, y);
    }

    /**
     * Draws the Image tiled in the supplied rectangle.  Calls
     * <b>paint()</b> for each tile.
     */
    static void drawTiledIcon(Component c, Icon icon, Graphics g1, int x, int y, int width, int height) {
        Rectangle clipRect;
        int imageWidth, imageHeight, minX, minY, maxX, maxY;

		Graphics g = g1.create();

        clipRect = g1.getClipBounds();

        imageWidth = icon.getIconWidth();
        imageHeight = icon.getIconHeight();

        if (imageWidth <= 0 || imageHeight <= 0)
            return;

        g.setClip(x, y, width, height);

        if (x > clipRect.x)
            minX = x;
        else
            minX = x + imageWidth * ((clipRect.x - x) / imageWidth);

        if ((x + width) < (clipRect.x + clipRect.width))
            maxX = x + width;
        else
            maxX = (clipRect.x + clipRect.width);

        if (y > clipRect.y)
            minY = y;
        else
            minY= y + imageHeight * ((clipRect.y - y) / imageHeight);

        if ((y + height) < (clipRect.y + clipRect.height))
            maxY = (y + height);
        else
            maxY = (clipRect.y + clipRect.height);

        for (x = minX; x < maxX; x += imageWidth) {
            for (y = minY; y < maxY; y += imageHeight) {
                icon.paintIcon(c, g, x, y);
            }
        }
		g.dispose();
    }

    /*
     * Convenience method for drawing a grooved line
     *
     */
    public static void drawGroove(Graphics g, int x, int y, int w, int h)
    {
	Color oldColor = g.getColor();	// Make no net change to g
	g.translate(x, y);

	g.setColor(controlShadow);
	g.drawRect(0, 0, w-2, h-2);

	g.setColor(controlWhite);
	g.drawLine(1, h-3, 1, 1);
	g.drawLine(1, 1, w-3, 1);

	g.drawLine(0, h-1, w-1, h-1);
	g.drawLine(w-1, h-1, w-1, 0);

	g.translate(-x, -y);
	g.setColor(oldColor);
    }

    /** Draws <b>aString</b> in the rectangle defined by
      * (<b>x</b>, <b>y</b>, <b>width</b>, <b>height</b>).
      * <b>justification</b> specifies the text's justification, one of
      * LEFT, CENTER, or RIGHT.
      * <b>drawStringInRect()</b> does not clip to the rectangle, but instead
      * uses this rectangle and the desired justification to compute the point
      * at which to begin drawing the text.
      * @see #drawString
      */
    public static void drawStringInRect(Graphics g, String aString, int x, int y,
                                 int width, int height, int justification) {
        FontMetrics  fontMetrics;
        int          drawWidth, startX, startY, delta;

        if (g.getFont() == null) {
//            throw new InconsistencyException("No font set");
            return;
        }
        fontMetrics = g.getFontMetrics();
        if (fontMetrics == null) {
//            throw new InconsistencyException("No metrics for Font " + font());
            return;
        }

        if (justification == CENTER) {
            drawWidth = fontMetrics.stringWidth(aString);
            if (drawWidth > width) {
                drawWidth = width;
            }
            startX = x + (width - drawWidth) / 2;
        } else if (justification == RIGHT) {
            drawWidth = fontMetrics.stringWidth(aString);
            if (drawWidth > width) {
                drawWidth = width;
            }
            startX = x + width - drawWidth;
        } else {
            startX = x;
        }

        delta = (height - fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
        if (delta < 0) {
            delta = 0;
        }

        startY = y + height - delta - fontMetrics.getDescent();

        g.drawString(aString, startX, startY);
    }


  public static void paintMenuItem(Graphics g, JComponent c,
				   Icon checkIcon, Icon arrowIcon,
				   Color background, Color foreground,
				   int defaultTextIconGap)
    {

	JMenuItem b = (JMenuItem) c;
      ButtonModel model = b.getModel();

      Dimension size = b.getSize();
      Insets i = c.getInsets();
      
      Rectangle viewRect = new Rectangle(size);

      viewRect.x += i.left;
      viewRect.y += i.top;
      viewRect.width -= (i.right + viewRect.x);
      viewRect.height -= (i.bottom + viewRect.y);

      Rectangle iconRect = new Rectangle();
      Rectangle textRect = new Rectangle();
      Rectangle acceleratorRect = new Rectangle();
      Rectangle checkRect = new Rectangle();
      Rectangle arrowRect = new Rectangle();

      Font holdf = g.getFont();
      Font f = c.getFont();
      g.setFont(f);
      FontMetrics fm = g.getFontMetrics(f);
      FontMetrics fmAccel = g.getFontMetrics( UIManager.getFont("MenuItem.acceleratorFont") );

      if (c.isOpaque()) {
	  if (model.isArmed()|| (c instanceof JMenu && model.isSelected())) {
	      g.setColor(background);
	  } else {
	      g.setColor(c.getBackground());
	  }
	  g.fillRect(0,0, size.width, size.height);
      }

      // get Accelerator text
      KeyStroke accelerator =  b.getAccelerator();
      String acceleratorText = "";
      if (accelerator != null) {
	  int modifiers = accelerator.getModifiers();
	  if (modifiers > 0) {
	      acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
	      acceleratorText += "+";
	  }
	  acceleratorText += KeyEvent.getKeyText(accelerator.getKeyCode());
      }

      // layout the text and icon
      String text = BasicGraphicsUtils.layoutMenuItem(
						  fm, b.getText(), fmAccel,
						  acceleratorText, b.getIcon(),
						  checkIcon, arrowIcon,
						  b.getVerticalAlignment(), 
						  b.getHorizontalAlignment(),
						  b.getVerticalTextPosition(), 
						  b.getHorizontalTextPosition(),
						  viewRect, iconRect, 
						  textRect, acceleratorRect,
						  checkRect, arrowRect,
						  b.getText() == null ? 0 : defaultTextIconGap,
						  defaultTextIconGap
						  );
      
      // Paint the Check
      Color holdc = g.getColor();
      if (checkIcon != null) {
	if(model.isArmed() || (c instanceof JMenu && model.isSelected()))
	  g.setColor(foreground);
	checkIcon.paintIcon(c, g, checkRect.x, checkRect.y);
	g.setColor(holdc);
      }

      // Paint the Icon
      if(b.getIcon() != null) { 
	Icon icon;
	if(!model.isEnabled()) {
	  icon = (Icon) b.getDisabledIcon();
	} else if(model.isPressed() && model.isArmed()) {
	  icon = (Icon) b.getPressedIcon();
	  if(icon == null) {
	    // Use default icon
	    icon = (Icon) b.getIcon();
	  } 
	} else {
	  icon = (Icon) b.getIcon();
	}
	      
	icon.paintIcon(c, g, iconRect.x, iconRect.y);
      }

      // Draw the Text
      if(text != null && !text.equals("")) {
	if(!model.isEnabled()) {
	  // *** paint the text disabled
                g.setColor(b.getBackground().brighter());
                BasicGraphicsUtils.drawString(g,text,model.getMnemonic(),
                                              textRect.x, textRect.y + fm.getAscent());
                g.setColor(b.getBackground().darker());
                BasicGraphicsUtils.drawString(g,text,model.getMnemonic(),
                                              textRect.x - 1, textRect.y + fm.getAscent() - 1);

		//	  g.setColor( Color.white ); // light gray??
		//BasicGraphicsUtils.drawString(g,text,model.getMnemonic(),
		//textRect.x, textRect.y + fm.getAscent());
	} else {
	  // *** paint the text normally
	  if (model.isArmed()|| (c instanceof JMenu && model.isSelected())) {
	    g.setColor(foreground);
	  } else {
	    g.setColor(b.getForeground());
	  }
	  BasicGraphicsUtils.drawString(g,text, 
					model.getMnemonic(),
					textRect.x,
					textRect.y + fm.getAscent());
	}
      }
	  
      // Draw the Accelerator Text
      if(acceleratorText != null && !acceleratorText.equals("")) {
	  g.setFont( UIManager.getFont("MenuItem.acceleratorFont") );
	  if(!model.isEnabled()) {
	      // *** paint the acceleratorText disabled
	      g.setColor(b.getBackground().brighter());
	      BasicGraphicsUtils.drawString(g,acceleratorText,model.getMnemonic(),
					    acceleratorRect.x, acceleratorRect.y + fm.getAscent());
	      g.setColor(b.getBackground().darker());
	      BasicGraphicsUtils.drawString(g,acceleratorText,model.getMnemonic(),
					    acceleratorRect.x - 1, acceleratorRect.y + fm.getAscent() - 1);
	  } else {
	      // *** paint the acceleratorText normally
	      if (model.isArmed()|| (c instanceof JMenu && model.isSelected()))
		  {
		      g.setColor(foreground);
		  } else {
		      g.setColor(b.getForeground());
		  }
	      BasicGraphicsUtils.drawString(g,acceleratorText, 
					    model.getMnemonic(),
					    acceleratorRect.x,
					    acceleratorRect.y + fm.getAscent());
	  }
      }

      // Paint the Arrow
      if (arrowIcon != null) {
	if(model.isArmed() || (c instanceof JMenu && model.isSelected()))
	  g.setColor(foreground);
	if( !(b.getParent() instanceof JMenuBar) )
	  arrowIcon.paintIcon(c, g, arrowRect.x, arrowRect.y);
      }

      g.setColor(holdc);
      g.setFont(holdf);
    }

  private static void drawMenuBezel(Graphics g, Color background,
				    int x, int y,
				    int width, int height)
    {
      // shadowed button region
      g.setColor(background);
      g.fillRect(x,y,width,height);

      g.setColor(background.brighter().brighter());
      g.drawLine(x+1,       y+height-1,  x+width-1, y+height-1);
      g.drawLine(x+width-1, y+height-2,  x+width-1, y+1);
	    
      g.setColor(background.darker().darker());
      g.drawLine(x,   y,   x+width-2, y);
      g.drawLine(x,   y+1, x,         y+height-2);
      
    }


}



