/*
 * @(#)MotifFrameBorder.java	1.5 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Color;
import java.awt.Insets;

import java.awt.*;
import java.beans.*;

import com.sun.java.swing.*;
import com.sun.java.swing.border.AbstractBorder;
import com.sun.java.swing.plaf.UIResource;

/**
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.5 02/02/98
 * @author unknown
 */

public class MotifFrameBorder extends AbstractBorder implements UIResource {

    JComponent jcomp;
    Color frameHighlight;
    Color frameColor;
    Color frameShadow;

    // The width of the border
    public final static int BORDER_SIZE = 5;

    /** Constructs an FrameBorder for the JComponent <b>comp</b>.
      */
    public MotifFrameBorder(JComponent comp) {
        jcomp = comp;
    }

    /** Sets the FrameBorder's JComponent.
      */
    public void setComponent(JComponent comp) {
        jcomp = comp;
    }

    /** Returns the FrameBorder's JComponent.
      * @see #setComponent
      */
    public JComponent component() {
        return jcomp;
    }

    protected Color getFrameHighlight() {
        return frameHighlight;
    }

    protected Color getFrameColor() {
        return frameColor;
    }
    
    protected Color getFrameShadow() {
        return frameShadow;
    }

    static Insets insets = new Insets(BORDER_SIZE, BORDER_SIZE,
                                      BORDER_SIZE, BORDER_SIZE);

    public Insets getBorderInsets(Component c) {
        return insets;
    }

   /** Draws the FrameBorder's top border.
     */
    protected boolean drawTopBorder(Component c, Graphics g, 
                                    int x, int y, int width, int height) {
        Rectangle titleBarRect = new Rectangle(x, y, width, BORDER_SIZE);
        if (!g.getClipBounds().intersects(titleBarRect)) {
            return false;
        }

        int maxX = width - 1;
        int maxY = BORDER_SIZE - 1;

        // Draw frame
        g.setColor(frameColor);
        g.drawLine(x, y + 2, maxX - 2, y + 2);
        g.drawLine(x, y + 3, maxX - 2, y + 3);
        g.drawLine(x, y + 4, maxX - 2, y + 4);

        // Draw highlights
        g.setColor(frameHighlight);
        g.drawLine(x, y, maxX, y);
        g.drawLine(x, y + 1, maxX, y + 1);
        g.drawLine(x, y + 2, x, y + 4);
        g.drawLine(x + 1, y + 2, x + 1, y + 4);

        // Draw shadows
        g.setColor(frameShadow);
        g.drawLine(x + 4, y + 4, maxX - 4, y + 4);
        g.drawLine(maxX, y + 1, maxX, maxY);
        g.drawLine(maxX - 1, y + 2, maxX - 1, maxY);

        return true;
    }

    /** Draws the FrameBorder's left border.
      */
    protected boolean drawLeftBorder(Component c, Graphics g, int x, int y, 
                               int width, int height) {
        Rectangle borderRect = 
            new Rectangle(0, 0, getBorderInsets(c).left, height);
        if (!g.getClipBounds().intersects(borderRect)) {
            return false;
        }

        int startY = BORDER_SIZE;

        g.setColor(frameHighlight);
        g.drawLine(x, startY, x, height - 1);
        g.drawLine(x + 1, startY, x + 1, height - 2);

        g.setColor(frameColor);
        g.fillRect(x + 2, startY, x + 2, height - 3);

        g.setColor(frameShadow);
        g.drawLine(x + 4, startY, x + 4, height - 5);

        return true;
    }

    /** Draws the FrameBorder's right border.
      */
    protected boolean drawRightBorder(Component c, Graphics g, int x, int y, 
                                int width, int height) {
        Rectangle borderRect = new Rectangle(
            width - getBorderInsets(c).right, 0,
            getBorderInsets(c).right, height);
        if (!g.getClipBounds().intersects(borderRect)) {
            return false;
        }

        int startX = width - getBorderInsets(c).right;
        int startY = BORDER_SIZE;

        g.setColor(frameColor);
        g.fillRect(startX + 1, startY, 2, height - 1);

        g.setColor(frameShadow);
        g.fillRect(startX + 3, startY, 2, height - 1);

        g.setColor(frameHighlight);
        g.drawLine(startX, startY, startX, height - 1);

        return true;
    }

    /** Draws the FrameBorder's bottom border.
      */
    protected boolean drawBottomBorder(Component c, Graphics g, int x, int y, 
                                 int width, int height) {
        Rectangle    borderRect;
        int     marginHeight, startY;

        borderRect = new Rectangle(0, height - getBorderInsets(c).bottom,
                                  width, getBorderInsets(c).bottom);
        if (!g.getClipBounds().intersects(borderRect)) {
            return false;
        }

        startY = height - getBorderInsets(c).bottom;

        g.setColor(frameShadow);
        g.drawLine(x + 1, height - 1, width - 1, height - 1);
        g.drawLine(x + 2, height - 2, width - 2, height - 2);

        g.setColor(frameColor);
        g.fillRect(x + 2, startY + 1, width - 4, 2);

        g.setColor(frameHighlight);
        g.drawLine(x + 5, startY, width - 5, startY);

        return true;
    }

    // Returns true if the associated component has focus.
    protected boolean isActiveFrame() {
        return jcomp.hasFocus();
    }

    /** Draws the FrameBorder in the given Rect.  Calls
      * <b>drawTitleBar</b>, <b>drawLeftBorder</b>, <b>drawRightBorder</b> and
      * <b>drawBottomBorder</b>.
      */
    public void paintBorder(Component c, Graphics g, 
                            int x, int y, int width, int height) {
        if (isActiveFrame()) {
            frameColor = UIManager.getColor("activeCaptionBorder");
        } else {
            frameColor = UIManager.getColor("inactiveCaptionBorder");
        }
        frameHighlight = frameColor.brighter();
        frameShadow = frameColor.darker().darker();

        drawTopBorder(c, g, x, y, width, height);
        drawLeftBorder(c, g, x, y, width, height);
        drawRightBorder(c, g, x, y, width, height);
        drawBottomBorder(c, g, x, y, width, height);
    }
}
