/*
 * @(#)MotifFileChooserUI.java	1.9 98/04/14
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.*;
import com.sun.java.swing.preview.*;
import com.sun.java.swing.preview.filechooser.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.File;
import java.io.IOException;
import java.util.*;

/**
 * Motif FileChooserUI.  
 *
 * @version 1.9 04/14/98
 * @author Jeff Dinkins
 */
public class MotifFileChooserUI extends BasicFileChooserUI {

    private FilterComboBoxModel filterComboBoxModel;

    protected JList directoryList = null;
    protected JList fileList = null;

    protected JTextField pathField = null;
    protected JComboBox filterComboBox = null;
    protected JTextField filenameTextField = null;

    private static final Dimension hstrut10 = new Dimension(10, 1);
    private static final Dimension vstrut10 = new Dimension(1, 10);

    private static final Insets insets = new Insets(10, 10, 10, 10);

    private static Dimension prefListSize = new Dimension(75, 150);

    private static Dimension WITH_ACC_PREF_SIZE = new Dimension(650, 450);
    private static Dimension PREF_SIZE = new Dimension(350, 450);
    private static Dimension MIN_SIZE = new Dimension(200, 300);

    private static Dimension PREF_ACC_SIZE = new Dimension(10, 10);
    private static Dimension ZERO_ACC_SIZE = new Dimension(1, 1);

    private static Dimension MAX_SIZE = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);

    private static final Insets buttonMargin = new Insets(3, 3, 3, 3);

    private JPanel directoryPanel = new JPanel();

    protected JButton approveButton;

    public MotifFileChooserUI(JFileChooser filechooser) {
	super(filechooser);
    }

    public String getFileName() {
	if(filenameTextField != null) {
	    return filenameTextField.getText();
	} else {
	    return null;
	}
    }

    public void setFileName(String filename) {
	if(filenameTextField != null) {
	    filenameTextField.setText(filename);
	}
    }

    public String getDirectoryName() {
	return pathField.getText();
    }

    public void setDirectoryName(String dirname) {
	pathField.setText(dirname);
    }

    public void ensureFileIsVisible(File f) {
	// PENDING(jeff)
    }

    public void rescanCurrentDirectory() {
	// PENDING(jeff) 
    }

    public void propertyChange(PropertyChangeEvent e) {
	String prop = e.getPropertyName();
	if(prop.equals(JFileChooser.SELECTED_FILE_CHANGED_PROPERTY)) {
	    File f = (File) e.getNewValue();
	    if(f != null) {
		setFileName(getFileChooser().getName(f));
		/*
		if(model.contains(f)) {
		    list.setSelectedIndex(model.indexOf(e.getNewValue()));
		    list.ensureIndexIsVisible(list.getSelectedIndex());
		}
		*/
	    }
	} else if(prop.equals(JFileChooser.DIRECTORY_CHANGED_PROPERTY)) {
	    directoryList.clearSelection();
	    File currentDirectory = getFileChooser().getCurrentDirectory();
	    if(currentDirectory != null) {
		try {
		    setDirectoryName(((File)e.getNewValue()).getCanonicalPath());
		} catch (IOException ioe) {
		    setDirectoryName(((File)e.getNewValue()).getAbsolutePath());
		}
	    }
	} else if(prop.equals(JFileChooser.FILE_SELECTION_MODE_CHANGED_PROPERTY)) {
	    directoryList.clearSelection();
	} else if(prop == JFileChooser.ACCESSORY_CHANGED_PROPERTY) {
	    if(getAccessoryPanel() != null) {
		if(e.getOldValue() != null) {
		    getAccessoryPanel().remove((JComponent) e.getOldValue());
		}
		JComponent accessory = (JComponent) e.getNewValue();
		if(accessory != null) {
		    getAccessoryPanel().add(accessory, BorderLayout.CENTER);
		    getAccessoryPanel().setPreferredSize(PREF_ACC_SIZE);
		    getAccessoryPanel().setMaximumSize(MAX_SIZE);
		} else {
		    getAccessoryPanel().setPreferredSize(ZERO_ACC_SIZE);
		    getAccessoryPanel().setMaximumSize(ZERO_ACC_SIZE);
		}
	    }
	} else if(prop == JFileChooser.APPROVE_BUTTON_TEXT_CHANGED_PROPERTY ||
	   prop == JFileChooser.DIALOG_TYPE_CHANGED_PROPERTY) {
	    approveButton.setText(getApproveButtonText());
	    approveButton.setToolTipText(getApproveButtonToolTipText());
	}
    }

    //
    // ComponentUI Interface Implementation methods
    //
    public static ComponentUI createUI(JComponent c) {
        return new MotifFileChooserUI((JFileChooser)c);
    }

    public void installUI(JComponent c) {
	super.installUI(c);
    }

    public void installComponents() {

	getFileChooser().setLayout(new BoxLayout(getFileChooser(), BoxLayout.Y_AXIS));
	getFileChooser().add(Box.createRigidArea(vstrut10));

	JPanel interior = new JPanel() {
	    public Insets getInsets() {
		return insets;
	    }
	};
	align(interior);
	interior.setLayout(new BoxLayout(interior, BoxLayout.Y_AXIS));

	getFileChooser().add(interior);

	// PENDING(jeff) - I18N
	JLabel l = new JLabel("Enter path or folder name:");
	align(l);
	interior.add(l);

	File currentDirectory = getFileChooser().getCurrentDirectory();
	String curDirName = null;
	if(currentDirectory != null) {
	    curDirName = currentDirectory.getPath();
	}
	pathField = new JTextField(curDirName);
	align(pathField);

	// Change to folder on return
	pathField.addActionListener(getUpdateAction());
	interior.add(pathField);

	interior.add(Box.createRigidArea(vstrut10));
	

	// CENTER: left, right accessory
	JPanel centerPanel = new JPanel();
	centerPanel.setPreferredSize(MAX_SIZE);
	centerPanel.setLayout(new BoxLayout(centerPanel, BoxLayout.X_AXIS));
	align(centerPanel);

	// left panel - Filter & folderList
	JPanel leftPanel = new JPanel();
	leftPanel.setLayout(new BoxLayout(leftPanel, BoxLayout.Y_AXIS));
	align(leftPanel);

	// add the filter PENDING(jeff) - I18N
	l = new JLabel("Filter");
	align(l);
	leftPanel.add(l);

	filterComboBox = new JComboBox();
	filterComboBoxModel = createFilterComboBoxModel();
	filterComboBox.setModel(filterComboBoxModel);
	filterComboBox.setRenderer(createFilterComboBoxRenderer());
	getFileChooser().addPropertyChangeListener(filterComboBoxModel);
	align(filterComboBox);
	leftPanel.add(filterComboBox);

	/*
	JTextField tmp = new JTextField("*") {
	    public Dimension getMinimuSize() {
		return new Dimension(prefListSize.width, super.getMinimumSize().height);
	    }
	    public Dimension getPreferredSize() {
		return new Dimension(prefListSize.width, super.getPreferredSize().height);
	    }
	    public Dimension getMaximumSize() {
		return new Dimension(MAX_SIZE.width, super.getMaximumSize().height);
	    }
	};
	tmp.setEnabled(false);
	align(tmp);
	leftPanel.add(tmp);
	*/

	// leftPanel.add(Box.createRigidArea(vstrut10));

	// Add the Folder List PENDING(jeff) - I18N
	l = new JLabel("Folders");
	align(l);
	leftPanel.add(l);
	leftPanel.add(createDirectoryList());


	// create files list
	JPanel rightPanel = new JPanel();
	align(rightPanel);
	rightPanel.setLayout(new BoxLayout(rightPanel, BoxLayout.Y_AXIS));

	l = new JLabel("Files");
	align(l);
	rightPanel.add(l);
	rightPanel.add(createFilesList());

	centerPanel.add(leftPanel);
	centerPanel.add(Box.createRigidArea(hstrut10));
	centerPanel.add(rightPanel);
	
	JComponent accessoryPanel = getAccessoryPanel();
	JComponent accessory = getFileChooser().getAccessory();
	if(accessoryPanel != null) {
	    if(accessory == null) {
		accessoryPanel.setPreferredSize(ZERO_ACC_SIZE);
		accessoryPanel.setMaximumSize(ZERO_ACC_SIZE);
	    } else {
		getAccessoryPanel().add(accessory, BorderLayout.CENTER);
		accessoryPanel.setPreferredSize(PREF_ACC_SIZE);
		accessoryPanel.setMaximumSize(MAX_SIZE);
	    }
	    align(accessoryPanel);
	    centerPanel.add(accessoryPanel);
	}
	interior.add(centerPanel);
	interior.add(Box.createRigidArea(vstrut10));

	// add the filename field PENDING(jeff) - I18N
	l = new JLabel("Enter file name:");
	align(l);
	interior.add(l);

	filenameTextField = new JTextField();
	filenameTextField.addActionListener(getApproveSelectionAction());
	align(filenameTextField);
	filenameTextField.setAlignmentX(JComponent.LEFT_ALIGNMENT);
	interior.add(filenameTextField);

	interior.add(Box.createRigidArea(vstrut10));

	getFileChooser().add(new JSeparator());
	getFileChooser().add(Box.createRigidArea(vstrut10));

	// Add buttons
	JPanel buttonPanel = new JPanel();
	align(buttonPanel);
	buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));
	buttonPanel.add(Box.createGlue());

	approveButton = new JButton(getApproveButtonText()) {
	    public Dimension getMaximumSize() {
		return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
	    }
	};
	approveButton.setToolTipText(getApproveButtonToolTipText());
	align(approveButton);
	approveButton.setMargin(buttonMargin);
	approveButton.addActionListener(getApproveSelectionAction());
	buttonPanel.add(approveButton);
	buttonPanel.add(Box.createGlue());

	JButton updateButton = new JButton(updateButtonText) {
	    public Dimension getMaximumSize() {
		return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
	    }
	};
	updateButton.setToolTipText(updateButtonToolTipText);
	align(updateButton);
	updateButton.setMargin(buttonMargin);
	updateButton.addActionListener(getUpdateAction());
	buttonPanel.add(updateButton);
	buttonPanel.add(Box.createGlue());

	JButton cancelButton = new JButton(cancelButtonText) {
	    public Dimension getMaximumSize() {
		return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
	    }
	};
	cancelButton.setToolTipText(cancelButtonToolTipText);
	align(cancelButton);
	cancelButton.setMargin(buttonMargin);
	cancelButton.addActionListener(getCancelSelectionAction());
	buttonPanel.add(cancelButton);
	buttonPanel.add(Box.createGlue());

	JButton helpButton = new JButton(helpButtonText) {
	    public Dimension getMaximumSize() {
		return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
	    }
	};
	helpButton.setToolTipText(helpButtonToolTipText);
	align(helpButton);
	helpButton.setMargin(buttonMargin);
	helpButton.setEnabled(false);
	buttonPanel.add(helpButton);
	buttonPanel.add(Box.createGlue());

	getFileChooser().add(buttonPanel);
	getFileChooser().add(Box.createRigidArea(vstrut10));
	getFileChooser().add(Box.createGlue());
    }   


    public void uninstallUI(JComponent c) {
	getFileChooser().removeAll();
	super.uninstallUI(c);
    }

    protected void loadIcons() {
    }

    protected JScrollPane createFilesList() {
	fileList = new JList();
	fileList.setModel(new MotifFileListModel());
	fileList.setCellRenderer(new FileCellRenderer());
	fileList.addListSelectionListener(createListSelectionListener());
	fileList.addMouseListener(createDoubleClickListener(fileList));
	align(fileList);
	JScrollPane scrollpane = new JScrollPane(fileList);
	scrollpane.setPreferredSize(prefListSize);
	scrollpane.setMaximumSize(MAX_SIZE);
	align(scrollpane);
	return scrollpane;
    }

    protected JScrollPane createDirectoryList() {
	directoryList = new JList();
	align(directoryList);

	directoryList.setCellRenderer(new DirectoryCellRenderer());
	directoryList.setModel(new MotifDirectoryListModel());
	directoryList.addMouseListener(createDoubleClickListener(directoryList));
	directoryList.addListSelectionListener(createListSelectionListener());

	JScrollPane scrollpane = new JScrollPane(directoryList);
	scrollpane.setMaximumSize(MAX_SIZE);
	scrollpane.setPreferredSize(prefListSize);
	align(scrollpane);
	return scrollpane;
    }

    public Dimension getPreferredSize(JComponent x) {
	if(getFileChooser().getAccessory() != null) {
	    return WITH_ACC_PREF_SIZE;
	} else {
	    return PREF_SIZE;
	}
    }

    public Dimension getMinimumSize(JComponent x)  {
	return MIN_SIZE;
    }
    
    public Dimension getMaximumSize(JComponent x) {
	return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void align(JComponent c) {
	c.setAlignmentX(JComponent.LEFT_ALIGNMENT);
	c.setAlignmentY(JComponent.TOP_ALIGNMENT);
    }

    protected class FileCellRenderer extends BasicListCellRenderer  {
	public Component getListCellRendererComponent(JList list, Object value, int index,
						      boolean isSelected, boolean cellHasFocus) {

	    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
	    setText(getFileChooser().getName((File) value));
	    return this;
	}
    }

    protected class DirectoryCellRenderer extends BasicListCellRenderer  {
	public Component getListCellRendererComponent(JList list, Object value, int index,
						      boolean isSelected, boolean cellHasFocus) {

	    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
	    setText(getFileChooser().getName((File) value));
	    return this;
	}
    }

    protected class MotifDirectoryListModel extends AbstractListModel implements ListDataListener {
	public MotifDirectoryListModel() {
	    getModel().addListDataListener(this);
	}

	public int getSize() {
	    return getModel().getDirectories().size();
	}

	public Object getElementAt(int index) {
	    return getModel().getDirectories().elementAt(index);
	}

	public void intervalAdded(ListDataEvent e) {
	}
	
	// PENDING(jeff) - implement
	public void intervalRemoved(ListDataEvent e) {
	}
	
	// PENDING(jeff) - this is inefficient - should sent out
	// incremental adjustment values instead of saying that the
	// whole list has changed.
	public void fireContentsChanged() {
	    // System.out.println("MotifDirectoryPane: -- firing contents changed");
	    fireContentsChanged(this, 0, getModel().getDirectories().size()-1);
	}

	// PENDING(jeff) - fire the interval changed
	public void contentsChanged(ListDataEvent e) {
	    // System.out.println("MotifDirectoryListModel -- received contents changed");
	    fireContentsChanged();
	}
    
    }

    protected class MotifFileListModel extends AbstractListModel implements ListDataListener {
	public MotifFileListModel() {
	    getModel().addListDataListener(this);
	}

	public int getSize() {
	    return getModel().getFiles().size();
	}

	public boolean contains(Object o) {
	    return getModel().getFiles().contains(o);
	}

	public int indexOf(Object o) {
	    return getModel().getFiles().indexOf(o);
	}

	public Object getElementAt(int index) {
	    return getModel().getFiles().elementAt(index);
	}

	public void intervalAdded(ListDataEvent e) {
	}
	
	// PENDING(jeff) - implement
	public void intervalRemoved(ListDataEvent e) {
	}
	
	// PENDING(jeff) - this is inefficient - should sent out
	// incremental adjustment values instead of saying that the
	// whole list has changed.
	public void fireContentsChanged() {
	    fireContentsChanged(this, 0, getModel().getFiles().size()-1);
	}

	// PENDING(jeff) - fire the interval changed
	public void contentsChanged(ListDataEvent e) {
	    fireContentsChanged();
	}
    
    }

    //
    // DataModel for Types Comboxbox
    //
    protected FilterComboBoxModel createFilterComboBoxModel() {
	return new FilterComboBoxModel();
    }

    //
    // Renderer for Types ComboBox
    //
    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
	return new FilterComboBoxRenderer();
    }
    

    /**
     * Render different type sizes and styles.
     */
    public class FilterComboBoxRenderer extends BasicListCellRenderer {
	public Component getListCellRendererComponent(JList list,
	    Object value, int index, boolean isSelected, 
	    boolean cellHasFocus) {

	    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);

	    FileFilter filter = (FileFilter) value;
	    if(filter != null) {
		setText(filter.getDescription());
	    } 
	    
	    return this;
	}
    }

    /**
     * Data model for a type-face selection combo-box. 
     */
    protected class FilterComboBoxModel extends AbstractListModel implements ComboBoxModel, PropertyChangeListener {
	protected FileFilter[] filters;
	protected FilterComboBoxModel() {
	    super();
	    filters = getFileChooser().getChoosableFileFilters();
	}
	
	public void propertyChange(PropertyChangeEvent e) {
	    String prop = e.getPropertyName();
	    if(prop == JFileChooser.CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY) {
		filters = (FileFilter[]) e.getNewValue();
		fireContentsChanged(this, -1, -1);
	    }
	}

	public void setSelectedItem(Object filter) {
	    if(filter != null) {
		getFileChooser().setFileFilter((FileFilter) filter);
		fireContentsChanged(this, -1, -1);
	    }
	}

	public Object getSelectedItem() {
	    // Ensure that the current filter is in the list.
	    // NOTE: we shouldnt' have to do this, since JFileChooser adds
	    // the filter to the choosable filters list when the filter
	    // is set. Lets be paranoid just in case someone overrides
	    // setFileFilter in JFileChooser.
	    FileFilter currentFilter = getFileChooser().getFileFilter();
	    boolean found = false;
	    if(currentFilter != null) {
		for(int i=0; i < filters.length; i++) {
		    if(filters[i] == currentFilter) {
			found = true;
		    }
		}
		if(found == false) {
		    getFileChooser().addChoosableFileFilter(currentFilter);
		}
	    }
	    return getFileChooser().getFileFilter();
	}
	
	public int getSize() {
	    if(filters != null) {
		return filters.length;
	    } else {
		return 0;
	    }
	}

	public Object getElementAt(int index) {
	    if(index > getSize() - 1) {
		// This shouldn't happen. Try to recover gracefully.
		return getFileChooser().getFileFilter();
	    }
	    if(filters != null) {
		return filters[index];
	    } else {
		return null;
	    }
	}
    }
					
}
